/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.VenmoAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.VenmoAccountPayload;
import haveno.core.payment.validation.EmailOrMobileNrOrUsernameValidator;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public class VenmoForm
extends PaymentMethodForm {
    private final VenmoAccount venmoAccount;
    private final EmailOrMobileNrOrUsernameValidator venmoValidator;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, Res.get((String)"payment.email.mobile.username"), ((VenmoAccountPayload)paymentAccountPayload).getEmailOrMobileNrOrUsername());
        return gridRow;
    }

    public VenmoForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, EmailOrMobileNrOrUsernameValidator venmoValidator, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.venmoAccount = (VenmoAccount)paymentAccount;
        this.venmoValidator = venmoValidator;
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow + 1;
        InputTextField mobileNrInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.email.mobile.username"));
        mobileNrInputTextField.setValidator((InputValidator)this.venmoValidator);
        mobileNrInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.venmoAccount.setNameOrUsernameOrEmailOrMobileNr(newValue.trim());
            this.updateFromInputs();
        });
        TradeCurrency singleTradeCurrency = this.venmoAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "";
        FormBuilder.addTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.venmoAccount.getNameOrUsernameOrEmailOrMobileNr());
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.venmoAccount.getPaymentMethod().getId()));
        TextField field = (TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.email.mobile.username"), (String)this.venmoAccount.getNameOrUsernameOrEmailOrMobileNr()).second;
        field.setMouseTransparent(false);
        TradeCurrency singleTradeCurrency = this.venmoAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "";
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        this.addLimitations(true);
    }

    @Override
    public void updateAllInputsValid() {
        this.allInputsValid.set(this.isAccountNameValid() && this.venmoValidator.validate((String)this.venmoAccount.getNameOrUsernameOrEmailOrMobileNr()).isValid && this.venmoAccount.getTradeCurrencies().size() > 0);
    }
}

