/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.UpholdAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.UpholdAccountPayload;
import haveno.core.payment.validation.UpholdValidator;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import javafx.scene.control.TextField;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;

public class UpholdForm
extends PaymentMethodForm {
    private final UpholdAccount upholdAccount;
    private final UpholdValidator upholdValidator;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        String accountOwner = ((UpholdAccountPayload)paymentAccountPayload).getAccountOwner();
        if (accountOwner.isEmpty()) {
            accountOwner = Res.get((String)"payment.ask");
        }
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, Res.get((String)"payment.account.owner"), accountOwner);
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, Res.get((String)"payment.uphold.accountId"), ((UpholdAccountPayload)paymentAccountPayload).getAccountId());
        return gridRow;
    }

    public UpholdForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, UpholdValidator upholdValidator, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.upholdAccount = (UpholdAccount)paymentAccount;
        this.upholdValidator = upholdValidator;
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow + 1;
        InputTextField holderNameInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"));
        holderNameInputTextField.setValidator(this.inputValidator);
        holderNameInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.upholdAccount.setAccountOwner(newValue);
            this.updateFromInputs();
        });
        InputTextField accountIdInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.uphold.accountId"));
        accountIdInputTextField.setValidator((InputValidator)this.upholdValidator);
        accountIdInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.upholdAccount.setAccountId(newValue.trim());
            this.updateFromInputs();
        });
        this.addCurrenciesGrid(true);
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    private void addCurrenciesGrid(boolean isEditable) {
        FlowPane flowPane = (FlowPane)FormBuilder.addTopLabelFlowPane((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.supportedCurrencies"), (double)0.0).second;
        if (isEditable) {
            flowPane.setId("flow-pane-checkboxes-bg");
        } else {
            flowPane.setId("flow-pane-checkboxes-non-editable-bg");
        }
        this.paymentAccount.getSupportedCurrencies().forEach(e -> this.fillUpFlowPaneWithCurrencies(isEditable, flowPane, (TradeCurrency)e, (PaymentAccount)this.upholdAccount));
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.upholdAccount.getAccountId());
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.upholdAccount.getPaymentMethod().getId()));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"), this.upholdAccount.getAccountOwner());
        TextField field = (TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.uphold.accountId"), (String)this.upholdAccount.getAccountId()).second;
        field.setMouseTransparent(false);
        this.addLimitations(true);
        this.addCurrenciesGrid(false);
    }

    @Override
    public void updateAllInputsValid() {
        this.allInputsValid.set(this.isAccountNameValid() && this.upholdValidator.validate((String)this.upholdAccount.getAccountId()).isValid && this.upholdAccount.getTradeCurrencies().size() > 0);
    }
}

