/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.USPostalMoneyOrderAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.USPostalMoneyOrderAccountPayload;
import haveno.core.payment.validation.USPostalMoneyOrderValidator;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;

public class USPostalMoneyOrderForm
extends PaymentMethodForm {
    private final USPostalMoneyOrderAccount usPostalMoneyOrderAccount;
    private final USPostalMoneyOrderValidator usPostalMoneyOrderValidator;
    private TextArea postalAddressTextArea;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, Res.get((String)"payment.account.owner"), ((USPostalMoneyOrderAccountPayload)paymentAccountPayload).getHolderName());
        TextArea textArea = (TextArea)FormBuilder.addCompactTopLabelTextArea((GridPane)gridPane, (int)(++gridRow), (String)Res.get((String)"payment.postal.address"), (String)"").second;
        textArea.setMinHeight(70.0);
        textArea.setEditable(false);
        textArea.setId("text-area-disabled");
        textArea.setText(((USPostalMoneyOrderAccountPayload)paymentAccountPayload).getPostalAddress());
        return gridRow;
    }

    public USPostalMoneyOrderForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, USPostalMoneyOrderValidator usPostalMoneyOrderValidator, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.usPostalMoneyOrderAccount = (USPostalMoneyOrderAccount)paymentAccount;
        this.usPostalMoneyOrderValidator = usPostalMoneyOrderValidator;
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow + 1;
        InputTextField holderNameInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"));
        holderNameInputTextField.setValidator(this.inputValidator);
        holderNameInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.usPostalMoneyOrderAccount.setHolderName(newValue);
            this.updateFromInputs();
        });
        this.postalAddressTextArea = (TextArea)FormBuilder.addTopLabelTextArea((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.postal.address"), (String)"").second;
        this.postalAddressTextArea.setMinHeight(70.0);
        this.postalAddressTextArea.textProperty().addListener((ov, oldValue, newValue) -> {
            this.usPostalMoneyOrderAccount.setPostalAddress(newValue);
            this.updateFromInputs();
        });
        TradeCurrency singleTradeCurrency = this.usPostalMoneyOrderAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "null";
        FormBuilder.addTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.usPostalMoneyOrderAccount.getPostalAddress());
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.usPostalMoneyOrderAccount.getPaymentMethod().getId()));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"), this.usPostalMoneyOrderAccount.getHolderName());
        TextArea textArea = (TextArea)FormBuilder.addCompactTopLabelTextArea((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.postal.address"), (String)"").second;
        textArea.setText(this.usPostalMoneyOrderAccount.getPostalAddress());
        textArea.setMinHeight(70.0);
        textArea.setEditable(false);
        TradeCurrency singleTradeCurrency = this.usPostalMoneyOrderAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "null";
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        this.addLimitations(true);
    }

    @Override
    public void updateAllInputsValid() {
        this.allInputsValid.set(this.isAccountNameValid() && this.usPostalMoneyOrderValidator.validate((String)this.usPostalMoneyOrderAccount.getPostalAddress()).isValid && !this.usPostalMoneyOrderAccount.getPostalAddress().isEmpty() && this.inputValidator.validate((String)this.usPostalMoneyOrderAccount.getHolderName()).isValid && this.usPostalMoneyOrderAccount.getTradeCurrencies().size() > 0);
    }
}

