/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.common.util.Utilities;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.Res;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.TransferwiseUsdAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.TransferwiseUsdAccountPayload;
import haveno.core.payment.validation.EmailValidator;
import haveno.core.payment.validation.LengthValidator;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;

public class TransferwiseUsdForm
extends PaymentMethodForm {
    private final TransferwiseUsdAccount account;
    private final LengthValidator addressValidator = new LengthValidator(0, 100);
    private final EmailValidator emailValidator = new EmailValidator();

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        FormBuilder.addTopLabelTextFieldWithCopyIcon(gridPane, gridRow, 1, Res.get((String)"payment.account.owner"), ((TransferwiseUsdAccountPayload)paymentAccountPayload).getHolderName(), 50.0);
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, 1, Res.get((String)"payment.email"), ((TransferwiseUsdAccountPayload)paymentAccountPayload).getEmail());
        String address = ((TransferwiseUsdAccountPayload)paymentAccountPayload).getHolderAddress();
        if (address.length() > 0) {
            TextArea textAddress = (TextArea)FormBuilder.addCompactTopLabelTextArea((GridPane)gridPane, (int)gridRow, (int)0, (String)Res.get((String)"payment.account.address"), (String)"").second;
            textAddress.setMinHeight(70.0);
            textAddress.setEditable(false);
            textAddress.setText(address);
        }
        return gridRow;
    }

    public TransferwiseUsdForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.account = (TransferwiseUsdAccount)paymentAccount;
    }

    @Override
    public void addFormForAddAccount() {
        CountryUtil.findCountryByCode((String)"US").ifPresent(arg_0 -> ((TransferwiseUsdAccount)this.account).setCountry(arg_0));
        this.gridRowFrom = this.gridRow + 1;
        InputTextField emailField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.email"));
        emailField.setValidator((InputValidator)this.emailValidator);
        emailField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.account.setEmail(newValue.trim());
            this.updateFromInputs();
        });
        InputTextField holderNameField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"));
        holderNameField.setValidator(this.inputValidator);
        holderNameField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.account.setHolderName(newValue.trim());
            this.updateFromInputs();
        });
        String addressLabel = Res.get((String)"payment.account.owner.address") + " " + Res.get((String)"payment.transferwiseUsd.address");
        TextArea addressTextArea = (TextArea)FormBuilder.addTopLabelTextArea((GridPane)this.gridPane, (int)(++this.gridRow), (String)addressLabel, (String)addressLabel).second;
        addressTextArea.setMinHeight(70.0);
        addressTextArea.textProperty().addListener((ov, oldValue, newValue) -> {
            this.account.setBeneficiaryAddress(newValue.trim());
            this.updateFromInputs();
        });
        FormBuilder.addTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), this.account.getSingleTradeCurrency().getNameAndCode());
        FormBuilder.addTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.country"), this.account.getCountry().name);
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.account.getHolderName());
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.account.getPaymentMethod().getId()));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.email"), this.account.getEmail());
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"), this.account.getHolderName());
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.address"), Utilities.cleanString((String)this.account.getBeneficiaryAddress()));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), this.account.getSingleTradeCurrency().getNameAndCode());
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.country"), this.account.getCountry().name);
        this.addLimitations(true);
    }

    @Override
    public void updateAllInputsValid() {
        this.allInputsValid.set(this.isAccountNameValid() && this.emailValidator.validate((String)this.account.getEmail()).isValid && this.inputValidator.validate((String)this.account.getHolderName()).isValid && this.addressValidator.validate((String)this.account.getBeneficiaryAddress()).isValid);
    }
}

