/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.Res;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.TikkieAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.TikkieAccountPayload;
import haveno.core.payment.validation.IBANValidator;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public class TikkieForm
extends PaymentMethodForm {
    private final TikkieAccount account;
    private final IBANValidator ibanValidator = new IBANValidator("NL");

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, 0, Res.get((String)"payment.tikkie.iban"), ((TikkieAccountPayload)paymentAccountPayload).getIban());
        return gridRow;
    }

    public TikkieForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.account = (TikkieAccount)paymentAccount;
    }

    @Override
    public void addFormForAddAccount() {
        CountryUtil.findCountryByCode((String)"NL").ifPresent(arg_0 -> ((TikkieAccount)this.account).setCountry(arg_0));
        this.gridRowFrom = this.gridRow + 1;
        InputTextField ibanField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.tikkie.iban"));
        ibanField.setValidator((InputValidator)this.ibanValidator);
        ibanField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.account.setIban(newValue.trim());
            this.updateFromInputs();
        });
        FormBuilder.addTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), this.account.getSingleTradeCurrency().getNameAndCode());
        FormBuilder.addTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.country"), this.account.getCountry().name);
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.account.getIban());
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.account.getPaymentMethod().getId()));
        ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.tikkie.iban"), (String)this.account.getIban()).second).setMouseTransparent(false);
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), this.account.getSingleTradeCurrency().getNameAndCode());
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.country"), this.account.getCountry().name);
        this.addLimitations(true);
    }

    @Override
    public void updateAllInputsValid() {
        this.allInputsValid.set(this.isAccountNameValid() && this.ibanValidator.validate((String)this.account.getIban()).isValid);
    }
}

