/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.SwishAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.SwishAccountPayload;
import haveno.core.payment.validation.SwishValidator;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwishForm
extends PaymentMethodForm {
    private static final Logger log = LoggerFactory.getLogger(SwishForm.class);
    private final SwishAccount swishAccount;
    private final SwishValidator swishValidator;

    public SwishForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, SwishValidator swishValidator, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.swishAccount = (SwishAccount)paymentAccount;
        this.swishValidator = swishValidator;
    }

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, Res.get((String)"payment.account.owner"), ((SwishAccountPayload)paymentAccountPayload).getHolderName());
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, gridRow, 1, Res.get((String)"payment.mobile"), ((SwishAccountPayload)paymentAccountPayload).getMobileNr());
        return gridRow;
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow + 1;
        InputTextField holderNameInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"));
        holderNameInputTextField.setValidator(this.inputValidator);
        holderNameInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.swishAccount.setHolderName(newValue);
            this.updateFromInputs();
        });
        InputTextField mobileNrInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.mobile"));
        mobileNrInputTextField.setValidator((InputValidator)this.swishValidator);
        mobileNrInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.swishAccount.setMobileNr(newValue);
            this.updateFromInputs();
        });
        TradeCurrency singleTradeCurrency = this.swishAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "null";
        FormBuilder.addTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.swishAccount.getMobileNr());
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.swishAccount.getPaymentMethod().getId()));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"), this.swishAccount.getHolderName());
        TextField field = (TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.mobile"), (String)this.swishAccount.getMobileNr()).second;
        field.setMouseTransparent(false);
        TradeCurrency singleTradeCurrency = this.swishAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "null";
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        this.addLimitations(true);
    }

    @Override
    public void updateAllInputsValid() {
        if (this.swishValidator.validate((String)this.swishAccount.getMobileNr()).isValid) {
            this.swishAccount.setMobileNr(this.swishValidator.getNormalizedPhoneNumber());
        }
        this.allInputsValid.set(this.isAccountNameValid() && this.swishValidator.validate((String)this.swishAccount.getMobileNr()).isValid && this.inputValidator.validate((String)this.swishAccount.getHolderName()).isValid && this.swishAccount.getTradeCurrencies().size() > 0);
    }
}

