/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import com.jfoenix.controls.JFXTextArea;
import haveno.common.util.Utilities;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Country;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.Res;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.SwiftAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.SwiftAccountPayload;
import haveno.core.payment.validation.LengthValidator;
import haveno.core.trade.Trade;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipCheckBox;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.main.overlays.windows.SwiftPaymentDetails;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import java.util.function.Consumer;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;

public class SwiftForm
extends PaymentMethodForm {
    private final SwiftAccountPayload formData;
    private final AutoTooltipCheckBox useIntermediaryCheck;
    private final LengthValidator defaultValidator = new LengthValidator(2, 34);
    private final LengthValidator swiftValidator = new LengthValidator(11, 11);
    private final LengthValidator accountNrValidator = new LengthValidator(2, 40);
    private final LengthValidator addressValidator = new LengthValidator(1, 100);

    public SwiftForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator defaultValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, defaultValidator, gridPane, gridRow, formatter);
        this.formData = ((SwiftAccount)paymentAccount).getPayload();
        this.useIntermediaryCheck = new AutoTooltipCheckBox(Res.get((String)"payment.swift.use.intermediary"));
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow + 1;
        this.addFieldsForBankEdit(true, this::setBankSwiftCode, this::setBankName, this::setBankBranch, this::setBankAddress);
        this.addFieldsForBankEdit(false, this::setIntermediarySwiftCode, this::setIntermediaryName, this::setIntermediaryBranch, this::setIntermediaryAddress);
        this.addFieldsForBeneficiaryEdit();
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.formData.getBeneficiaryName());
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.paymentAccount.getPaymentMethod().getId()));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.swift.swiftCode.bank"), this.formData.getBankSwiftCode());
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.swift.country.bank"), CountryUtil.getNameAndCode((String)this.formData.getBankCountryCode()));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.swift.name.bank"), this.formData.getBankName());
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.swift.branch.bank"), this.formData.getBankBranch());
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.swift.address.bank"), Utilities.cleanString((String)this.formData.getBankAddress()));
        if (this.formData.usesIntermediaryBank()) {
            FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.swift.swiftCode.intermediary"), this.formData.getIntermediarySwiftCode(), 20.0);
            FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.swift.country.intermediary"), CountryUtil.getNameAndCode((String)this.formData.getIntermediaryCountryCode()));
            FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.swift.name.intermediary"), this.formData.getIntermediaryName());
            FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.swift.branch.intermediary"), this.formData.getIntermediaryBranch());
            FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.swift.address.intermediary"), Utilities.cleanString((String)this.formData.getIntermediaryAddress()));
        }
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"), this.formData.getBeneficiaryName(), 20.0);
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.swift.account"), this.formData.getBeneficiaryAccountNr());
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.swift.address.beneficiary"), Utilities.cleanString((String)this.formData.getBeneficiaryAddress()));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.swift.phone.beneficiary"), this.formData.getBeneficiaryPhone());
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.city"), this.formData.getBeneficiaryCity());
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.country"), CountryUtil.getNameAndCode((String)this.formData.getBankCountryCode()));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.shared.extraInfo"), Utilities.cleanString((String)this.formData.getSpecialInstructions()));
        this.gridPane.add((Node)new Label(""), 0, ++this.gridRow);
        this.addLimitations(true);
    }

    @Override
    public void updateAllInputsValid() {
        SwiftAccountPayload data = this.formData;
        boolean intermediaryValidIfSpecified = !this.useIntermediaryCheck.isSelected() && !data.usesIntermediaryBank() || data.usesIntermediaryBank() && this.swiftValidator.validate((String)data.getIntermediarySwiftCode()).isValid && this.defaultValidator.validate((String)data.getIntermediaryCountryCode()).isValid && this.defaultValidator.validate((String)data.getIntermediaryName()).isValid && this.defaultValidator.validate((String)data.getIntermediaryBranch()).isValid && this.addressValidator.validate((String)data.getIntermediaryAddress()).isValid;
        this.allInputsValid.set(this.isAccountNameValid() && this.swiftValidator.validate((String)data.getBankSwiftCode()).isValid && this.defaultValidator.validate((String)data.getBankCountryCode()).isValid && this.defaultValidator.validate((String)data.getBankName()).isValid && this.defaultValidator.validate((String)data.getBankBranch()).isValid && this.addressValidator.validate((String)data.getBankAddress()).isValid && this.defaultValidator.validate((String)data.getBeneficiaryName()).isValid && this.accountNrValidator.validate((String)data.getBeneficiaryAccountNr()).isValid && this.addressValidator.validate((String)data.getBeneficiaryAddress()).isValid && this.defaultValidator.validate((String)data.getBeneficiaryPhone()).isValid && this.defaultValidator.validate((String)data.getBeneficiaryCity()).isValid && this.paymentAccount.getTradeCurrencies().size() > 0 && intermediaryValidIfSpecified);
    }

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload, Trade trade) {
        SwiftAccountPayload swiftAccountPayload = (SwiftAccountPayload)paymentAccountPayload;
        AutoTooltipButton button = new AutoTooltipButton(Res.get((String)"payment.swift.showPaymentInfo"));
        GridPane.setRowIndex((Node)button, (Integer)gridRow);
        GridPane.setColumnIndex((Node)button, (Integer)1);
        gridPane.getChildren().add((Object)button);
        GridPane.setMargin((Node)button, (Insets)new Insets(80.0, 0.0, 0.0, 23.0));
        button.setOnAction(e -> new SwiftPaymentDetails(swiftAccountPayload, trade).show());
        return gridRow;
    }

    private void addFieldsForBankEdit(boolean isPrimary, Consumer<String> onSwiftCodeSelected, Consumer<String> onNameSelected, Consumer<String> onBranchSelected, Consumer<String> onAddressSelected) {
        GridPane gridPane2 = new GridPane();
        gridPane2.getColumnConstraints().add((Object)((ColumnConstraints)this.gridPane.getColumnConstraints().get(0)));
        TitledPane titledPane = new TitledPane(isPrimary ? Res.get((String)"payment.swift.title.bank") : Res.get((String)"payment.swift.title.intermediary"), (Node)gridPane2);
        titledPane.setExpanded(isPrimary);
        this.gridPane.add((Node)titledPane, 0, ++this.gridRow);
        int gridRow2 = 0;
        if (!isPrimary) {
            gridPane2.add((Node)this.useIntermediaryCheck, 0, ++gridRow2);
        }
        String label = isPrimary ? Res.get((String)"payment.swift.swiftCode.bank") : Res.get((String)"payment.swift.swiftCode.intermediary");
        InputTextField bankSwiftCodeField = FormBuilder.addInputTextField(gridPane2, ++gridRow2, label);
        bankSwiftCodeField.setPromptText(label);
        bankSwiftCodeField.setValidator((InputValidator)this.swiftValidator);
        bankSwiftCodeField.textProperty().addListener((ov, oldValue, newValue) -> onSwiftCodeSelected.accept((String)newValue));
        if (isPrimary) {
            gridRow2 = GUIUtil.addRegionCountry(gridPane2, gridRow2, this::setBankCountry);
        } else {
            ++gridRow2;
            gridRow2 = GUIUtil.addRegionCountry(gridPane2, gridRow2, this::setIntermediaryCountry);
        }
        label = isPrimary ? Res.get((String)"payment.swift.name.bank") : Res.get((String)"payment.swift.name.intermediary");
        InputTextField bankNameField = FormBuilder.addInputTextField(gridPane2, ++gridRow2, label);
        bankNameField.setPromptText(label);
        bankNameField.setValidator((InputValidator)this.defaultValidator);
        bankNameField.textProperty().addListener((ov, oldValue, newValue) -> onNameSelected.accept((String)newValue));
        label = isPrimary ? Res.get((String)"payment.swift.branch.bank") : Res.get((String)"payment.swift.branch.intermediary");
        InputTextField bankBranchField = FormBuilder.addInputTextField(gridPane2, ++gridRow2, label);
        bankBranchField.setPromptText(label);
        bankBranchField.setValidator((InputValidator)this.defaultValidator);
        bankBranchField.textProperty().addListener((ov, oldValue, newValue) -> onBranchSelected.accept((String)newValue));
        label = isPrimary ? Res.get((String)"payment.swift.address.bank") : Res.get((String)"payment.swift.address.intermediary");
        TextArea bankAddressTextArea = (TextArea)FormBuilder.addTopLabelTextArea((GridPane)gridPane2, (int)(++gridRow2), (String)label, (String)label).second;
        bankAddressTextArea.setMinHeight(70.0);
        bankAddressTextArea.textProperty().addListener((ov, oldValue, newValue) -> onAddressSelected.accept((String)newValue));
        if (!isPrimary) {
            this.useIntermediaryCheck.setOnAction(e -> {
                for (Node x : gridPane2.getChildren()) {
                    if (x == this.useIntermediaryCheck) continue;
                    x.setDisable(!this.useIntermediaryCheck.isSelected());
                }
                if (!this.useIntermediaryCheck.isSelected()) {
                    bankSwiftCodeField.setText("");
                    bankNameField.setText("");
                    bankBranchField.setText("");
                    bankAddressTextArea.setText("");
                }
                this.updateFromInputs();
            });
            for (Node x : gridPane2.getChildren()) {
                if (x == this.useIntermediaryCheck) continue;
                x.setDisable(!this.useIntermediaryCheck.isSelected());
            }
        }
    }

    private void addFieldsForBeneficiaryEdit() {
        String label = Res.get((String)"payment.account.owner");
        InputTextField beneficiaryNameField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, label);
        beneficiaryNameField.setPromptText(label);
        beneficiaryNameField.setValidator((InputValidator)this.defaultValidator);
        beneficiaryNameField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.formData.setBeneficiaryName(newValue.trim());
            this.updateFromInputs();
        });
        label = Res.get((String)"payment.swift.account");
        InputTextField beneficiaryAccountNrField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, label);
        beneficiaryAccountNrField.setPromptText(label);
        beneficiaryAccountNrField.setValidator((InputValidator)this.defaultValidator);
        beneficiaryAccountNrField.setValidator((InputValidator)this.accountNrValidator);
        beneficiaryAccountNrField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.formData.setBeneficiaryAccountNr(newValue.trim());
            this.updateFromInputs();
        });
        label = Res.get((String)"payment.swift.address.beneficiary");
        TextArea beneficiaryAddressTextArea = (TextArea)FormBuilder.addTopLabelTextArea((GridPane)this.gridPane, (int)(++this.gridRow), (String)label, (String)label).second;
        beneficiaryAddressTextArea.setMinHeight(70.0);
        beneficiaryAddressTextArea.textProperty().addListener((ov, oldValue, newValue) -> {
            this.formData.setBeneficiaryAddress(newValue.trim());
            this.updateFromInputs();
        });
        label = Res.get((String)"payment.account.city");
        InputTextField beneficiaryCityField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, label);
        beneficiaryCityField.setPromptText(label);
        beneficiaryCityField.setValidator((InputValidator)this.defaultValidator);
        beneficiaryCityField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.formData.setBeneficiaryCity(newValue.trim());
            this.updateFromInputs();
        });
        label = Res.get((String)"payment.swift.phone.beneficiary");
        InputTextField beneficiaryPhoneField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, label);
        beneficiaryPhoneField.setPromptText(label);
        beneficiaryPhoneField.setValidator((InputValidator)this.defaultValidator);
        beneficiaryPhoneField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.formData.setBeneficiaryPhone(newValue.trim());
            this.updateFromInputs();
        });
        label = Res.get((String)"payment.shared.optionalExtra");
        TextArea extraTextArea = (TextArea)FormBuilder.addTopLabelTextArea((GridPane)this.gridPane, (int)(++this.gridRow), (String)label, (String)label).second;
        extraTextArea.setMinHeight(70.0);
        ((JFXTextArea)extraTextArea).setLabelFloat(false);
        extraTextArea.textProperty().addListener((ov, oldValue, newValue) -> {
            this.formData.setSpecialInstructions(newValue.trim());
            this.updateFromInputs();
        });
    }

    private void setBankSwiftCode(String value) {
        this.formData.setBankSwiftCode(value.trim());
        this.updateFromInputs();
    }

    private void setBankName(String value) {
        this.formData.setBankName(value.trim());
        this.updateFromInputs();
    }

    private void setBankBranch(String value) {
        this.formData.setBankBranch(value.trim());
        this.updateFromInputs();
    }

    private void setBankAddress(String value) {
        this.formData.setBankAddress(value.trim());
        this.updateFromInputs();
    }

    private void setIntermediarySwiftCode(String value) {
        this.formData.setIntermediarySwiftCode(value.trim());
        this.updateFromInputs();
    }

    private void setIntermediaryName(String value) {
        this.formData.setIntermediaryName(value.trim());
        this.updateFromInputs();
    }

    private void setIntermediaryBranch(String value) {
        this.formData.setIntermediaryBranch(value.trim());
        this.updateFromInputs();
    }

    private void setIntermediaryAddress(String value) {
        this.formData.setIntermediaryAddress(value.trim());
        this.updateFromInputs();
    }

    private void setBankCountry(Country country) {
        if (country == null) {
            return;
        }
        this.formData.setBankCountryCode(country.code);
        this.updateFromInputs();
    }

    private void setIntermediaryCountry(Country country) {
        if (country == null) {
            return;
        }
        this.formData.setIntermediaryCountryCode(country.code);
        this.updateFromInputs();
    }
}

