/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.Res;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.StrikeAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.StrikeAccountPayload;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public class StrikeForm
extends PaymentMethodForm {
    private final StrikeAccount account;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        FormBuilder.addTopLabelTextFieldWithCopyIcon(gridPane, gridRow, 1, Res.get((String)"payment.account.username"), ((StrikeAccountPayload)paymentAccountPayload).getHolderName(), 50.0);
        return gridRow;
    }

    public StrikeForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.account = (StrikeAccount)paymentAccount;
    }

    @Override
    public void addFormForAddAccount() {
        CountryUtil.findCountryByCode((String)"US").ifPresent(arg_0 -> ((StrikeAccount)this.account).setCountry(arg_0));
        this.gridRowFrom = this.gridRow + 1;
        InputTextField holderNameField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.username"));
        holderNameField.setValidator(this.inputValidator);
        holderNameField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.account.setHolderName(newValue.trim());
            this.updateFromInputs();
        });
        FormBuilder.addTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), this.account.getSingleTradeCurrency().getNameAndCode());
        FormBuilder.addTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.country"), this.account.getCountry().name);
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.account.getHolderName());
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.account.getPaymentMethod().getId()));
        TextField field = (TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.account.username"), (String)this.account.getHolderName()).second;
        field.setMouseTransparent(false);
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), this.account.getSingleTradeCurrency().getNameAndCode());
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.country"), this.account.getCountry().name);
        this.addLimitations(true);
    }

    @Override
    public void updateAllInputsValid() {
        this.allInputsValid.set(this.isAccountNameValid() && this.inputValidator.validate((String)this.account.getHolderName()).isValid);
    }
}

