/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import com.google.common.base.Joiner;
import haveno.common.util.Tuple3;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.SpecificBanksAccountPayload;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.BankForm;
import haveno.desktop.util.FormBuilder;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;

public class SpecificBankForm
extends BankForm {
    private final SpecificBanksAccountPayload specificBanksAccountPayload;
    private TextField acceptedBanksTextField;
    private Tooltip acceptedBanksTooltip;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        return BankForm.addFormForBuyer(gridPane, gridRow, paymentAccountPayload);
    }

    public SpecificBankForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.specificBanksAccountPayload = (SpecificBanksAccountPayload)paymentAccount.paymentAccountPayload;
    }

    @Override
    protected void addAcceptedBanksForAddAccount() {
        Tuple3<Label, InputTextField, Button> addBankTuple = FormBuilder.addTopLabelInputTextFieldButton(this.gridPane, ++this.gridRow, Res.get((String)"payment.nameOfAcceptedBank"), Res.get((String)"payment.addAcceptedBank"));
        InputTextField addBankInputTextField = (InputTextField)((Object)addBankTuple.second);
        Button addButton = (Button)addBankTuple.third;
        addButton.setMinWidth(200.0);
        addButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> addBankInputTextField.getText().isEmpty(), (Observable[])new Observable[]{addBankInputTextField.textProperty()}));
        Tuple3<Label, TextField, Button> acceptedBanksTuple = FormBuilder.addTopLabelTextFieldButton(this.gridPane, ++this.gridRow, Res.get((String)"payment.accepted.banks"), Res.get((String)"payment.clearAcceptedBanks"));
        this.acceptedBanksTextField = (TextField)acceptedBanksTuple.second;
        this.acceptedBanksTextField.setMouseTransparent(false);
        this.acceptedBanksTooltip = new Tooltip();
        this.acceptedBanksTextField.setTooltip(this.acceptedBanksTooltip);
        Button clearButton = (Button)acceptedBanksTuple.third;
        clearButton.setMinWidth(200.0);
        clearButton.setDefaultButton(false);
        clearButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.acceptedBanksTextField.getText().isEmpty(), (Observable[])new Observable[]{this.acceptedBanksTextField.textProperty()}));
        addButton.setOnAction(e -> {
            this.specificBanksAccountPayload.addAcceptedBank(addBankInputTextField.getText());
            addBankInputTextField.setText("");
            String value = Joiner.on((String)", ").join((Iterable)this.specificBanksAccountPayload.getAcceptedBanks());
            this.acceptedBanksTextField.setText(value);
            this.acceptedBanksTooltip.setText(value);
            this.updateAllInputsValid();
        });
        clearButton.setOnAction(e -> this.resetAcceptedBanks());
    }

    private void resetAcceptedBanks() {
        this.specificBanksAccountPayload.clearAcceptedBanks();
        this.acceptedBanksTextField.setText("");
        this.acceptedBanksTooltip.setText("");
        this.updateAllInputsValid();
    }

    @Override
    protected void onCountryChanged() {
        this.resetAcceptedBanks();
    }

    @Override
    public void addAcceptedBanksForDisplayAccount() {
        ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.accepted.banks"), (String)Joiner.on((String)", ").join((Iterable)this.specificBanksAccountPayload.getAcceptedBanks())).second).setMouseTransparent(false);
    }

    @Override
    public void updateAllInputsValid() {
        super.updateAllInputsValid();
        this.allInputsValid.set(this.allInputsValid.get() && this.inputValidator.validate((String)this.acceptedBanksTextField.getText()).isValid);
    }
}

