/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Country;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.SepaInstantAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.SepaInstantAccountPayload;
import haveno.core.payment.validation.BICValidator;
import haveno.core.payment.validation.SepaIBANValidator;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.GeneralSepaForm;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.normalization.IBANNormalizer;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.GridPane;
import javafx.util.StringConverter;

public class SepaInstantForm
extends GeneralSepaForm {
    private final SepaInstantAccount sepaInstantAccount;
    private final SepaIBANValidator sepaIBANValidator;
    private final BICValidator bicValidator;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        SepaInstantAccountPayload sepaInstantAccountPayload = (SepaInstantAccountPayload)paymentAccountPayload;
        String title = Res.get((String)"payment.account.owner");
        String value = sepaInstantAccountPayload.getHolderName();
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, title, value);
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, gridRow, 1, Res.get((String)"payment.bank.country"), CountryUtil.getNameAndCode((String)sepaInstantAccountPayload.getCountryCode()));
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, "IBAN", sepaInstantAccountPayload.getIban());
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, gridRow, 1, "BIC", sepaInstantAccountPayload.getBic());
        return gridRow;
    }

    public SepaInstantForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, BICValidator bicValidator, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.sepaInstantAccount = (SepaInstantAccount)paymentAccount;
        this.sepaIBANValidator = new SepaIBANValidator();
        this.bicValidator = bicValidator;
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow + 1;
        InputTextField holderNameInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"));
        holderNameInputTextField.setValidator(this.inputValidator);
        holderNameInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.sepaInstantAccount.setHolderName(newValue);
            this.updateFromInputs();
        });
        InputTextField ibanInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, "IBAN");
        ibanInputTextField.setTextFormatter(new TextFormatter((StringConverter)new IBANNormalizer()));
        ibanInputTextField.setValidator((InputValidator)this.sepaIBANValidator);
        InputTextField bicInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, "BIC");
        bicInputTextField.setValidator((InputValidator)this.bicValidator);
        bicInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.sepaInstantAccount.setBic(newValue);
            this.updateFromInputs();
        });
        ComboBox<Country> countryComboBox = this.addCountrySelection();
        this.setCountryComboBoxAction(countryComboBox, (CountryBasedPaymentAccount)this.sepaInstantAccount);
        this.addCountriesGrid(Res.get((String)"payment.accept.euro"), CountryUtil.getAllSepaEuroCountries());
        this.addCountriesGrid(Res.get((String)"payment.accept.nonEuro"), CountryUtil.getAllSepaNonEuroCountries());
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        countryComboBox.setItems(FXCollections.observableArrayList((Collection)CountryUtil.getAllSepaInstantCountries()));
        Country country = CountryUtil.getDefaultCountry();
        if (CountryUtil.getAllSepaInstantCountries().contains(country)) {
            countryComboBox.getSelectionModel().select((Object)country);
            this.sepaInstantAccount.setCountry(country);
        }
        ibanInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.sepaInstantAccount.setIban(newValue);
            this.updateFromInputs();
            if (ibanInputTextField.validate()) {
                List countries = CountryUtil.getAllSepaCountries();
                String ibanCountryCode = newValue.substring(0, 2).toUpperCase();
                Optional<Country> ibanCountry = countries.stream().filter(c -> c.code.equals(ibanCountryCode)).findFirst();
                if (ibanCountry.isPresent()) {
                    countryComboBox.setValue((Object)ibanCountry.get());
                }
            }
        });
        countryComboBox.valueProperty().addListener((ov, oldValue, newValue) -> {
            this.sepaIBANValidator.setRestrictToCountry(newValue.code);
            ibanInputTextField.refreshValidation();
        });
        this.updateFromInputs();
    }

    @Override
    public void updateAllInputsValid() {
        this.allInputsValid.set(this.isAccountNameValid() && this.bicValidator.validate((String)this.sepaInstantAccount.getBic()).isValid && this.sepaIBANValidator.validate((String)this.sepaInstantAccount.getIban()).isValid && this.inputValidator.validate((String)this.sepaInstantAccount.getHolderName()).isValid && this.sepaInstantAccount.getAcceptedCountryCodes().size() > 0 && this.sepaInstantAccount.getSingleTradeCurrency() != null && this.sepaInstantAccount.getCountry() != null);
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.sepaInstantAccount.getPaymentMethod().getId()));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"), this.sepaInstantAccount.getHolderName());
        ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)"IBAN", (String)this.sepaInstantAccount.getIban()).second).setMouseTransparent(false);
        ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)"BIC", (String)this.sepaInstantAccount.getBic()).second).setMouseTransparent(false);
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.bank.country"), this.sepaInstantAccount.getCountry() != null ? this.sepaInstantAccount.getCountry().name : "");
        TradeCurrency singleTradeCurrency = this.sepaInstantAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "null";
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        this.addCountriesGrid(Res.get((String)"payment.accept.euro"), CountryUtil.getAllSepaEuroCountries());
        this.addCountriesGrid(Res.get((String)"payment.accept.nonEuro"), CountryUtil.getAllSepaNonEuroCountries());
        this.addLimitations(true);
    }

    @Override
    void removeAcceptedCountry(String countryCode) {
        this.sepaInstantAccount.removeAcceptedCountry(countryCode);
    }

    @Override
    void addAcceptedCountry(String countryCode) {
        this.sepaInstantAccount.addAcceptedCountry(countryCode);
    }

    @Override
    boolean isCountryAccepted(String countryCode) {
        return this.sepaInstantAccount.getAcceptedCountryCodes().contains(countryCode);
    }

    @Override
    protected String getIban() {
        return this.sepaInstantAccount.getIban();
    }
}

