/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.common.util.Tuple2;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.RevolutAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.RevolutAccountPayload;
import haveno.core.payment.validation.RevolutValidator;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import javafx.scene.control.TextField;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevolutForm
extends PaymentMethodForm {
    private static final Logger log = LoggerFactory.getLogger(RevolutForm.class);
    private final RevolutAccount account;
    private final RevolutValidator validator;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        Tuple2 tuple = ((RevolutAccountPayload)paymentAccountPayload).getRecipientsAccountData();
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, (String)tuple.first, (String)tuple.second);
        return gridRow;
    }

    public RevolutForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, RevolutValidator revolutValidator, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.account = (RevolutAccount)paymentAccount;
        this.validator = revolutValidator;
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow + 1;
        InputTextField userNameInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.username"));
        userNameInputTextField.setValidator((InputValidator)this.validator);
        userNameInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.account.setUsername(newValue.trim());
            this.updateFromInputs();
        });
        this.addCurrenciesGrid(true);
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    private void addCurrenciesGrid(boolean isEditable) {
        FlowPane flowPane = (FlowPane)FormBuilder.addTopLabelFlowPane((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.supportedCurrencies"), (double)69.0, (double)69.0).second;
        if (isEditable) {
            flowPane.setId("flow-pane-checkboxes-bg");
        } else {
            flowPane.setId("flow-pane-checkboxes-non-editable-bg");
        }
        this.account.getSupportedCurrencies().forEach(e -> this.fillUpFlowPaneWithCurrencies(isEditable, flowPane, (TradeCurrency)e, (PaymentAccount)this.account));
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.account.getUsername());
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.account.getPaymentMethod().getId()));
        String userName = this.account.getUsername();
        TextField userNameTf = (TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.account.username"), (String)userName).second;
        userNameTf.setMouseTransparent(false);
        this.addLimitations(true);
        this.addCurrenciesGrid(false);
    }

    @Override
    public void updateAllInputsValid() {
        this.allInputsValid.set(this.isAccountNameValid() && this.validator.validate((String)this.account.getUsername()).isValid && this.account.getTradeCurrencies().size() > 0);
    }
}

