/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.PixAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PixAccountPayload;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public class PixForm
extends PaymentMethodForm {
    private final PixAccount account;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        FormBuilder.addTopLabelTextFieldWithCopyIcon(gridPane, gridRow, 1, Res.get((String)"payment.pix.key"), ((PixAccountPayload)paymentAccountPayload).getPixKey(), 50.0);
        return gridRow;
    }

    public PixForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.account = (PixAccount)paymentAccount;
    }

    @Override
    public void addFormForAddAccount() {
        this.account.setSingleTradeCurrency((TradeCurrency)this.account.getSupportedCurrencies().get(0));
        CountryUtil.findCountryByCode((String)"BR").ifPresent(c -> this.account.setCountry(c));
        this.gridRowFrom = this.gridRow + 1;
        InputTextField pixKeyInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.pix.key"));
        pixKeyInputTextField.setValidator(this.inputValidator);
        pixKeyInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.account.setPixKey(newValue.trim());
            this.updateFromInputs();
        });
        FormBuilder.addTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), this.account.getSingleTradeCurrency().getNameAndCode());
        FormBuilder.addTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.country"), this.account.getCountry().name);
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.account.getPixKey());
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.account.getPaymentMethod().getId()));
        TextField field = (TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.pix.key"), (String)this.account.getPixKey()).second;
        field.setMouseTransparent(false);
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), this.account.getSingleTradeCurrency().getNameAndCode());
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.country"), this.account.getCountry().name);
        this.addLimitations(true);
    }

    @Override
    public void updateAllInputsValid() {
        this.allInputsValid.set(this.isAccountNameValid() && this.inputValidator.validate((String)this.account.getPixKey()).isValid);
    }
}

