/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.PerfectMoneyAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PerfectMoneyAccountPayload;
import haveno.core.payment.validation.PerfectMoneyValidator;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.paymentmethods.GeneralAccountNumberForm;
import haveno.desktop.util.FormBuilder;
import javafx.collections.FXCollections;
import javafx.scene.layout.GridPane;

public class PerfectMoneyForm
extends GeneralAccountNumberForm {
    private final PerfectMoneyAccount perfectMoneyAccount;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, Res.get((String)"payment.account.no"), ((PerfectMoneyAccountPayload)paymentAccountPayload).getAccountNr());
        return gridRow;
    }

    public PerfectMoneyForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, PerfectMoneyValidator perfectMoneyValidator, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.perfectMoneyAccount = (PerfectMoneyAccount)paymentAccount;
    }

    @Override
    public void addTradeCurrency() {
        this.addTradeCurrencyComboBox();
        this.currencyComboBox.setItems(FXCollections.observableArrayList((Object[])new TradeCurrency[]{new TraditionalCurrency("USD"), new TraditionalCurrency("EUR")}));
    }

    @Override
    void setAccountNumber(String newValue) {
        this.perfectMoneyAccount.setAccountNr(newValue);
    }

    @Override
    String getAccountNr() {
        return this.perfectMoneyAccount.getAccountNr();
    }
}

