/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import haveno.common.util.Tuple3;
import haveno.common.util.Utilities;
import haveno.core.account.witness.AccountAgeWitness;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.payment.AssetAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.trade.HavenoUtils;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.AutoTooltipCheckBox;
import haveno.desktop.components.InfoTextField;
import haveno.desktop.components.InputTextField;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PaymentMethodForm {
    private static final Logger log = LoggerFactory.getLogger(PaymentMethodForm.class);
    protected final PaymentAccount paymentAccount;
    private final AccountAgeWitnessService accountAgeWitnessService;
    protected final InputValidator inputValidator;
    protected final GridPane gridPane;
    protected int gridRow;
    private final CoinFormatter formatter;
    protected final BooleanProperty allInputsValid = new SimpleBooleanProperty();
    protected int gridRowFrom;
    InputTextField accountNameTextField;
    protected TextField paymentLimitationsTextField;
    ToggleButton useCustomAccountNameToggleButton;
    protected ComboBox<TradeCurrency> currencyComboBox;

    public PaymentMethodForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        this.paymentAccount = paymentAccount;
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.inputValidator = inputValidator;
        this.gridPane = gridPane;
        this.gridRow = gridRow;
        this.formatter = formatter;
    }

    protected void addTradeCurrencyComboBox() {
        this.currencyComboBox = FormBuilder.addComboBox(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"));
        this.currencyComboBox.setPromptText(Res.get((String)"list.currency.select"));
        this.currencyComboBox.setItems(FXCollections.observableArrayList((Collection)CurrencyUtil.getMainTraditionalCurrencies()));
        this.currencyComboBox.setConverter((StringConverter)new StringConverter<TradeCurrency>(this){

            public String toString(TradeCurrency tradeCurrency) {
                return tradeCurrency.getNameAndCode();
            }

            public TradeCurrency fromString(String s) {
                return null;
            }
        });
        this.currencyComboBox.setOnAction(e -> {
            this.paymentAccount.setSingleTradeCurrency((TradeCurrency)this.currencyComboBox.getSelectionModel().getSelectedItem());
            this.updateFromInputs();
        });
    }

    protected void addAccountNameTextFieldWithAutoFillToggleButton() {
        boolean isEditMode = this.paymentAccount.getPersistedAccountName() != null;
        Tuple3<Label, InputTextField, ToggleButton> tuple = FormBuilder.addTopLabelInputTextFieldSlideToggleButton(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.name"), Res.get((String)"payment.useCustomAccountName"));
        this.accountNameTextField = (InputTextField)((Object)tuple.second);
        this.accountNameTextField.setPrefWidth(300.0);
        this.accountNameTextField.setEditable(isEditMode);
        this.accountNameTextField.setValidator(this.inputValidator);
        this.accountNameTextField.setFocusTraversable(false);
        this.accountNameTextField.setText(this.paymentAccount.getAccountName());
        this.accountNameTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.paymentAccount.setAccountName(newValue);
            this.updateAllInputsValid();
        });
        this.useCustomAccountNameToggleButton = (ToggleButton)tuple.third;
        this.useCustomAccountNameToggleButton.setSelected(isEditMode);
        this.useCustomAccountNameToggleButton.setOnAction(e -> {
            boolean selected = this.useCustomAccountNameToggleButton.isSelected();
            this.accountNameTextField.setEditable(selected);
            this.accountNameTextField.setFocusTraversable(selected);
            this.autoFillNameTextField();
        });
    }

    public static InfoTextField addOpenTradeDuration(GridPane gridPane, int gridRow, Offer offer) {
        long hours = offer.getPaymentMethod().getMaxTradePeriod() / 3600000L;
        Tuple3<Label, InfoTextField, VBox> labelInfoTextFieldVBoxTuple3 = FormBuilder.addTopLabelInfoTextField(gridPane, gridRow, Res.get((String)"payment.maxPeriod"), PaymentMethodForm.getTimeText(hours), -23.0);
        return (InfoTextField)((Object)labelInfoTextFieldVBoxTuple3.second);
    }

    private static String getTimeText(long hours) {
        Object time = hours + " " + Res.get((String)"time.hours");
        if (hours == 1L) {
            time = Res.get((String)"time.1hour");
        } else if (hours == 24L) {
            time = Res.get((String)"time.1day");
        } else if (hours > 24L) {
            time = hours / 24L + " " + Res.get((String)"time.days");
        }
        return time;
    }

    protected String getLimitationsText() {
        PaymentAccount paymentAccount = this.getPaymentAccount();
        long hours = paymentAccount.getMaxTradePeriod() / 3600000L;
        TradeCurrency tradeCurrency = paymentAccount.getSingleTradeCurrency() != null ? paymentAccount.getSingleTradeCurrency() : (paymentAccount.getSelectedTradeCurrency() != null ? paymentAccount.getSelectedTradeCurrency() : (!paymentAccount.getTradeCurrencies().isEmpty() && paymentAccount.getTradeCurrencies().get(0) != null ? (TradeCurrency)paymentAccount.getTradeCurrencies().get(0) : (paymentAccount instanceof AssetAccount ? (TradeCurrency)CurrencyUtil.getAllSortedCryptoCurrencies().iterator().next() : CurrencyUtil.getDefaultTradeCurrency())));
        boolean isAddAccountScreen = paymentAccount.getAccountName() == null;
        long accountAge = !isAddAccountScreen ? this.accountAgeWitnessService.getMyAccountAge(paymentAccount.getPaymentAccountPayload()) : 0L;
        String limitationsText = paymentAccount instanceof AssetAccount ? Res.get((String)"payment.maxPeriodAndLimitCrypto", (Object[])new Object[]{PaymentMethodForm.getTimeText(hours), HavenoUtils.formatXmr((long)this.accountAgeWitnessService.getMyTradeLimit(paymentAccount, tradeCurrency.getCode(), OfferDirection.BUY, false), (boolean)true)}) : Res.get((String)"payment.maxPeriodAndLimit", (Object[])new Object[]{PaymentMethodForm.getTimeText(hours), HavenoUtils.formatXmr((long)this.accountAgeWitnessService.getMyTradeLimit(paymentAccount, tradeCurrency.getCode(), OfferDirection.BUY, false), (boolean)true), HavenoUtils.formatXmr((long)this.accountAgeWitnessService.getMyTradeLimit(paymentAccount, tradeCurrency.getCode(), OfferDirection.SELL, false), (boolean)true), DisplayUtils.formatAccountAge(accountAge)});
        return limitationsText;
    }

    protected void addLimitations(boolean isDisplayForm) {
        boolean isAddAccountScreen;
        boolean bl = isAddAccountScreen = this.paymentAccount.getAccountName() == null;
        if (isDisplayForm) {
            FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.limitations"), this.getLimitationsText());
            boolean needsSigning = PaymentMethod.hasChargebackRisk((PaymentMethod)this.paymentAccount.getPaymentMethod(), (List)this.paymentAccount.getTradeCurrencies());
            if (needsSigning) {
                AccountAgeWitness myWitness = this.accountAgeWitnessService.getMyWitness(this.paymentAccount.paymentAccountPayload);
                AccountAgeWitnessService.SignState signState = this.accountAgeWitnessService.getSignState(myWitness);
                Object accountSigningStateText = StringUtils.capitalize((String)signState.getDisplayString());
                long daysSinceSigning = TimeUnit.MILLISECONDS.toDays(this.accountAgeWitnessService.getWitnessSignAge(myWitness, new Date()));
                String timeSinceSigning = Res.get((String)"offerbook.timeSinceSigning.daysSinceSigning.long", (Object[])new Object[]{Res.get((String)"offerbook.timeSinceSigning.daysSinceSigning", (Object[])new Object[]{daysSinceSigning})});
                if (!signState.equals((Object)AccountAgeWitnessService.SignState.UNSIGNED)) {
                    accountSigningStateText = (String)accountSigningStateText + " / " + timeSinceSigning;
                }
                MaterialDesignIcon icon = GUIUtil.getIconForSignState(signState);
                InfoTextField accountSigningField = (InfoTextField)((Object)FormBuilder.addCompactTopLabelInfoTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"shared.accountSigningState"), (String)accountSigningStateText).second);
                accountSigningField.setContent(icon, (String)accountSigningStateText, "", 0.4);
            }
        } else {
            this.paymentLimitationsTextField = (TextField)FormBuilder.addTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.limitations"), (String)this.getLimitationsText()).second;
        }
        if (!(this.paymentAccount instanceof AssetAccount)) {
            if (isAddAccountScreen) {
                InputTextField inputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.salt"), 0.0);
                inputTextField.setText(Utilities.bytesAsHexString((byte[])this.paymentAccount.getPaymentAccountPayload().getSalt()));
                inputTextField.textProperty().addListener((observable, oldValue, newValue) -> {
                    if (!newValue.isEmpty()) {
                        try {
                            Utilities.decodeFromHex((String)newValue);
                            this.paymentAccount.setSaltAsHex(newValue);
                        }
                        catch (Throwable t) {
                            ((Popup)new Popup().warning(Res.get((String)"payment.error.noHexSalt"))).show();
                            inputTextField.setText(Utilities.bytesAsHexString((byte[])this.paymentAccount.getPaymentAccountPayload().getSalt()));
                            log.warn(t.toString());
                        }
                    }
                });
            } else {
                FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(this.gridPane, ++this.gridRow, Res.get((String)"payment.salt", (Object[])new Object[]{Utilities.bytesAsHexString((byte[])this.paymentAccount.getPaymentAccountPayload().getSalt())}), Utilities.bytesAsHexString((byte[])this.paymentAccount.getPaymentAccountPayload().getSalt()));
            }
        }
    }

    void applyTradeCurrency(TradeCurrency tradeCurrency, TraditionalCurrency defaultCurrency) {
        if (!defaultCurrency.equals((Object)tradeCurrency)) {
            ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"payment.foreign.currency"))).actionButtonText(Res.get((String)"shared.yes"))).onAction(() -> {
                this.paymentAccount.setSingleTradeCurrency(tradeCurrency);
                this.autoFillNameTextField();
            })).closeButtonText(Res.get((String)"payment.restore.default"))).onClose(() -> this.currencyComboBox.getSelectionModel().select((Object)defaultCurrency))).show();
        } else {
            this.paymentAccount.setSingleTradeCurrency(tradeCurrency);
            this.autoFillNameTextField();
        }
    }

    void setAccountNameWithString(String name) {
        if (this.useCustomAccountNameToggleButton != null && !this.useCustomAccountNameToggleButton.isSelected()) {
            String accountName = DisplayUtils.createAccountName(this.paymentAccount.getPaymentMethod().getId(), name);
            this.accountNameTextField.setText(accountName);
        }
    }

    void fillUpFlowPaneWithCurrencies(boolean isEditable, FlowPane flowPane, TradeCurrency e, PaymentAccount paymentAccount) {
        AutoTooltipCheckBox checkBox = new AutoTooltipCheckBox(e.getCode());
        checkBox.setMouseTransparent(!isEditable);
        checkBox.setSelected(paymentAccount.getTradeCurrencies().contains(e));
        checkBox.setMinWidth(60.0);
        checkBox.setMaxWidth(checkBox.getMinWidth());
        checkBox.setTooltip(new Tooltip(e.getName()));
        checkBox.setOnAction(arg_0 -> this.lambda$fillUpFlowPaneWithCurrencies$6((CheckBox)checkBox, paymentAccount, e, arg_0));
        flowPane.getChildren().add((Object)checkBox);
    }

    protected abstract void autoFillNameTextField();

    public abstract void addFormForAddAccount();

    public abstract void addFormForEditAccount();

    protected abstract void updateAllInputsValid();

    public void updateFromInputs() {
        this.autoFillNameTextField();
        this.updateAllInputsValid();
    }

    public boolean isAccountNameValid() {
        return this.inputValidator.validate((String)this.paymentAccount.getAccountName()).isValid;
    }

    public int getGridRow() {
        return this.gridRow;
    }

    public int getRowSpan() {
        return this.gridRow - this.gridRowFrom + 2;
    }

    public PaymentAccount getPaymentAccount() {
        return this.paymentAccount;
    }

    public BooleanProperty allInputsValidProperty() {
        return this.allInputsValid;
    }

    void removeAcceptedCountry(String countryCode) {
    }

    void addAcceptedCountry(String countryCode) {
    }

    private /* synthetic */ void lambda$fillUpFlowPaneWithCurrencies$6(CheckBox checkBox, PaymentAccount paymentAccount, TradeCurrency e, ActionEvent event) {
        if (checkBox.isSelected()) {
            paymentAccount.addCurrency(e);
        } else {
            paymentAccount.removeCurrency(e);
        }
        this.updateAllInputsValid();
    }
}

