/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import com.jfoenix.controls.JFXTextArea;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.PayByMailAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PayByMailAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;

public class PayByMailForm
extends PaymentMethodForm {
    private final PayByMailAccount payByMailAccount;
    private TextArea postalAddressTextArea;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        PayByMailAccountPayload cbm = (PayByMailAccountPayload)paymentAccountPayload;
        FormBuilder.addTopLabelTextFieldWithCopyIcon(gridPane, gridRow, 1, Res.get((String)"payment.account.owner"), cbm.getHolderName(), 50.0);
        TextArea textAddress = (TextArea)FormBuilder.addCompactTopLabelTextArea((GridPane)gridPane, (int)(++gridRow), (String)Res.get((String)"payment.postal.address"), (String)"").second;
        textAddress.setMinHeight(70.0);
        textAddress.setEditable(false);
        textAddress.setText(cbm.getPostalAddress());
        TextArea textExtraInfo = (TextArea)FormBuilder.addCompactTopLabelTextArea((GridPane)gridPane, (int)gridRow, (int)1, (String)Res.get((String)"payment.shared.extraInfo"), (String)"").second;
        textExtraInfo.setMinHeight(70.0);
        textExtraInfo.setEditable(false);
        textExtraInfo.setText(cbm.getExtraInfo());
        return gridRow;
    }

    public PayByMailForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.payByMailAccount = (PayByMailAccount)paymentAccount;
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow + 1;
        this.addTradeCurrencyComboBox();
        this.currencyComboBox.setItems(FXCollections.observableArrayList((Collection)CurrencyUtil.getAllSortedTraditionalCurrencies()));
        InputTextField contactField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.payByMail.contact"));
        contactField.setPromptText(Res.get((String)"payment.payByMail.contact.prompt"));
        contactField.setValidator(this.inputValidator);
        contactField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.payByMailAccount.setContact(newValue);
            this.updateFromInputs();
        });
        this.postalAddressTextArea = (TextArea)FormBuilder.addTopLabelTextArea((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.postal.address"), (String)"").second;
        this.postalAddressTextArea.setMinHeight(70.0);
        this.postalAddressTextArea.textProperty().addListener((ov, oldValue, newValue) -> {
            this.payByMailAccount.setPostalAddress(newValue);
            this.updateFromInputs();
        });
        TextArea extraTextArea = (TextArea)FormBuilder.addTopLabelTextArea((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.shared.optionalExtra"), (String)Res.get((String)"payment.payByMail.extraInfo.prompt")).second;
        extraTextArea.setMinHeight(70.0);
        ((JFXTextArea)extraTextArea).setLabelFloat(false);
        extraTextArea.textProperty().addListener((ov, oldValue, newValue) -> {
            this.payByMailAccount.setExtraInfo(newValue);
            this.updateFromInputs();
        });
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.payByMailAccount.getContact());
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.payByMailAccount.getPaymentMethod().getId()));
        TradeCurrency tradeCurrency = this.paymentAccount.getSingleTradeCurrency();
        String nameAndCode = tradeCurrency != null ? tradeCurrency.getNameAndCode() : "";
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.f2f.contact"), this.payByMailAccount.getContact());
        TextArea textArea = (TextArea)FormBuilder.addCompactTopLabelTextArea((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.postal.address"), (String)"").second;
        textArea.setText(this.payByMailAccount.getPostalAddress());
        textArea.setMinHeight(70.0);
        textArea.setEditable(false);
        TextArea textAreaExtra = (TextArea)FormBuilder.addCompactTopLabelTextArea((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.shared.extraInfo"), (String)"").second;
        textAreaExtra.setText(this.payByMailAccount.getExtraInfo());
        textAreaExtra.setMinHeight(70.0);
        textAreaExtra.setEditable(false);
        this.addLimitations(true);
    }

    @Override
    public void updateAllInputsValid() {
        this.allInputsValid.set(this.isAccountNameValid() && !this.payByMailAccount.getPostalAddress().isEmpty() && this.inputValidator.validate((String)this.payByMailAccount.getContact()).isValid && this.paymentAccount.getSingleTradeCurrency() != null);
    }
}

