/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.common.util.Tuple2;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.BankUtil;
import haveno.core.locale.Country;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.MoneyGramAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.MoneyGramAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.validation.EmailValidator;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoneyGramForm
extends PaymentMethodForm {
    private static final Logger log = LoggerFactory.getLogger(MoneyGramForm.class);
    private final MoneyGramAccountPayload moneyGramAccountPayload;
    private InputTextField stateInputTextField;
    private final EmailValidator emailValidator;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        MoneyGramAccountPayload payload = (MoneyGramAccountPayload)paymentAccountPayload;
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, Res.get((String)"payment.account.fullName"), payload.getHolderName());
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, gridRow, 1, Res.get((String)"payment.email"), payload.getEmail());
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, Res.get((String)"payment.bank.country"), CountryUtil.getNameAndCode((String)((MoneyGramAccountPayload)paymentAccountPayload).getCountryCode()));
        if (BankUtil.isStateRequired((String)payload.getCountryCode())) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, gridRow, 1, Res.get((String)"payment.account.state"), payload.getState());
        }
        return gridRow;
    }

    public MoneyGramForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.moneyGramAccountPayload = (MoneyGramAccountPayload)paymentAccount.paymentAccountPayload;
        this.emailValidator = new EmailValidator();
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        Country country = this.getMoneyGramPaymentAccount().getCountry();
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.paymentAccount.getPaymentMethod().getId()));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.country"), country != null ? country.name : "");
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.fullName"), this.moneyGramAccountPayload.getHolderName());
        if (BankUtil.isStateRequired((String)this.moneyGramAccountPayload.getCountryCode())) {
            ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.account.state"), (String)this.moneyGramAccountPayload.getState()).second).setMouseTransparent(false);
        }
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.email"), this.moneyGramAccountPayload.getEmail());
        this.addLimitations(true);
        this.addCurrenciesGrid(false);
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow + 1;
        this.gridRow = GUIUtil.addRegionCountry(this.gridPane, this.gridRow, this::onCountrySelected);
        InputTextField holderNameInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.fullName"));
        holderNameInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.moneyGramAccountPayload.setHolderName(newValue);
            this.updateFromInputs();
        });
        holderNameInputTextField.setValidator(this.inputValidator);
        this.stateInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.state"));
        this.stateInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.moneyGramAccountPayload.setState(newValue);
            this.updateFromInputs();
        });
        this.applyIsStateRequired();
        InputTextField emailInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.email"));
        emailInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.moneyGramAccountPayload.setEmail(newValue);
            this.updateFromInputs();
        });
        emailInputTextField.setValidator((InputValidator)this.emailValidator);
        this.addCurrenciesGrid(true);
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        this.updateFromInputs();
    }

    private void onCountrySelected(Country country) {
        if (country != null) {
            this.getMoneyGramPaymentAccount().setCountry(country);
            this.updateFromInputs();
            this.applyIsStateRequired();
            this.stateInputTextField.setText("");
        }
    }

    private void addCurrenciesGrid(boolean isEditable) {
        Tuple2<Label, FlowPane> labelFlowPaneTuple2 = FormBuilder.addTopLabelFlowPane(this.gridPane, ++this.gridRow, Res.get((String)"payment.supportedCurrencies"), 69.0, 69.0);
        FlowPane flowPane = (FlowPane)labelFlowPaneTuple2.second;
        if (isEditable) {
            flowPane.setId("flow-pane-checkboxes-bg");
        } else {
            flowPane.setId("flow-pane-checkboxes-non-editable-bg");
        }
        this.paymentAccount.getSupportedCurrencies().forEach(e -> this.fillUpFlowPaneWithCurrencies(isEditable, flowPane, (TradeCurrency)e, this.paymentAccount));
    }

    private void applyIsStateRequired() {
        boolean stateRequired = BankUtil.isStateRequired((String)this.moneyGramAccountPayload.getCountryCode());
        this.stateInputTextField.setManaged(stateRequired);
        this.stateInputTextField.setVisible(stateRequired);
    }

    private MoneyGramAccount getMoneyGramPaymentAccount() {
        return (MoneyGramAccount)this.paymentAccount;
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.moneyGramAccountPayload.getHolderName() == null ? "" : this.moneyGramAccountPayload.getHolderName());
    }

    @Override
    public void updateAllInputsValid() {
        boolean result = this.isAccountNameValid() && this.getMoneyGramPaymentAccount().getCountry() != null && this.inputValidator.validate((String)this.moneyGramAccountPayload.getHolderName()).isValid && this.emailValidator.validate((String)this.moneyGramAccountPayload.getEmail()).isValid && this.paymentAccount.getTradeCurrencies().size() > 0;
        this.allInputsValid.set(result);
    }
}

