/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.common.util.Tuple2;
import haveno.common.util.Tuple3;
import haveno.common.util.Tuple4;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.JapanBankAccount;
import haveno.core.payment.JapanBankData;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.JapanBankAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.validation.JapanBankAccountNameValidator;
import haveno.core.payment.validation.JapanBankAccountNumberValidator;
import haveno.core.payment.validation.JapanBankBranchCodeValidator;
import haveno.core.payment.validation.JapanBankBranchNameValidator;
import haveno.core.payment.validation.LengthValidator;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.core.util.validation.RegexValidator;
import haveno.desktop.components.AutocompleteComboBox;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.util.StringConverter;
import org.apache.commons.lang3.StringUtils;

public class JapanBankTransferForm
extends PaymentMethodForm {
    private final JapanBankAccount japanBankAccount;
    protected ComboBox<String> bankComboBox;
    private final JapanBankBranchNameValidator japanBankBranchNameValidator;
    private final JapanBankBranchCodeValidator japanBankBranchCodeValidator;
    private final JapanBankAccountNameValidator japanBankAccountNameValidator;
    private final JapanBankAccountNumberValidator japanBankAccountNumberValidator;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        JapanBankAccountPayload japanBankAccount = (JapanBankAccountPayload)paymentAccountPayload;
        String bankText = japanBankAccount.getBankCode() + " " + japanBankAccount.getBankName();
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, Res.get((String)"payment.japan.bank"), bankText);
        String branchText = japanBankAccount.getBankBranchCode() + " " + japanBankAccount.getBankBranchName();
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, gridRow, 1, Res.get((String)"payment.japan.branch"), branchText);
        String accountText = japanBankAccount.getBankAccountType() + " " + japanBankAccount.getBankAccountNumber();
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, Res.get((String)"payment.japan.account"), accountText);
        String accountNameText = japanBankAccount.getBankAccountName();
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, gridRow, 1, Res.get((String)"payment.japan.recipient"), accountNameText);
        return gridRow;
    }

    public JapanBankTransferForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.japanBankAccount = (JapanBankAccount)paymentAccount;
        this.japanBankBranchCodeValidator = new JapanBankBranchCodeValidator();
        this.japanBankAccountNumberValidator = new JapanBankAccountNumberValidator();
        LengthValidator lengthValidator = new LengthValidator();
        RegexValidator regexValidator = new RegexValidator();
        this.japanBankBranchNameValidator = new JapanBankBranchNameValidator(lengthValidator, regexValidator);
        this.japanBankAccountNameValidator = new JapanBankAccountNameValidator(lengthValidator, regexValidator);
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.japanBankAccount.getPaymentMethod().getId()));
        this.addBankDisplay();
        this.addBankBranchDisplay();
        this.addBankAccountDisplay();
        this.addBankAccountTypeDisplay();
        this.addLimitations(true);
    }

    private void addBankDisplay() {
        String bankText = this.japanBankAccount.getBankCode() + " " + this.japanBankAccount.getBankName();
        TextField bankTextField = (TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)JapanBankData.getString((String)"bank"), (String)bankText).second;
        bankTextField.setEditable(false);
    }

    private void addBankBranchDisplay() {
        String branchText = this.japanBankAccount.getBankBranchCode() + " " + this.japanBankAccount.getBankBranchName();
        TextField branchTextField = (TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)JapanBankData.getString((String)"branch"), (String)branchText).second;
        branchTextField.setEditable(false);
    }

    private void addBankAccountDisplay() {
        String accountText = this.japanBankAccount.getBankAccountNumber() + " " + this.japanBankAccount.getBankAccountName();
        TextField accountTextField = (TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)JapanBankData.getString((String)"account"), (String)accountText).second;
        accountTextField.setEditable(false);
    }

    private void addBankAccountTypeDisplay() {
        TradeCurrency singleTradeCurrency = this.japanBankAccount.getSingleTradeCurrency();
        String currency = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "null";
        String accountTypeText = currency + " " + this.japanBankAccount.getBankAccountType();
        TextField accountTypeTextField = (TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)JapanBankData.getString((String)"account.type"), (String)accountTypeText).second;
        accountTypeTextField.setEditable(false);
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow;
        this.addBankInput();
        this.addBankBranchInput();
        this.addBankAccountInput();
        this.addBankAccountTypeInput();
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    private void addBankInput() {
        ++this.gridRow;
        Tuple4 tuple4 = FormBuilder.addTopLabelTextFieldAutocompleteComboBox(this.gridPane, this.gridRow, JapanBankData.getString((String)"bank.code"), JapanBankData.getString((String)"bank.name"), 10.0);
        TextField bankCodeField = (TextField)tuple4.second;
        bankCodeField.setPrefWidth(200.0);
        bankCodeField.setMaxWidth(200.0);
        bankCodeField.setEditable(false);
        this.bankComboBox = (ComboBox)tuple4.fourth;
        this.bankComboBox.setPromptText(JapanBankData.getString((String)"bank.select"));
        this.bankComboBox.setButtonCell(GUIUtil.getComboBoxButtonCell(JapanBankData.getString((String)"bank.name"), this.bankComboBox));
        this.bankComboBox.getEditor().focusedProperty().addListener(observable -> this.bankComboBox.setPromptText(""));
        this.bankComboBox.setConverter((StringConverter)new StringConverter<String>(this){

            public String toString(String bank) {
                return bank != null ? bank : "";
            }

            public String fromString(String s) {
                return s != null ? s : "";
            }
        });
        ((AutocompleteComboBox)this.bankComboBox).setAutocompleteItems(JapanBankData.prettyPrintBankList());
        this.bankComboBox.setPrefWidth(430.0);
        this.bankComboBox.setVisibleRowCount(430);
        ((AutocompleteComboBox)this.bankComboBox).setOnChangeConfirmed((EventHandler<Event>)((EventHandler)e -> {
            String bank = (String)this.bankComboBox.getSelectionModel().getSelectedItem();
            String bankCode = StringUtils.substring((String)bank, (int)0, (int)4);
            if (bankCode != null) {
                bankCodeField.setText(bankCode);
                this.japanBankAccount.setBankCode(bankCode);
                String bankNameFull = StringUtils.substringAfter((String)bank, (String)" ");
                String bankNameJa = StringUtils.substringBefore((String)bankNameFull, (String)" ");
                this.bankComboBox.getEditor().setText(bankNameJa);
                this.japanBankAccount.setBankName(bankNameJa);
            }
            this.updateFromInputs();
        }));
    }

    private void addBankBranchInput() {
        ++this.gridRow;
        Tuple2<InputTextField, InputTextField> tuple2 = FormBuilder.addInputTextFieldInputTextField(this.gridPane, this.gridRow, JapanBankData.getString((String)"branch.code"), JapanBankData.getString((String)"branch.name"));
        InputTextField bankBranchCodeInputTextField = (InputTextField)((Object)tuple2.first);
        bankBranchCodeInputTextField.setValidator((InputValidator)this.japanBankBranchCodeValidator);
        bankBranchCodeInputTextField.setPrefWidth(200.0);
        bankBranchCodeInputTextField.setMaxWidth(200.0);
        bankBranchCodeInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.japanBankAccount.setBankBranchCode(newValue);
            this.updateFromInputs();
        });
        InputTextField bankBranchNameInputTextField = (InputTextField)((Object)tuple2.second);
        bankBranchNameInputTextField.setValidator((InputValidator)this.japanBankBranchNameValidator);
        bankBranchNameInputTextField.setPrefWidth(430.0);
        bankBranchNameInputTextField.setMaxWidth(430.0);
        bankBranchNameInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.japanBankAccount.setBankBranchName(newValue);
            this.updateFromInputs();
        });
    }

    private void addBankAccountInput() {
        ++this.gridRow;
        Tuple2<InputTextField, InputTextField> tuple2 = FormBuilder.addInputTextFieldInputTextField(this.gridPane, this.gridRow, JapanBankData.getString((String)"account.number"), JapanBankData.getString((String)"account.name"));
        InputTextField bankAccountNumberInputTextField = (InputTextField)((Object)tuple2.first);
        bankAccountNumberInputTextField.setValidator((InputValidator)this.japanBankAccountNumberValidator);
        bankAccountNumberInputTextField.setPrefWidth(200.0);
        bankAccountNumberInputTextField.setMaxWidth(200.0);
        bankAccountNumberInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.japanBankAccount.setBankAccountNumber(newValue);
            this.updateFromInputs();
        });
        InputTextField bankAccountNameInputTextField = (InputTextField)((Object)tuple2.second);
        bankAccountNameInputTextField.setValidator((InputValidator)this.japanBankAccountNameValidator);
        bankAccountNameInputTextField.setPrefWidth(430.0);
        bankAccountNameInputTextField.setMaxWidth(430.0);
        bankAccountNameInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.japanBankAccount.setBankAccountName(newValue);
            this.updateFromInputs();
        });
    }

    private void addBankAccountTypeInput() {
        ++this.gridRow;
        TradeCurrency singleTradeCurrency = this.japanBankAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "null";
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.currency"), nameAndCode, 20.0);
        ++this.gridRow;
        ToggleGroup toggleGroup = new ToggleGroup();
        Tuple3<Label, RadioButton, RadioButton> tuple3 = FormBuilder.addTopLabelRadioButtonRadioButton(this.gridPane, this.gridRow, toggleGroup, JapanBankData.getString((String)"account.type.select"), JapanBankData.getString((String)"account.type.futsu"), JapanBankData.getString((String)"account.type.touza"), 0.0);
        ((Toggle)toggleGroup.getToggles().get(0)).setSelected(true);
        this.japanBankAccount.setBankAccountType(JapanBankData.getString((String)"account.type.futsu.ja"));
        RadioButton futsu = (RadioButton)tuple3.second;
        RadioButton touza = (RadioButton)tuple3.third;
        toggleGroup.selectedToggleProperty().addListener((ov, oldValue, newValue) -> {
            if (futsu.isSelected()) {
                this.japanBankAccount.setBankAccountType(JapanBankData.getString((String)"account.type.futsu.ja"));
            }
            if (touza.isSelected()) {
                this.japanBankAccount.setBankAccountType(JapanBankData.getString((String)"account.type.touza.ja"));
            }
        });
    }

    @Override
    public void updateFromInputs() {
        System.out.println("JapanBankTransferForm: updateFromInputs()");
        System.out.println("bankName: " + this.japanBankAccount.getBankName());
        System.out.println("bankCode: " + this.japanBankAccount.getBankCode());
        System.out.println("bankBranchName: " + this.japanBankAccount.getBankBranchName());
        System.out.println("bankBranchCode: " + this.japanBankAccount.getBankBranchCode());
        System.out.println("bankAccountType: " + this.japanBankAccount.getBankAccountType());
        System.out.println("bankAccountName: " + this.japanBankAccount.getBankAccountName());
        System.out.println("bankAccountNumber: " + this.japanBankAccount.getBankAccountNumber());
        super.updateFromInputs();
    }

    @Override
    protected void autoFillNameTextField() {
        if (this.useCustomAccountNameToggleButton != null && !this.useCustomAccountNameToggleButton.isSelected()) {
            this.accountNameTextField.setText(Res.get((String)this.paymentAccount.getPaymentMethod().getId()).concat(": ").concat(this.japanBankAccount.getBankName()).concat(" ").concat(this.japanBankAccount.getBankBranchName()).concat(" ").concat(this.japanBankAccount.getBankAccountNumber()).concat(" ").concat(this.japanBankAccount.getBankAccountName()));
        }
    }

    @Override
    public void updateAllInputsValid() {
        boolean result = this.isAccountNameValid() && this.inputValidator.validate((String)this.japanBankAccount.getBankCode()).isValid && this.inputValidator.validate((String)this.japanBankAccount.getBankName()).isValid && this.japanBankBranchCodeValidator.validate((String)this.japanBankAccount.getBankBranchCode()).isValid && this.japanBankBranchNameValidator.validate((String)this.japanBankAccount.getBankBranchName()).isValid && this.japanBankAccountNumberValidator.validate((String)this.japanBankAccount.getBankAccountNumber()).isValid && this.japanBankAccountNameValidator.validate((String)this.japanBankAccount.getBankAccountName()).isValid && this.inputValidator.validate((String)this.japanBankAccount.getBankAccountType()).isValid;
        this.allInputsValid.set(result);
    }
}

