/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.InteracETransferAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.InteracETransferAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.validation.InteracETransferValidator;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public class InteracETransferForm
extends PaymentMethodForm {
    private final InteracETransferAccount interacETransferAccount;
    private final InteracETransferValidator interacETransferValidator;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        FormBuilder.addCompactTopLabelTextField(gridPane, ++gridRow, Res.get((String)"payment.account.owner"), ((InteracETransferAccountPayload)paymentAccountPayload).getHolderName());
        FormBuilder.addCompactTopLabelTextField(gridPane, gridRow, 1, Res.get((String)"payment.emailOrMobile"), ((InteracETransferAccountPayload)paymentAccountPayload).getEmailOrMobileNr());
        FormBuilder.addCompactTopLabelTextField(gridPane, ++gridRow, Res.get((String)"payment.secret"), ((InteracETransferAccountPayload)paymentAccountPayload).getQuestion());
        FormBuilder.addCompactTopLabelTextField(gridPane, gridRow, 1, Res.get((String)"payment.answer"), ((InteracETransferAccountPayload)paymentAccountPayload).getAnswer());
        return gridRow;
    }

    public InteracETransferForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InteracETransferValidator interacETransferValidator, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.interacETransferAccount = (InteracETransferAccount)paymentAccount;
        this.interacETransferValidator = interacETransferValidator;
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow + 1;
        InputTextField holderNameInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"));
        holderNameInputTextField.setValidator(this.inputValidator);
        holderNameInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.interacETransferAccount.setHolderName(newValue);
            this.updateFromInputs();
        });
        InputTextField mobileNrInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.emailOrMobile"));
        mobileNrInputTextField.setValidator((InputValidator)this.interacETransferValidator);
        mobileNrInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.interacETransferAccount.setEmail(newValue);
            this.updateFromInputs();
        });
        InputTextField questionInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.secret"));
        questionInputTextField.setValidator(this.interacETransferValidator.questionValidator);
        questionInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.interacETransferAccount.setQuestion(newValue);
            this.updateFromInputs();
        });
        InputTextField answerInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.answer"));
        answerInputTextField.setValidator(this.interacETransferValidator.answerValidator);
        answerInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.interacETransferAccount.setAnswer(newValue);
            this.updateFromInputs();
        });
        TradeCurrency singleTradeCurrency = this.interacETransferAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "null";
        FormBuilder.addTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.interacETransferAccount.getEmail());
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.interacETransferAccount.getPaymentMethod().getId()));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"), this.interacETransferAccount.getHolderName());
        ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.email"), (String)this.interacETransferAccount.getEmail()).second).setMouseTransparent(false);
        ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.secret"), (String)this.interacETransferAccount.getQuestion()).second).setMouseTransparent(false);
        ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.answer"), (String)this.interacETransferAccount.getAnswer()).second).setMouseTransparent(false);
        TradeCurrency singleTradeCurrency = this.interacETransferAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "null";
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        this.addLimitations(true);
    }

    @Override
    public void updateAllInputsValid() {
        this.allInputsValid.set(this.isAccountNameValid() && this.interacETransferValidator.validate((String)this.interacETransferAccount.getEmail()).isValid && this.inputValidator.validate((String)this.interacETransferAccount.getHolderName()).isValid && this.interacETransferValidator.questionValidator.validate((String)this.interacETransferAccount.getQuestion()).isValid && this.interacETransferValidator.answerValidator.validate((String)this.interacETransferAccount.getAnswer()).isValid && this.interacETransferAccount.getTradeCurrencies().size() > 0);
    }
}

