/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.IfscBasedAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.core.util.validation.RegexValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public class IfscBankForm
extends PaymentMethodForm {
    private final IfscBasedAccountPayload ifscBasedAccountPayload;
    private final RegexValidator ifscValidator;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        IfscBasedAccountPayload ifscAccountPayload = (IfscBasedAccountPayload)paymentAccountPayload;
        FormBuilder.addTopLabelTextFieldWithCopyIcon(gridPane, gridRow, 1, Res.get((String)"payment.account.owner"), ifscAccountPayload.getHolderName(), 50.0);
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, Res.get((String)"payment.accountNr"), ifscAccountPayload.getAccountNr());
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, gridRow, 1, Res.get((String)"payment.ifsc"), ifscAccountPayload.getIfsc());
        return gridRow;
    }

    public IfscBankForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.ifscBasedAccountPayload = (IfscBasedAccountPayload)paymentAccount.paymentAccountPayload;
        this.ifscValidator = new RegexValidator();
        this.ifscValidator.setPattern("[A-Z]{4}0[0-9]{6}");
        this.ifscValidator.setErrorMessage(Res.get((String)"payment.ifsc.validation"));
    }

    @Override
    public void addFormForAddAccount() {
        this.paymentAccount.setSingleTradeCurrency((TradeCurrency)this.paymentAccount.getSupportedCurrencies().get(0));
        CountryUtil.findCountryByCode((String)"IN").ifPresent(c -> this.ifscBasedAccountPayload.setCountryCode(c.code));
        this.gridRowFrom = this.gridRow + 1;
        InputTextField holderNameInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"));
        holderNameInputTextField.setValidator(this.inputValidator);
        holderNameInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.ifscBasedAccountPayload.setHolderName(newValue.trim());
            this.updateFromInputs();
        });
        InputTextField accountNrInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.accountNr"));
        accountNrInputTextField.setValidator(this.inputValidator);
        accountNrInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.ifscBasedAccountPayload.setAccountNr(newValue.trim());
            this.updateFromInputs();
        });
        InputTextField ifscInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.ifsc"));
        ifscInputTextField.setText("XXXX0999999");
        ifscInputTextField.setValidator((InputValidator)this.ifscValidator);
        ifscInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.ifscBasedAccountPayload.setIfsc(newValue.trim());
            this.updateFromInputs();
        });
        FormBuilder.addTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), this.paymentAccount.getSingleTradeCurrency().getNameAndCode());
        FormBuilder.addTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.country"), CountryUtil.getNameByCode((String)this.ifscBasedAccountPayload.getCountryCode()));
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.ifscBasedAccountPayload.getHolderName());
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.paymentAccount.getPaymentMethod().getId()));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"), this.ifscBasedAccountPayload.getHolderName());
        TextField field = (TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.accountNr"), (String)this.ifscBasedAccountPayload.getAccountNr()).second;
        field.setMouseTransparent(false);
        TextField fieldIfsc = (TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.ifsc"), (String)this.ifscBasedAccountPayload.getIfsc()).second;
        fieldIfsc.setMouseTransparent(false);
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), this.paymentAccount.getSingleTradeCurrency().getNameAndCode());
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.country"), CountryUtil.getNameByCode((String)this.ifscBasedAccountPayload.getCountryCode()));
        this.addLimitations(true);
    }

    @Override
    public void updateAllInputsValid() {
        this.allInputsValid.set(this.isAccountNameValid() && this.inputValidator.validate((String)this.ifscBasedAccountPayload.getHolderName()).isValid && this.inputValidator.validate((String)this.ifscBasedAccountPayload.getAccountNr()).isValid && this.ifscValidator.validate((String)this.ifscBasedAccountPayload.getIfsc()).isValid);
    }
}

