/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.common.util.Utilities;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.BankUtil;
import haveno.core.locale.Country;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.BankAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.GeneralBankForm;
import haveno.desktop.util.FormBuilder;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javax.annotation.Nullable;

public abstract class GeneralUsBankForm
extends GeneralBankForm {
    protected static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload, @Nullable String accountType, String holderAddress) {
        BankAccountPayload bankAccountPayload = (BankAccountPayload)paymentAccountPayload;
        String countryCode = bankAccountPayload.getCountryCode();
        int colIndex = 1;
        FormBuilder.addTopLabelTextFieldWithCopyIcon(gridPane, GeneralUsBankForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, GeneralUsBankForm.getIndexOfColumn(colIndex++), Res.get((String)"payment.account.owner"), bankAccountPayload.getHolderName(), 50.0);
        String branchIdLabel = BankUtil.getBranchIdLabel((String)countryCode);
        String accountNrLabel = BankUtil.getAccountNrLabel((String)countryCode);
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, GeneralUsBankForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, GeneralUsBankForm.getIndexOfColumn(colIndex++), branchIdLabel + " / " + accountNrLabel, bankAccountPayload.getBranchId() + " / " + bankAccountPayload.getAccountNr());
        String bankNameLabel = BankUtil.getBankNameLabel((String)countryCode);
        String accountTypeLabel = accountType == null ? "" : " / " + BankUtil.getAccountTypeLabel((String)countryCode);
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, GeneralUsBankForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, GeneralUsBankForm.getIndexOfColumn(colIndex++), bankNameLabel + accountTypeLabel, (String)(accountType == null ? bankAccountPayload.getBankName() : bankAccountPayload.getBankName() + " / " + accountType));
        if (holderAddress.length() > 0) {
            TextArea textAddress = (TextArea)FormBuilder.addCompactTopLabelTextArea((GridPane)gridPane, (int)(GeneralUsBankForm.getIndexOfColumn((int)colIndex) == 0 ? ++gridRow : gridRow), (int)GeneralUsBankForm.getIndexOfColumn((int)colIndex++), (String)Res.get((String)"payment.account.address"), (String)"").second;
            textAddress.setMinHeight(70.0);
            textAddress.setEditable(false);
            textAddress.setText(holderAddress);
        }
        return gridRow;
    }

    public GeneralUsBankForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
    }

    protected void addFormForEditAccount(BankAccountPayload bankAccountPayload, String holderAddress) {
        Country country = ((CountryBasedPaymentAccount)this.paymentAccount).getCountry();
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.paymentAccount.getPaymentMethod().getId()));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"), bankAccountPayload.getHolderName());
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner.address"), Utilities.cleanString((String)holderAddress));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.bank.name"), bankAccountPayload.getBankName());
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, BankUtil.getBranchIdLabel((String)country.code), bankAccountPayload.getBranchId());
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, BankUtil.getAccountNrLabel((String)country.code), bankAccountPayload.getAccountNr());
        if (bankAccountPayload.getAccountType() != null) {
            FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, BankUtil.getAccountTypeLabel((String)country.code), bankAccountPayload.getAccountType());
        }
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), this.paymentAccount.getSingleTradeCurrency().getNameAndCode());
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.country"), country.name);
        this.addLimitations(true);
    }

    protected void addFormForAddAccountInternal(BankAccountPayload bankAccountPayload, String holderAddress) {
        CountryUtil.findCountryByCode((String)"US").ifPresent(c -> this.onCountrySelected((Country)c));
        Country country = ((CountryBasedPaymentAccount)this.paymentAccount).getCountry();
        InputTextField holderNameInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"));
        holderNameInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            bankAccountPayload.setHolderName(newValue);
            this.updateFromInputs();
        });
        holderNameInputTextField.setValidator(this.inputValidator);
        TextArea addressTextArea = (TextArea)FormBuilder.addTopLabelTextArea((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.account.owner.address"), (String)Res.get((String)"payment.account.owner.address")).second;
        addressTextArea.setMinHeight(70.0);
        addressTextArea.textProperty().addListener((ov, oldValue, newValue) -> {
            this.setHolderAddress(newValue.trim());
            this.updateFromInputs();
        });
        this.bankNameInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.bank.name"));
        this.bankNameInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            bankAccountPayload.setBankName(newValue);
            this.updateFromInputs();
        });
        this.bankNameInputTextField.setValidator(this.inputValidator);
        this.branchIdInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, BankUtil.getBranchIdLabel((String)country.code));
        this.branchIdInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            bankAccountPayload.setBranchId(newValue);
            this.updateFromInputs();
        });
        this.branchIdInputTextField.setValidator(this.inputValidator);
        this.accountNrInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, BankUtil.getAccountNrLabel((String)country.code));
        this.accountNrInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            bankAccountPayload.setAccountNr(newValue);
            this.updateFromInputs();
        });
        this.accountNrInputTextField.setValidator(this.inputValidator);
        this.maybeAddAccountTypeCombo(bankAccountPayload, country);
        FormBuilder.addTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), this.paymentAccount.getSingleTradeCurrency().getNameAndCode());
        FormBuilder.addTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.country"), country.name);
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        this.validatorsApplied = true;
    }

    protected abstract void setHolderAddress(String var1);

    protected abstract void maybeAddAccountTypeCombo(BankAccountPayload var1, Country var2);

    protected void onCountrySelected(Country country) {
        if (country != null) {
            ((CountryBasedPaymentAccount)this.paymentAccount).setCountry(country);
            String countryCode = country.code;
            TraditionalCurrency currency = CurrencyUtil.getCurrencyByCountryCode((String)countryCode);
            this.paymentAccount.setSingleTradeCurrency((TradeCurrency)currency);
        }
    }
}

