/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXTextField;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Country;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.AutoTooltipCheckBox;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import java.util.List;
import java.util.Objects;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.util.StringConverter;
import org.apache.commons.lang3.StringUtils;

public abstract class GeneralSepaForm
extends PaymentMethodForm {
    static final String BIC = "BIC";
    static final String IBAN = "IBAN";

    GeneralSepaForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
    }

    @Override
    protected void autoFillNameTextField() {
        if (this.useCustomAccountNameToggleButton != null && !this.useCustomAccountNameToggleButton.isSelected()) {
            String currency;
            TradeCurrency singleTradeCurrency = this.paymentAccount.getSingleTradeCurrency();
            String string = currency = singleTradeCurrency != null ? singleTradeCurrency.getCode() : null;
            if (currency != null) {
                String country;
                String iban = this.getIban();
                if (iban.length() > 9) {
                    iban = StringUtils.abbreviate((String)iban, (int)9);
                }
                String method = Res.get((String)this.paymentAccount.getPaymentMethod().getId());
                CountryBasedPaymentAccount countryBasedPaymentAccount = (CountryBasedPaymentAccount)this.paymentAccount;
                String string2 = country = countryBasedPaymentAccount.getCountry() != null ? countryBasedPaymentAccount.getCountry().code : null;
                if (country != null) {
                    this.accountNameTextField.setText(method.concat(" (").concat(currency).concat("/").concat(country).concat("): ").concat(iban));
                }
            }
        }
    }

    void setCountryComboBoxAction(ComboBox<Country> countryComboBox, CountryBasedPaymentAccount paymentAccount) {
        countryComboBox.setOnAction(e -> {
            Country selectedItem = (Country)countryComboBox.getSelectionModel().getSelectedItem();
            paymentAccount.setCountry(selectedItem);
            this.updateFromInputs();
        });
    }

    void addCountriesGrid(String title, List<Country> countries) {
        FlowPane flowPane = (FlowPane)FormBuilder.addTopLabelFlowPane((GridPane)this.gridPane, (int)(++this.gridRow), (String)title, (double)0.0).second;
        flowPane.setId("flow-pane-checkboxes-bg");
        countries.forEach(country -> {
            AutoTooltipCheckBox checkBox = new AutoTooltipCheckBox(country.code);
            checkBox.setUserData(country.code);
            checkBox.setSelected(this.isCountryAccepted(country.code));
            checkBox.setMouseTransparent(false);
            checkBox.setMinWidth(45.0);
            checkBox.setMaxWidth(45.0);
            checkBox.setTooltip(new Tooltip(country.name));
            checkBox.setOnAction(arg_0 -> this.lambda$addCountriesGrid$1((CheckBox)checkBox, country, arg_0));
            flowPane.getChildren().add((Object)checkBox);
        });
    }

    ComboBox<Country> addCountrySelection() {
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        JFXComboBox countryComboBox = new JFXComboBox();
        JFXTextField currencyTextField = new JFXTextField("");
        currencyTextField.setEditable(false);
        currencyTextField.setMouseTransparent(true);
        currencyTextField.setFocusTraversable(false);
        currencyTextField.setMinWidth(300.0);
        currencyTextField.setVisible(true);
        currencyTextField.setManaged(true);
        currencyTextField.setText(Res.get((String)"payment.currencyWithSymbol", (Object[])new Object[]{Objects.requireNonNull(this.paymentAccount.getSingleTradeCurrency()).getNameAndCode()}));
        hBox.getChildren().addAll((Object[])new Node[]{countryComboBox, currencyTextField});
        FormBuilder.addTopLabelWithVBox(this.gridPane, ++this.gridRow, Res.get((String)"payment.bank.country"), (Node)hBox, 0.0);
        countryComboBox.setPromptText(Res.get((String)"payment.select.bank.country"));
        countryComboBox.setConverter((StringConverter)new StringConverter<Country>(this){

            public String toString(Country country) {
                return country.name + " (" + country.code + ")";
            }

            public Country fromString(String s) {
                return null;
            }
        });
        return countryComboBox;
    }

    abstract boolean isCountryAccepted(String var1);

    protected abstract String getIban();

    private /* synthetic */ void lambda$addCountriesGrid$1(CheckBox checkBox, Country country, ActionEvent event) {
        if (checkBox.isSelected()) {
            this.addAcceptedCountry(country.code);
        } else {
            this.removeAcceptedCountry(country.code);
        }
        this.updateAllInputsValid();
    }
}

