/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.BankUtil;
import haveno.core.locale.Res;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.BankAccountPayload;
import haveno.core.payment.validation.AccountNrValidator;
import haveno.core.payment.validation.BankIdValidator;
import haveno.core.payment.validation.BranchIdValidator;
import haveno.core.payment.validation.NationalAccountIdValidator;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import javafx.scene.layout.GridPane;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeneralBankForm
extends PaymentMethodForm {
    private static final Logger log = LoggerFactory.getLogger(GeneralBankForm.class);
    static boolean accountNrAccountTypeCombined = false;
    static boolean nationalAccountIdAccountNrCombined = false;
    static boolean bankNameBankIdCombined = false;
    static boolean bankIdBranchIdCombined = false;
    static boolean bankNameBranchIdCombined = false;
    static boolean branchIdAccountNrCombined = false;
    boolean validatorsApplied;
    boolean useHolderID;
    InputTextField bankNameInputTextField;
    InputTextField bankIdInputTextField;
    InputTextField branchIdInputTextField;
    InputTextField accountNrInputTextField;
    InputTextField holderIdInputTextField;
    InputTextField nationalAccountIdInputTextField;
    boolean accountNrInputTextFieldEdited;

    public GeneralBankForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
    }

    static int getIndexOfColumn(int colIndex) {
        return colIndex % 2;
    }

    static void prepareFormLayoutFlags(String countryCode, int currentNumberOfRows) {
        int nrRows = currentNumberOfRows;
        if (nrRows > 2) {
            boolean bl = accountNrAccountTypeCombined = BankUtil.isAccountNrRequired((String)countryCode) && BankUtil.isAccountTypeRequired((String)countryCode);
            if (accountNrAccountTypeCombined) {
                --nrRows;
            }
            if (nrRows > 2) {
                boolean bl2 = nationalAccountIdAccountNrCombined = BankUtil.isAccountNrRequired((String)countryCode) && BankUtil.isNationalAccountIdRequired((String)countryCode);
                if (nationalAccountIdAccountNrCombined) {
                    --nrRows;
                }
                if (nrRows > 2) {
                    boolean bl3 = bankNameBankIdCombined = BankUtil.isBankNameRequired((String)countryCode) && BankUtil.isBankIdRequired((String)countryCode);
                    if (bankNameBankIdCombined) {
                        --nrRows;
                    }
                    if (nrRows > 2) {
                        boolean bl4 = bankIdBranchIdCombined = !bankNameBankIdCombined && BankUtil.isBankIdRequired((String)countryCode) && BankUtil.isBranchIdRequired((String)countryCode);
                        if (bankIdBranchIdCombined) {
                            --nrRows;
                        }
                        if (nrRows > 2) {
                            boolean bl5 = bankNameBranchIdCombined = !bankNameBankIdCombined && !bankIdBranchIdCombined && BankUtil.isBankNameRequired((String)countryCode) && BankUtil.isBranchIdRequired((String)countryCode);
                            if (bankNameBranchIdCombined) {
                                --nrRows;
                            }
                            if (nrRows > 2) {
                                boolean bl6 = branchIdAccountNrCombined = !bankNameBranchIdCombined && !bankIdBranchIdCombined && !accountNrAccountTypeCombined && BankUtil.isBranchIdRequired((String)countryCode) && BankUtil.isAccountNrRequired((String)countryCode);
                                if (branchIdAccountNrCombined) {
                                    --nrRows;
                                }
                                if (nrRows > 2) {
                                    log.warn("We still have too many rows....");
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    void validateInput(String countryCode) {
        if (BankUtil.useValidation((String)countryCode)) {
            this.validatorsApplied = true;
            if (this.useHolderID) {
                this.holderIdInputTextField.setValidator(this.inputValidator);
            }
            this.bankNameInputTextField.setValidator(this.inputValidator);
            this.bankIdInputTextField.setValidator((InputValidator)new BankIdValidator(countryCode));
            this.branchIdInputTextField.setValidator((InputValidator)new BranchIdValidator(countryCode));
            this.accountNrInputTextField.setValidator((InputValidator)new AccountNrValidator(countryCode));
            this.nationalAccountIdInputTextField.setValidator((InputValidator)new NationalAccountIdValidator(countryCode));
        } else {
            this.validatorsApplied = false;
            if (this.useHolderID) {
                this.holderIdInputTextField.setValidator(null);
            }
            this.bankNameInputTextField.setValidator(null);
            this.bankIdInputTextField.setValidator(null);
            this.branchIdInputTextField.setValidator(null);
            this.accountNrInputTextField.setValidator(this.inputValidator);
            this.nationalAccountIdInputTextField.setValidator(null);
        }
    }

    void updateHolderIDInput(String countryCode, boolean requiresHolderId) {
        if (this.useHolderID) {
            if (!requiresHolderId) {
                this.holderIdInputTextField.setText("");
            }
            this.holderIdInputTextField.resetValidation();
            this.holderIdInputTextField.setVisible(requiresHolderId);
            this.holderIdInputTextField.setManaged(requiresHolderId);
            this.holderIdInputTextField.setPromptText(BankUtil.getHolderIdLabel((String)countryCode));
        }
    }

    @Override
    protected void autoFillNameTextField() {
        if (this.useCustomAccountNameToggleButton != null && !this.useCustomAccountNameToggleButton.isSelected()) {
            String accountNr;
            BankAccountPayload payload = (BankAccountPayload)this.paymentAccount.paymentAccountPayload;
            String bankId = null;
            String countryCode = payload.getCountryCode();
            if (countryCode == null) {
                countryCode = "";
            }
            if (BankUtil.isBankIdRequired((String)countryCode)) {
                bankId = payload.getBankId();
                if (bankId.length() > 9) {
                    bankId = StringUtils.abbreviate((String)bankId, (int)9);
                }
            } else if (BankUtil.isBranchIdRequired((String)countryCode)) {
                bankId = payload.getBranchId();
                if (bankId.length() > 9) {
                    bankId = StringUtils.abbreviate((String)bankId, (int)9);
                }
            } else if (BankUtil.isBankNameRequired((String)countryCode) && (bankId = payload.getBankName()).length() > 9) {
                bankId = StringUtils.abbreviate((String)bankId, (int)9);
            }
            if ((accountNr = payload.getAccountNr()).length() > 9) {
                accountNr = StringUtils.abbreviate((String)accountNr, (int)9);
            }
            String method = Res.get((String)this.paymentAccount.getPaymentMethod().getId());
            if (bankId != null && !bankId.isEmpty()) {
                this.accountNameTextField.setText(method.concat(": ").concat(bankId).concat(", ").concat(accountNr));
            } else {
                this.accountNameTextField.setText(method.concat(": ").concat(accountNr));
            }
            if (BankUtil.isNationalAccountIdRequired((String)countryCode)) {
                String nationalAccountId = this.nationalAccountIdInputTextField.getText();
                if (countryCode.equals("AR") && nationalAccountId.length() == 22 && !this.accountNrInputTextFieldEdited) {
                    this.branchIdInputTextField.setText(nationalAccountId.substring(3, 7));
                    this.accountNrInputTextField.setText(nationalAccountId.substring(8, 21));
                }
            }
        }
    }

    boolean getValidationResult(boolean result, String countryCode, String bankName, String bankId, String branchId, String accountNr, String accountType, String holderTaxId, String nationalAccountId) {
        if (this.validatorsApplied && BankUtil.useValidation((String)countryCode)) {
            if (BankUtil.isBankNameRequired((String)countryCode)) {
                boolean bl = result = result && this.bankNameInputTextField.getValidator().validate((String)bankName).isValid;
            }
            if (BankUtil.isBankIdRequired((String)countryCode)) {
                boolean bl = result = result && this.bankIdInputTextField.getValidator().validate((String)bankId).isValid;
            }
            if (BankUtil.isBranchIdRequired((String)countryCode)) {
                boolean bl = result = result && this.branchIdInputTextField.getValidator().validate((String)branchId).isValid;
            }
            if (BankUtil.isAccountNrRequired((String)countryCode)) {
                boolean bl = result = result && this.accountNrInputTextField.getValidator().validate((String)accountNr).isValid;
            }
            if (BankUtil.isAccountTypeRequired((String)countryCode)) {
                boolean bl = result = result && accountType != null;
            }
            if (this.useHolderID && BankUtil.isHolderIdRequired((String)countryCode)) {
                boolean bl = result = result && this.holderIdInputTextField.getValidator().validate((String)holderTaxId).isValid;
            }
            if (BankUtil.isNationalAccountIdRequired((String)countryCode)) {
                result = result && this.nationalAccountIdInputTextField.getValidator().validate((String)nationalAccountId).isValid;
            }
        } else {
            result = result && (this.accountNrInputTextField == null || this.accountNrInputTextField.getValidator().validate((String)accountNr).isValid);
        }
        return result;
    }
}

