/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public abstract class GeneralAccountNumberForm
extends PaymentMethodForm {
    GeneralAccountNumberForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow + 1;
        InputTextField accountNrInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.no"));
        accountNrInputTextField.setValidator(this.inputValidator);
        accountNrInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.setAccountNumber((String)newValue);
            this.updateFromInputs();
        });
        this.addTradeCurrency();
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    public void addTradeCurrency() {
        TradeCurrency singleTradeCurrency = this.paymentAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "";
        FormBuilder.addTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.getAccountNr());
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.paymentAccount.getPaymentMethod().getId()));
        TextField field = (TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.account.no"), (String)this.getAccountNr()).second;
        field.setMouseTransparent(false);
        String nameAndCode = this.paymentAccount.getSingleTradeCurrency() != null ? this.paymentAccount.getSingleTradeCurrency().getNameAndCode() : "";
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        this.addLimitations(true);
    }

    @Override
    public void updateAllInputsValid() {
        this.allInputsValid.set(this.isAccountNameValid() && this.inputValidator.validate((String)this.getAccountNr()).isValid && this.paymentAccount.getTradeCurrencies().size() > 0);
    }

    abstract void setAccountNumber(String var1);

    abstract String getAccountNr();
}

