/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.FasterPaymentsAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.FasterPaymentsAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.validation.AccountNrValidator;
import haveno.core.payment.validation.BranchIdValidator;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public class FasterPaymentsForm
extends PaymentMethodForm {
    private static final String UK_SORT_CODE = Res.get((String)"payment.fasterPayments.ukSortCode");
    private final FasterPaymentsAccount fasterPaymentsAccount;
    private InputTextField holderNameInputTextField;
    private InputTextField accountNrInputTextField;
    private InputTextField sortCodeInputTextField;
    private final BranchIdValidator branchIdValidator;
    private final AccountNrValidator accountNrValidator;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        if (!((FasterPaymentsAccountPayload)paymentAccountPayload).getHolderName().isEmpty()) {
            FormBuilder.addCompactTopLabelTextField(gridPane, ++gridRow, Res.get((String)"payment.account.owner"), ((FasterPaymentsAccountPayload)paymentAccountPayload).getHolderName());
        }
        FormBuilder.addCompactTopLabelTextField(gridPane, ++gridRow, UK_SORT_CODE, ((FasterPaymentsAccountPayload)paymentAccountPayload).getSortCode());
        FormBuilder.addCompactTopLabelTextField(gridPane, gridRow, 1, Res.get((String)"payment.accountNr"), ((FasterPaymentsAccountPayload)paymentAccountPayload).getAccountNr());
        return gridRow;
    }

    public FasterPaymentsForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.fasterPaymentsAccount = (FasterPaymentsAccount)paymentAccount;
        this.branchIdValidator = new BranchIdValidator("GB");
        this.accountNrValidator = new AccountNrValidator("GB");
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow + 1;
        this.holderNameInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"));
        this.holderNameInputTextField.setValidator(this.inputValidator);
        this.holderNameInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.fasterPaymentsAccount.setHolderName(newValue);
            this.updateFromInputs();
        });
        this.sortCodeInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, UK_SORT_CODE);
        this.sortCodeInputTextField.setValidator(this.inputValidator);
        this.sortCodeInputTextField.setValidator((InputValidator)this.branchIdValidator);
        this.sortCodeInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.fasterPaymentsAccount.setSortCode(newValue);
            this.updateFromInputs();
        });
        this.accountNrInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.accountNr"));
        this.accountNrInputTextField.setValidator((InputValidator)this.accountNrValidator);
        this.accountNrInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.fasterPaymentsAccount.setAccountNr(newValue);
            this.updateFromInputs();
        });
        TradeCurrency singleTradeCurrency = this.fasterPaymentsAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "";
        FormBuilder.addTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.fasterPaymentsAccount.getAccountNr());
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.fasterPaymentsAccount.getPaymentMethod().getId()));
        if (!this.fasterPaymentsAccount.getHolderName().isEmpty()) {
            FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"), this.fasterPaymentsAccount.getHolderName());
        }
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, UK_SORT_CODE, this.fasterPaymentsAccount.getSortCode());
        TextField field = (TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.accountNr"), (String)this.fasterPaymentsAccount.getAccountNr()).second;
        field.setMouseTransparent(false);
        TradeCurrency singleTradeCurrency = this.fasterPaymentsAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "";
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        this.addLimitations(true);
    }

    @Override
    public void updateAllInputsValid() {
        this.allInputsValid.set(this.isAccountNameValid() && this.inputValidator.validate((String)this.fasterPaymentsAccount.getHolderName()).isValid && this.branchIdValidator.validate((String)this.fasterPaymentsAccount.getSortCode()).isValid && this.accountNrValidator.validate((String)this.fasterPaymentsAccount.getAccountNr()).isValid && this.fasterPaymentsAccount.getTradeCurrencies().size() > 0);
    }
}

