/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import com.jfoenix.controls.JFXTextArea;
import haveno.common.util.Tuple2;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Country;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.offer.Offer;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.F2FAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.F2FAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.validation.F2FValidator;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;

public class F2FForm
extends PaymentMethodForm {
    private final F2FAccount f2fAccount;
    private final F2FValidator f2fValidator;
    private Country selectedCountry;

    public static int addStep2Form(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload, Offer offer, double top, boolean isBuyer) {
        F2FAccountPayload f2fAccountPayload = (F2FAccountPayload)paymentAccountPayload;
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, 0, Res.get((String)"shared.country"), CountryUtil.getNameAndCode((String)f2fAccountPayload.getCountryCode()), top);
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, gridRow, 1, Res.get((String)"payment.f2f.city"), offer.getF2FCity(), top);
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, Res.get((String)"payment.f2f.contact"), isBuyer ? f2fAccountPayload.getContact() : Res.get((String)"shared.na"));
        TextArea textArea = (TextArea)FormBuilder.addTopLabelTextArea((GridPane)gridPane, (int)gridRow, (int)1, (String)Res.get((String)"payment.shared.extraInfo"), (String)"").second;
        textArea.setMinHeight(70.0);
        textArea.setEditable(false);
        textArea.setId("text-area-disabled");
        textArea.setText(offer.getPaymentAccountExtraInfo());
        return gridRow;
    }

    public F2FForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, F2FValidator f2fValidator, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.f2fAccount = (F2FAccount)paymentAccount;
        this.f2fValidator = f2fValidator;
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow + 1;
        Tuple2<ComboBox<TradeCurrency>, Integer> tuple = GUIUtil.addRegionCountryTradeCurrencyComboBoxes(this.gridPane, this.gridRow, this::onCountrySelected, this::onTradeCurrencySelected);
        this.currencyComboBox = (ComboBox)tuple.first;
        this.gridRow = (Integer)tuple.second;
        InputTextField contactInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.f2f.contact"));
        contactInputTextField.setPromptText(Res.get((String)"payment.f2f.contact.prompt"));
        contactInputTextField.setValidator((InputValidator)this.f2fValidator);
        contactInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.f2fAccount.setContact(newValue);
            this.updateFromInputs();
        });
        InputTextField cityInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.f2f.city"));
        cityInputTextField.setPromptText(Res.get((String)"payment.f2f.city.prompt"));
        cityInputTextField.setValidator((InputValidator)this.f2fValidator);
        cityInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.f2fAccount.setCity(newValue);
            this.updateFromInputs();
        });
        TextArea extraTextArea = (TextArea)FormBuilder.addTopLabelTextArea((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.shared.optionalExtra"), (String)Res.get((String)"payment.shared.extraInfo.prompt.paymentAccount")).second;
        extraTextArea.setMinHeight(70.0);
        ((JFXTextArea)extraTextArea).setLabelFloat(false);
        extraTextArea.textProperty().addListener((ov, oldValue, newValue) -> {
            this.f2fAccount.setExtraInfo(newValue);
            this.updateFromInputs();
        });
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    private void onCountrySelected(Country country) {
        this.selectedCountry = country;
        if (this.selectedCountry != null) {
            this.getCountryBasedPaymentAccount().setCountry(this.selectedCountry);
            String countryCode = this.selectedCountry.code;
            TraditionalCurrency currency = CurrencyUtil.getCurrencyByCountryCode((String)countryCode);
            this.paymentAccount.setSingleTradeCurrency((TradeCurrency)currency);
            this.currencyComboBox.setDisable(false);
            this.currencyComboBox.getSelectionModel().select((Object)currency);
            this.updateFromInputs();
        }
    }

    private void onTradeCurrencySelected(TradeCurrency tradeCurrency) {
        TraditionalCurrency defaultCurrency = CurrencyUtil.getCurrencyByCountryCode((String)this.selectedCountry.code);
        this.applyTradeCurrency(tradeCurrency, defaultCurrency);
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.f2fAccount.getCity());
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.paymentAccount.getPaymentMethod().getId()));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.country"), this.getCountryBasedPaymentAccount().getCountry() != null ? this.getCountryBasedPaymentAccount().getCountry().name : "");
        TradeCurrency singleTradeCurrency = this.paymentAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "null";
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.f2f.contact", (Object[])new Object[]{this.f2fAccount.getContact()}), this.f2fAccount.getContact());
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.f2f.city", (Object[])new Object[]{this.f2fAccount.getCity()}), this.f2fAccount.getCity());
        TextArea textArea = (TextArea)FormBuilder.addCompactTopLabelTextArea((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.shared.extraInfo"), (String)"").second;
        textArea.setText(this.f2fAccount.getExtraInfo());
        textArea.setMinHeight(70.0);
        textArea.setEditable(false);
        this.addLimitations(true);
    }

    @Override
    public void updateAllInputsValid() {
        this.allInputsValid.set(this.isAccountNameValid() && this.f2fValidator.validate((String)this.f2fAccount.getContact()).isValid && this.f2fValidator.validate((String)this.f2fAccount.getCity()).isValid && this.f2fAccount.getTradeCurrencies().size() > 0);
    }

    private CountryBasedPaymentAccount getCountryBasedPaymentAccount() {
        return (CountryBasedPaymentAccount)this.paymentAccount;
    }
}

