/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Country;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.DomesticWireTransferAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.BankAccountPayload;
import haveno.core.payment.payload.DomesticWireTransferAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.paymentmethods.GeneralUsBankForm;
import javafx.scene.layout.GridPane;

public class DomesticWireTransferForm
extends GeneralUsBankForm {
    private final DomesticWireTransferAccount domesticWireTransferAccount;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        DomesticWireTransferAccountPayload domesticWireTransferAccountPayload = (DomesticWireTransferAccountPayload)paymentAccountPayload;
        return DomesticWireTransferForm.addFormForBuyer(gridPane, gridRow, paymentAccountPayload, null, domesticWireTransferAccountPayload.getHolderAddress());
    }

    public DomesticWireTransferForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.domesticWireTransferAccount = (DomesticWireTransferAccount)paymentAccount;
    }

    @Override
    public void addFormForEditAccount() {
        this.addFormForEditAccount((BankAccountPayload)this.domesticWireTransferAccount.getPayload(), this.domesticWireTransferAccount.getPayload().getHolderAddress());
    }

    @Override
    public void addFormForAddAccount() {
        this.addFormForAddAccountInternal((BankAccountPayload)this.domesticWireTransferAccount.getPayload(), this.domesticWireTransferAccount.getPayload().getHolderAddress());
    }

    @Override
    protected void setHolderAddress(String holderAddress) {
        this.domesticWireTransferAccount.getPayload().setHolderAddress(holderAddress);
    }

    @Override
    protected void maybeAddAccountTypeCombo(BankAccountPayload bankAccountPayload, Country country) {
    }

    @Override
    public void updateAllInputsValid() {
        DomesticWireTransferAccountPayload domesticWireTransferAccountPayload = this.domesticWireTransferAccount.getPayload();
        boolean result = this.isAccountNameValid() && this.paymentAccount.getSingleTradeCurrency() != null && ((CountryBasedPaymentAccount)this.paymentAccount).getCountry() != null && this.inputValidator.validate((String)domesticWireTransferAccountPayload.getHolderName()).isValid && this.inputValidator.validate((String)domesticWireTransferAccountPayload.getHolderAddress()).isValid;
        result = this.getValidationResult(result, domesticWireTransferAccountPayload.getCountryCode(), domesticWireTransferAccountPayload.getBankName(), domesticWireTransferAccountPayload.getBankId(), domesticWireTransferAccountPayload.getBranchId(), domesticWireTransferAccountPayload.getAccountNr(), domesticWireTransferAccountPayload.getAccountNr(), domesticWireTransferAccountPayload.getHolderTaxId(), domesticWireTransferAccountPayload.getNationalAccountId());
        this.allInputsValid.set(result);
    }
}

