/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.ChaseQuickPayAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.ChaseQuickPayAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.validation.ChaseQuickPayValidator;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public class ChaseQuickPayForm
extends PaymentMethodForm {
    private final ChaseQuickPayAccount chaseQuickPayAccount;
    private final ChaseQuickPayValidator chaseQuickPayValidator;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        FormBuilder.addCompactTopLabelTextField(gridPane, ++gridRow, Res.get((String)"payment.account.owner"), ((ChaseQuickPayAccountPayload)paymentAccountPayload).getHolderName());
        FormBuilder.addCompactTopLabelTextField(gridPane, ++gridRow, Res.get((String)"payment.email"), ((ChaseQuickPayAccountPayload)paymentAccountPayload).getEmail());
        return gridRow;
    }

    public ChaseQuickPayForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, ChaseQuickPayValidator chaseQuickPayValidator, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.chaseQuickPayAccount = (ChaseQuickPayAccount)paymentAccount;
        this.chaseQuickPayValidator = chaseQuickPayValidator;
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow + 1;
        InputTextField holderNameInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"));
        holderNameInputTextField.setValidator(this.inputValidator);
        holderNameInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.chaseQuickPayAccount.setHolderName(newValue);
            this.updateFromInputs();
        });
        InputTextField mobileNrInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.email"));
        mobileNrInputTextField.setValidator((InputValidator)this.chaseQuickPayValidator);
        mobileNrInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.chaseQuickPayAccount.setEmail(newValue);
            this.updateFromInputs();
        });
        TradeCurrency singleTradeCurrency = this.chaseQuickPayAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "null";
        FormBuilder.addTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.chaseQuickPayAccount.getEmail());
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.chaseQuickPayAccount.getPaymentMethod().getId()));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"), this.chaseQuickPayAccount.getHolderName());
        TextField field = (TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.email"), (String)this.chaseQuickPayAccount.getEmail()).second;
        field.setMouseTransparent(false);
        TradeCurrency singleTradeCurrency = this.chaseQuickPayAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "null";
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        this.addLimitations(true);
    }

    @Override
    public void updateAllInputsValid() {
        this.allInputsValid.set(this.isAccountNameValid() && this.chaseQuickPayValidator.validate((String)this.chaseQuickPayAccount.getEmail()).isValid && this.inputValidator.validate((String)this.chaseQuickPayAccount.getHolderName()).isValid && this.chaseQuickPayAccount.getTradeCurrencies().size() > 0);
    }
}

