/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.common.util.Tuple2;
import haveno.common.util.Tuple4;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.BankUtil;
import haveno.core.locale.Country;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.CashDepositAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.validation.EmailValidator;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.GeneralBankForm;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import java.util.Collection;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public class CashDepositForm
extends GeneralBankForm {
    private final CashDepositAccountPayload cashDepositAccountPayload;
    private InputTextField holderNameInputTextField;
    private InputTextField emailInputTextField;
    private ComboBox<String> accountTypeComboBox;
    private final EmailValidator emailValidator;
    private Country selectedCountry;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        CashDepositAccountPayload data = (CashDepositAccountPayload)paymentAccountPayload;
        String countryCode = data.getCountryCode();
        Object requirements = data.getRequirements();
        boolean showRequirements = requirements != null && !((String)requirements).isEmpty();
        int colIndex = 0;
        if (data.getHolderTaxId() != null) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, CashDepositForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, CashDepositForm.getIndexOfColumn(colIndex++), Res.get((String)"payment.account.name.emailAndHolderId", (Object[])new Object[]{BankUtil.getHolderIdLabel((String)countryCode)}), data.getHolderName() + " / " + data.getHolderEmail() + " / " + data.getHolderTaxId());
        } else {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, CashDepositForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, CashDepositForm.getIndexOfColumn(colIndex++), Res.get((String)"payment.account.name.email"), data.getHolderName() + " / " + data.getHolderEmail());
        }
        if (!showRequirements) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, CashDepositForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, CashDepositForm.getIndexOfColumn(colIndex++), Res.getWithCol((String)"payment.bank.country"), CountryUtil.getNameAndCode((String)countryCode));
        } else {
            requirements = (String)requirements + "\n" + Res.get((String)"payment.bank.country") + " " + CountryUtil.getNameAndCode((String)countryCode);
        }
        int nrRows = 0;
        if (BankUtil.isBankNameRequired((String)countryCode)) {
            ++nrRows;
        }
        if (BankUtil.isBankIdRequired((String)countryCode)) {
            ++nrRows;
        }
        if (BankUtil.isBranchIdRequired((String)countryCode)) {
            ++nrRows;
        }
        if (BankUtil.isAccountNrRequired((String)countryCode)) {
            ++nrRows;
        }
        if (BankUtil.isAccountTypeRequired((String)countryCode)) {
            ++nrRows;
        }
        if (BankUtil.isNationalAccountIdRequired((String)countryCode)) {
            ++nrRows;
        }
        String bankNameLabel = BankUtil.getBankNameLabel((String)countryCode);
        String bankIdLabel = BankUtil.getBankIdLabel((String)countryCode);
        String branchIdLabel = BankUtil.getBranchIdLabel((String)countryCode);
        String nationalAccountIdLabel = BankUtil.getNationalAccountIdLabel((String)countryCode);
        String accountNrLabel = BankUtil.getAccountNrLabel((String)countryCode);
        String accountTypeLabel = BankUtil.getAccountTypeLabel((String)countryCode);
        accountNrAccountTypeCombined = false;
        nationalAccountIdAccountNrCombined = false;
        bankNameBankIdCombined = false;
        bankIdBranchIdCombined = false;
        bankNameBranchIdCombined = false;
        branchIdAccountNrCombined = false;
        CashDepositForm.prepareFormLayoutFlags(countryCode, nrRows);
        if (bankNameBankIdCombined) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, CashDepositForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, CashDepositForm.getIndexOfColumn(colIndex++), bankNameLabel + " / " + bankIdLabel, data.getBankName() + " / " + data.getBankId());
        }
        if (bankNameBranchIdCombined) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, CashDepositForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, CashDepositForm.getIndexOfColumn(colIndex++), bankNameLabel + " / " + branchIdLabel, data.getBankName() + " / " + data.getBranchId());
        }
        if (!bankNameBankIdCombined && !bankNameBranchIdCombined && BankUtil.isBankNameRequired((String)countryCode)) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, CashDepositForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, CashDepositForm.getIndexOfColumn(colIndex++), bankNameLabel, data.getBankName());
        }
        if (!bankNameBankIdCombined && !bankNameBranchIdCombined && !branchIdAccountNrCombined && bankIdBranchIdCombined) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, CashDepositForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, CashDepositForm.getIndexOfColumn(colIndex++), bankIdLabel + " / " + branchIdLabel, data.getBankId() + " / " + data.getBranchId());
        }
        if (!bankNameBankIdCombined && !bankIdBranchIdCombined && BankUtil.isBankIdRequired((String)countryCode)) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, CashDepositForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, CashDepositForm.getIndexOfColumn(colIndex++), bankIdLabel, data.getBankId());
        }
        if (!bankNameBranchIdCombined && !bankIdBranchIdCombined && branchIdAccountNrCombined) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, CashDepositForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, CashDepositForm.getIndexOfColumn(colIndex++), branchIdLabel + " / " + accountNrLabel, data.getBranchId() + " / " + data.getAccountNr());
        }
        if (!bankNameBranchIdCombined && !bankIdBranchIdCombined && !branchIdAccountNrCombined && BankUtil.isBranchIdRequired((String)countryCode)) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, CashDepositForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, CashDepositForm.getIndexOfColumn(colIndex++), branchIdLabel, data.getBranchId());
        }
        if (!branchIdAccountNrCombined && accountNrAccountTypeCombined) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, CashDepositForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, CashDepositForm.getIndexOfColumn(colIndex++), accountNrLabel + " / " + accountTypeLabel, data.getAccountNr() + " / " + data.getAccountType());
        }
        if (!branchIdAccountNrCombined && !accountNrAccountTypeCombined && !nationalAccountIdAccountNrCombined && BankUtil.isAccountNrRequired((String)countryCode)) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, CashDepositForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, CashDepositForm.getIndexOfColumn(colIndex++), accountNrLabel, data.getAccountNr());
        }
        if (!accountNrAccountTypeCombined && BankUtil.isAccountTypeRequired((String)countryCode)) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, CashDepositForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, CashDepositForm.getIndexOfColumn(colIndex++), accountTypeLabel, data.getAccountType());
        }
        if (!branchIdAccountNrCombined && !accountNrAccountTypeCombined && nationalAccountIdAccountNrCombined) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, CashDepositForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, CashDepositForm.getIndexOfColumn(colIndex++), nationalAccountIdLabel + " / " + accountNrLabel, data.getNationalAccountId() + " / " + data.getAccountNr());
        }
        if (showRequirements) {
            TextArea textArea = (TextArea)FormBuilder.addCompactTopLabelTextArea((GridPane)gridPane, (int)(CashDepositForm.getIndexOfColumn((int)colIndex) == 0 ? ++gridRow : gridRow), (int)CashDepositForm.getIndexOfColumn((int)colIndex++), (String)Res.get((String)"payment.extras"), (String)"").second;
            textArea.setMinHeight(45.0);
            textArea.setMaxHeight(45.0);
            textArea.setEditable(false);
            textArea.setId("text-area-disabled");
            textArea.setText((String)requirements);
        }
        return gridRow;
    }

    public CashDepositForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.cashDepositAccountPayload = (CashDepositAccountPayload)paymentAccount.paymentAccountPayload;
        this.emailValidator = new EmailValidator();
    }

    @Override
    public void addFormForEditAccount() {
        String requirements;
        boolean showRequirements;
        this.gridRowFrom = this.gridRow++;
        String countryCode = this.cashDepositAccountPayload.getCountryCode();
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.paymentAccount.getPaymentMethod().getId()));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.country"), this.getCountryBasedPaymentAccount().getCountry() != null ? this.getCountryBasedPaymentAccount().getCountry().name : "");
        TradeCurrency singleTradeCurrency = this.paymentAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "null";
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        this.addHolderNameAndIdForDisplayAccount();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.email"), this.cashDepositAccountPayload.getHolderEmail());
        if (BankUtil.isBankNameRequired((String)countryCode)) {
            ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.bank.name"), (String)this.cashDepositAccountPayload.getBankName()).second).setMouseTransparent(false);
        }
        if (BankUtil.isBankIdRequired((String)countryCode)) {
            ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)BankUtil.getBankIdLabel((String)countryCode), (String)this.cashDepositAccountPayload.getBankId()).second).setMouseTransparent(false);
        }
        if (BankUtil.isBranchIdRequired((String)countryCode)) {
            ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)BankUtil.getBranchIdLabel((String)countryCode), (String)this.cashDepositAccountPayload.getBranchId()).second).setMouseTransparent(false);
        }
        if (BankUtil.isNationalAccountIdRequired((String)countryCode)) {
            ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)BankUtil.getNationalAccountIdLabel((String)countryCode), (String)this.cashDepositAccountPayload.getNationalAccountId()).second).setMouseTransparent(false);
        }
        if (BankUtil.isAccountNrRequired((String)countryCode)) {
            ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)BankUtil.getAccountNrLabel((String)countryCode), (String)this.cashDepositAccountPayload.getAccountNr()).second).setMouseTransparent(false);
        }
        if (BankUtil.isAccountTypeRequired((String)countryCode)) {
            ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)BankUtil.getAccountTypeLabel((String)countryCode), (String)this.cashDepositAccountPayload.getAccountType()).second).setMouseTransparent(false);
        }
        boolean bl = showRequirements = (requirements = this.cashDepositAccountPayload.getRequirements()) != null && !requirements.isEmpty();
        if (showRequirements) {
            TextArea textArea = (TextArea)FormBuilder.addCompactTopLabelTextArea((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.extras"), (String)"").second;
            textArea.setMinHeight(30.0);
            textArea.setMaxHeight(30.0);
            textArea.setEditable(false);
            textArea.setId("text-area-disabled");
            textArea.setText(requirements);
        }
        this.addLimitations(true);
    }

    @Override
    public void addFormForAddAccount() {
        this.accountNrInputTextFieldEdited = false;
        this.gridRowFrom = this.gridRow + 1;
        Tuple2<ComboBox<TradeCurrency>, Integer> tuple = GUIUtil.addRegionCountryTradeCurrencyComboBoxes(this.gridPane, this.gridRow, this::onCountrySelected, this::onTradeCurrencySelected);
        this.currencyComboBox = (ComboBox)tuple.first;
        this.gridRow = (Integer)tuple.second;
        this.addHolderNameAndId();
        this.nationalAccountIdInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, BankUtil.getNationalAccountIdLabel((String)""));
        this.nationalAccountIdInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.cashDepositAccountPayload.setNationalAccountId(newValue);
            this.updateFromInputs();
        });
        this.bankNameInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.bank.name"));
        this.bankNameInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.cashDepositAccountPayload.setBankName(newValue);
            this.updateFromInputs();
        });
        this.bankIdInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, BankUtil.getBankIdLabel((String)""));
        this.bankIdInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.cashDepositAccountPayload.setBankId(newValue);
            this.updateFromInputs();
        });
        this.branchIdInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, BankUtil.getBranchIdLabel((String)""));
        this.branchIdInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.cashDepositAccountPayload.setBranchId(newValue);
            this.updateFromInputs();
        });
        this.accountNrInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, BankUtil.getAccountNrLabel((String)""));
        this.accountNrInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.cashDepositAccountPayload.setAccountNr(newValue);
            this.updateFromInputs();
        });
        this.accountTypeComboBox = FormBuilder.addComboBox(this.gridPane, ++this.gridRow, Res.get((String)"payment.select.account"));
        this.accountTypeComboBox.setOnAction(e -> {
            if (BankUtil.isAccountTypeRequired((String)this.cashDepositAccountPayload.getCountryCode())) {
                this.cashDepositAccountPayload.setAccountType((String)this.accountTypeComboBox.getSelectionModel().getSelectedItem());
                this.updateFromInputs();
            }
        });
        TextArea requirementsTextArea = FormBuilder.addTextArea(this.gridPane, ++this.gridRow, Res.get((String)"payment.extras"));
        requirementsTextArea.setMinHeight(30.0);
        requirementsTextArea.setMaxHeight(90.0);
        requirementsTextArea.textProperty().addListener((ov, oldValue, newValue) -> {
            this.cashDepositAccountPayload.setRequirements(newValue);
            this.updateFromInputs();
        });
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        this.updateFromInputs();
    }

    private void onTradeCurrencySelected(TradeCurrency tradeCurrency) {
        TraditionalCurrency defaultCurrency = CurrencyUtil.getCurrencyByCountryCode((String)this.selectedCountry.code);
        this.applyTradeCurrency(tradeCurrency, defaultCurrency);
    }

    private void onCountrySelected(Country country) {
        this.selectedCountry = country;
        if (this.selectedCountry != null) {
            this.getCountryBasedPaymentAccount().setCountry(this.selectedCountry);
            String countryCode = this.selectedCountry.code;
            TraditionalCurrency currency = CurrencyUtil.getCurrencyByCountryCode((String)countryCode);
            this.paymentAccount.setSingleTradeCurrency((TradeCurrency)currency);
            this.currencyComboBox.setDisable(false);
            this.currencyComboBox.getSelectionModel().select((Object)currency);
            this.bankIdInputTextField.setPromptText(BankUtil.getBankIdLabel((String)countryCode));
            this.branchIdInputTextField.setPromptText(BankUtil.getBranchIdLabel((String)countryCode));
            this.nationalAccountIdInputTextField.setPromptText(BankUtil.getNationalAccountIdLabel((String)countryCode));
            this.accountNrInputTextField.setPromptText(BankUtil.getAccountNrLabel((String)countryCode));
            this.accountTypeComboBox.setPromptText(BankUtil.getAccountTypeLabel((String)countryCode));
            this.bankNameInputTextField.setText("");
            this.bankIdInputTextField.setText("");
            this.branchIdInputTextField.setText("");
            this.nationalAccountIdInputTextField.setText("");
            this.accountNrInputTextField.setText("");
            this.accountNrInputTextField.focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    this.accountNrInputTextFieldEdited = true;
                }
            });
            this.accountTypeComboBox.getSelectionModel().clearSelection();
            this.accountTypeComboBox.setItems(FXCollections.observableArrayList((Collection)BankUtil.getAccountTypeValues((String)countryCode)));
            this.validateInput(countryCode);
            this.holderNameInputTextField.resetValidation();
            this.emailInputTextField.resetValidation();
            this.bankNameInputTextField.resetValidation();
            this.bankIdInputTextField.resetValidation();
            this.branchIdInputTextField.resetValidation();
            this.accountNrInputTextField.resetValidation();
            this.nationalAccountIdInputTextField.resetValidation();
            this.holderNameInputTextField.validate();
            this.emailInputTextField.validate();
            this.bankNameInputTextField.validate();
            this.bankIdInputTextField.validate();
            this.branchIdInputTextField.validate();
            this.accountNrInputTextField.validate();
            this.nationalAccountIdInputTextField.validate();
            boolean requiresHolderId = BankUtil.isHolderIdRequired((String)countryCode);
            if (requiresHolderId) {
                this.holderNameInputTextField.minWidthProperty().unbind();
                this.holderNameInputTextField.setMinWidth(300.0);
            } else {
                this.holderNameInputTextField.minWidthProperty().bind((ObservableValue)this.currencyComboBox.widthProperty());
            }
            this.updateHolderIDInput(countryCode, requiresHolderId);
            boolean nationalAccountIdRequired = BankUtil.isNationalAccountIdRequired((String)countryCode);
            this.nationalAccountIdInputTextField.setVisible(nationalAccountIdRequired);
            this.nationalAccountIdInputTextField.setManaged(nationalAccountIdRequired);
            boolean bankNameRequired = BankUtil.isBankNameRequired((String)countryCode);
            this.bankNameInputTextField.setVisible(bankNameRequired);
            this.bankNameInputTextField.setManaged(bankNameRequired);
            boolean bankIdRequired = BankUtil.isBankIdRequired((String)countryCode);
            this.bankIdInputTextField.setVisible(bankIdRequired);
            this.bankIdInputTextField.setManaged(bankIdRequired);
            boolean branchIdRequired = BankUtil.isBranchIdRequired((String)countryCode);
            this.branchIdInputTextField.setVisible(branchIdRequired);
            this.branchIdInputTextField.setManaged(branchIdRequired);
            boolean accountNrRequired = BankUtil.isAccountNrRequired((String)countryCode);
            this.accountNrInputTextField.setVisible(accountNrRequired);
            this.accountNrInputTextField.setManaged(accountNrRequired);
            boolean accountTypeRequired = BankUtil.isAccountTypeRequired((String)countryCode);
            this.accountTypeComboBox.setVisible(accountTypeRequired);
            this.accountTypeComboBox.setManaged(accountTypeRequired);
            this.updateFromInputs();
            this.onCountryChanged();
        }
    }

    private CountryBasedPaymentAccount getCountryBasedPaymentAccount() {
        return (CountryBasedPaymentAccount)this.paymentAccount;
    }

    private void onCountryChanged() {
    }

    private void addHolderNameAndId() {
        Tuple2<InputTextField, InputTextField> tuple = FormBuilder.addInputTextFieldInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"), BankUtil.getHolderIdLabel((String)""));
        this.holderNameInputTextField = (InputTextField)((Object)tuple.first);
        this.holderNameInputTextField.setMinWidth(300.0);
        this.holderNameInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.cashDepositAccountPayload.setHolderName(newValue);
            this.updateFromInputs();
        });
        this.holderNameInputTextField.minWidthProperty().bind((ObservableValue)this.currencyComboBox.widthProperty());
        this.holderNameInputTextField.setValidator(this.inputValidator);
        this.emailInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.email"));
        this.emailInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.cashDepositAccountPayload.setHolderEmail(newValue);
            this.updateFromInputs();
        });
        this.emailInputTextField.minWidthProperty().bind((ObservableValue)this.currencyComboBox.widthProperty());
        this.emailInputTextField.setValidator((InputValidator)this.emailValidator);
        this.useHolderID = true;
        this.holderIdInputTextField = (InputTextField)((Object)tuple.second);
        this.holderIdInputTextField.setMinWidth(250.0);
        this.holderIdInputTextField.setVisible(false);
        this.holderIdInputTextField.setManaged(false);
        this.holderIdInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.cashDepositAccountPayload.setHolderTaxId(newValue);
            this.updateFromInputs();
        });
    }

    @Override
    public void updateAllInputsValid() {
        boolean result = this.isAccountNameValid() && this.paymentAccount.getSingleTradeCurrency() != null && this.getCountryBasedPaymentAccount().getCountry() != null && this.inputValidator.validate((String)this.cashDepositAccountPayload.getHolderName()).isValid && this.emailValidator.validate((String)this.cashDepositAccountPayload.getHolderEmail()).isValid;
        String countryCode = this.cashDepositAccountPayload.getCountryCode();
        result = this.getValidationResult(result, countryCode, this.cashDepositAccountPayload.getBankName(), this.cashDepositAccountPayload.getBankId(), this.cashDepositAccountPayload.getBranchId(), this.cashDepositAccountPayload.getAccountNr(), this.cashDepositAccountPayload.getAccountType(), this.cashDepositAccountPayload.getHolderTaxId(), this.cashDepositAccountPayload.getNationalAccountId());
        this.allInputsValid.set(result);
    }

    private void addHolderNameAndIdForDisplayAccount() {
        String countryCode = this.cashDepositAccountPayload.getCountryCode();
        if (BankUtil.isHolderIdRequired((String)countryCode)) {
            Tuple4<Label, TextField, Label, TextField> tuple = FormBuilder.addCompactTopLabelTextFieldTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"), BankUtil.getHolderIdLabel((String)countryCode));
            TextField holderNameTextField = (TextField)tuple.second;
            holderNameTextField.setText(this.cashDepositAccountPayload.getHolderName());
            holderNameTextField.setMinWidth(300.0);
            ((TextField)tuple.fourth).setText(this.cashDepositAccountPayload.getHolderTaxId());
        } else {
            FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"), this.cashDepositAccountPayload.getHolderName());
        }
    }
}

