/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import com.jfoenix.controls.JFXTextArea;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.CashAtAtmAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.CashAtAtmAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;

public class CashAtAtmForm
extends PaymentMethodForm {
    private final CashAtAtmAccount cashAtAtmAccount;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        CashAtAtmAccountPayload cashAtAtmPayload = (CashAtAtmAccountPayload)paymentAccountPayload;
        TextArea textExtraInfo = (TextArea)FormBuilder.addCompactTopLabelTextArea((GridPane)gridPane, (int)(++gridRow), (int)0, (String)Res.get((String)"payment.shared.extraInfo"), (String)"").second;
        textExtraInfo.setMinHeight(70.0);
        textExtraInfo.setEditable(false);
        textExtraInfo.setText(cashAtAtmPayload.getExtraInfo());
        return gridRow;
    }

    public CashAtAtmForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.cashAtAtmAccount = (CashAtAtmAccount)paymentAccount;
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow + 1;
        this.addTradeCurrencyComboBox();
        this.currencyComboBox.setItems(FXCollections.observableArrayList((Collection)CurrencyUtil.getAllSortedFiatCurrencies()));
        TextArea extraTextArea = (TextArea)FormBuilder.addTopLabelTextArea((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.shared.optionalExtra"), (String)Res.get((String)"payment.cashAtAtm.extraInfo.prompt")).second;
        extraTextArea.setMinHeight(70.0);
        ((JFXTextArea)extraTextArea).setLabelFloat(false);
        extraTextArea.textProperty().addListener((ov, oldValue, newValue) -> {
            this.cashAtAtmAccount.setExtraInfo(newValue);
            this.updateFromInputs();
        });
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    @Override
    protected void autoFillNameTextField() {
        if (this.cashAtAtmAccount.getExtraInfo() != null && !this.cashAtAtmAccount.getExtraInfo().isEmpty()) {
            this.setAccountNameWithString(this.cashAtAtmAccount.getExtraInfo().substring(0, Math.min(50, this.cashAtAtmAccount.getExtraInfo().length())));
        } else {
            this.setAccountNameWithString(this.cashAtAtmAccount.getSelectedTradeCurrency().getCode());
        }
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.cashAtAtmAccount.getPaymentMethod().getId()));
        TradeCurrency tradeCurrency = this.paymentAccount.getSingleTradeCurrency();
        String nameAndCode = tradeCurrency != null ? tradeCurrency.getNameAndCode() : "";
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        TextArea textAreaExtra = (TextArea)FormBuilder.addCompactTopLabelTextArea((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.shared.extraInfo"), (String)"").second;
        textAreaExtra.setText(this.cashAtAtmAccount.getExtraInfo());
        textAreaExtra.setMinHeight(70.0);
        textAreaExtra.setEditable(false);
        this.addLimitations(true);
    }

    @Override
    public void updateAllInputsValid() {
        this.allInputsValid.set(this.isAccountNameValid() && this.paymentAccount.getSingleTradeCurrency() != null);
    }
}

