/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import com.jfoenix.controls.JFXTextArea;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.CashAppAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.CashAppAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.validation.EmailOrMobileNrOrCashtagValidator;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;

public class CashAppForm
extends PaymentMethodForm {
    private final CashAppAccount cashAppAccount;
    private final EmailOrMobileNrOrCashtagValidator cashAppValidator;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, Res.get((String)"payment.email.mobile.cashtag"), ((CashAppAccountPayload)paymentAccountPayload).getEmailOrMobileNrOrCashtag());
        CashAppAccountPayload payId = (CashAppAccountPayload)paymentAccountPayload;
        TextArea textExtraInfo = (TextArea)FormBuilder.addCompactTopLabelTextArea((GridPane)gridPane, (int)(++gridRow), (String)Res.get((String)"payment.shared.extraInfo"), (String)"").second;
        textExtraInfo.setMinHeight(70.0);
        textExtraInfo.setEditable(false);
        textExtraInfo.setText(payId.getExtraInfo());
        return gridRow;
    }

    public CashAppForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, EmailOrMobileNrOrCashtagValidator cashAppValidator, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.cashAppAccount = (CashAppAccount)paymentAccount;
        this.cashAppValidator = cashAppValidator;
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow + 1;
        InputTextField mobileNrInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.email.mobile.cashtag"));
        mobileNrInputTextField.setValidator((InputValidator)this.cashAppValidator);
        mobileNrInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.cashAppAccount.setEmailOrMobileNrOrCashtag(newValue.trim());
            this.updateFromInputs();
        });
        TextArea extraTextArea = (TextArea)FormBuilder.addTopLabelTextArea((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.shared.optionalExtra"), (String)Res.get((String)"payment.shared.extraInfo.prompt.paymentAccount")).second;
        extraTextArea.setMinHeight(70.0);
        ((JFXTextArea)extraTextArea).setLabelFloat(false);
        extraTextArea.textProperty().addListener((ov, oldValue, newValue) -> {
            this.cashAppAccount.setExtraInfo(newValue);
            this.updateFromInputs();
        });
        this.addCurrenciesGrid(true);
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    private void addCurrenciesGrid(boolean isEditable) {
        FlowPane flowPane = (FlowPane)FormBuilder.addTopLabelFlowPane((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.supportedCurrencies"), (double)69.0, (double)69.0).second;
        if (isEditable) {
            flowPane.setId("flow-pane-checkboxes-bg");
        } else {
            flowPane.setId("flow-pane-checkboxes-non-editable-bg");
        }
        this.cashAppAccount.getSupportedCurrencies().forEach(e -> this.fillUpFlowPaneWithCurrencies(isEditable, flowPane, (TradeCurrency)e, (PaymentAccount)this.cashAppAccount));
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.cashAppAccount.getEmailOrMobileNrOrCashtag());
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.cashAppAccount.getPaymentMethod().getId()));
        TextField field = (TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.email.mobile.cashtag"), (String)this.cashAppAccount.getEmailOrMobileNrOrCashtag()).second;
        TextArea textAreaExtra = (TextArea)FormBuilder.addCompactTopLabelTextArea((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.shared.extraInfo"), (String)"").second;
        textAreaExtra.setText(this.cashAppAccount.getExtraInfo());
        textAreaExtra.setMinHeight(70.0);
        textAreaExtra.setEditable(false);
        field.setMouseTransparent(false);
        this.addLimitations(true);
        this.addCurrenciesGrid(false);
    }

    @Override
    public void updateAllInputsValid() {
        this.allInputsValid.set(this.isAccountNameValid() && this.cashAppValidator.validate((String)this.cashAppAccount.getEmailOrMobileNrOrCashtag()).isValid && this.cashAppAccount.getTradeCurrencies().size() > 0);
    }
}

