/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.common.util.Tuple2;
import haveno.common.util.Tuple4;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.BankUtil;
import haveno.core.locale.Country;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.BankAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.GeneralBankForm;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import java.util.Collection;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

abstract class BankForm
extends GeneralBankForm {
    private final BankAccountPayload bankAccountPayload;
    private InputTextField holderNameInputTextField;
    private ComboBox<String> accountTypeComboBox;
    private Country selectedCountry;

    static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        BankAccountPayload data = (BankAccountPayload)paymentAccountPayload;
        String countryCode = ((BankAccountPayload)paymentAccountPayload).getCountryCode();
        int colIndex = 0;
        if (data.getHolderTaxId() != null) {
            title = Res.get((String)"payment.account.owner") + " / " + BankUtil.getHolderIdLabelShort((String)countryCode);
            value = data.getHolderName() + " / " + data.getHolderTaxId();
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, BankForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, BankForm.getIndexOfColumn(colIndex++), (String)title, (String)value);
        } else {
            title = Res.get((String)"payment.account.owner");
            value = data.getHolderName();
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, BankForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, BankForm.getIndexOfColumn(colIndex++), (String)title, (String)value);
        }
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, BankForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, BankForm.getIndexOfColumn(colIndex++), Res.get((String)"payment.bank.country"), CountryUtil.getNameAndCode((String)countryCode));
        int nrRows = 0;
        if (BankUtil.isBankNameRequired((String)countryCode)) {
            ++nrRows;
        }
        if (BankUtil.isBankIdRequired((String)countryCode)) {
            ++nrRows;
        }
        if (BankUtil.isBranchIdRequired((String)countryCode)) {
            ++nrRows;
        }
        if (BankUtil.isAccountNrRequired((String)countryCode)) {
            ++nrRows;
        }
        if (BankUtil.isAccountTypeRequired((String)countryCode)) {
            ++nrRows;
        }
        if (BankUtil.isNationalAccountIdRequired((String)countryCode)) {
            ++nrRows;
        }
        String bankNameLabel = BankUtil.getBankNameLabel((String)countryCode);
        String bankIdLabel = BankUtil.getBankIdLabel((String)countryCode);
        String branchIdLabel = BankUtil.getBranchIdLabel((String)countryCode);
        String nationalAccountIdLabel = BankUtil.getNationalAccountIdLabel((String)countryCode);
        String accountNrLabel = BankUtil.getAccountNrLabel((String)countryCode);
        String accountTypeLabel = BankUtil.getAccountTypeLabel((String)countryCode);
        accountNrAccountTypeCombined = false;
        nationalAccountIdAccountNrCombined = false;
        bankNameBankIdCombined = false;
        bankIdBranchIdCombined = false;
        bankNameBranchIdCombined = false;
        branchIdAccountNrCombined = false;
        BankForm.prepareFormLayoutFlags(countryCode, nrRows);
        if (bankNameBankIdCombined) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, BankForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, BankForm.getIndexOfColumn(colIndex++), bankNameLabel + " / " + bankIdLabel + ":", data.getBankName() + " / " + data.getBankId(), true);
        }
        if (bankNameBranchIdCombined) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, BankForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, BankForm.getIndexOfColumn(colIndex++), bankNameLabel + " / " + branchIdLabel + ":", data.getBankName() + " / " + data.getBranchId(), true);
        }
        if (!bankNameBankIdCombined && !bankNameBranchIdCombined && BankUtil.isBankNameRequired((String)countryCode)) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, BankForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, BankForm.getIndexOfColumn(colIndex++), bankNameLabel, data.getBankName());
        }
        if (!bankNameBankIdCombined && !bankNameBranchIdCombined && !branchIdAccountNrCombined && bankIdBranchIdCombined) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, BankForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, BankForm.getIndexOfColumn(colIndex++), bankIdLabel + " / " + branchIdLabel + ":", data.getBankId() + " / " + data.getBranchId());
        }
        if (!bankNameBankIdCombined && !bankIdBranchIdCombined && BankUtil.isBankIdRequired((String)countryCode)) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, BankForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, BankForm.getIndexOfColumn(colIndex++), bankIdLabel, data.getBankId());
        }
        if (!bankNameBranchIdCombined && !bankIdBranchIdCombined && branchIdAccountNrCombined) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, BankForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, BankForm.getIndexOfColumn(colIndex++), branchIdLabel + " / " + accountNrLabel + ":", data.getBranchId() + " / " + data.getAccountNr());
        }
        if (!bankNameBranchIdCombined && !bankIdBranchIdCombined && !branchIdAccountNrCombined && BankUtil.isBranchIdRequired((String)countryCode)) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, BankForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, BankForm.getIndexOfColumn(colIndex++), branchIdLabel, data.getBranchId());
        }
        if (!branchIdAccountNrCombined && accountNrAccountTypeCombined) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, BankForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, BankForm.getIndexOfColumn(colIndex++), accountNrLabel + " / " + accountTypeLabel, data.getAccountNr() + " / " + data.getAccountType());
        }
        if (!branchIdAccountNrCombined && !accountNrAccountTypeCombined && !nationalAccountIdAccountNrCombined && BankUtil.isAccountNrRequired((String)countryCode)) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, BankForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, BankForm.getIndexOfColumn(colIndex++), accountNrLabel, data.getAccountNr());
        }
        if (!accountNrAccountTypeCombined && BankUtil.isAccountTypeRequired((String)countryCode)) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, BankForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, BankForm.getIndexOfColumn(colIndex++), accountTypeLabel, data.getAccountType());
        }
        if (!branchIdAccountNrCombined && !accountNrAccountTypeCombined && nationalAccountIdAccountNrCombined) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, BankForm.getIndexOfColumn(colIndex) == 0 ? ++gridRow : gridRow, BankForm.getIndexOfColumn(colIndex++), nationalAccountIdLabel + " / " + accountNrLabel, data.getNationalAccountId() + " / " + data.getAccountNr());
        }
        return gridRow;
    }

    BankForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.bankAccountPayload = (BankAccountPayload)paymentAccount.paymentAccountPayload;
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        String countryCode = this.bankAccountPayload.getCountryCode();
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.paymentAccount.getPaymentMethod().getId()));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.country"), this.getCountryBasedPaymentAccount().getCountry() != null ? this.getCountryBasedPaymentAccount().getCountry().name : "");
        TradeCurrency singleTradeCurrency = this.paymentAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "null";
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        this.addAcceptedBanksForDisplayAccount();
        this.addHolderNameAndIdForDisplayAccount();
        if (BankUtil.isBankNameRequired((String)countryCode)) {
            ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.bank.name"), (String)this.bankAccountPayload.getBankName()).second).setMouseTransparent(false);
        }
        if (BankUtil.isBankIdRequired((String)countryCode)) {
            ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)BankUtil.getBankIdLabel((String)countryCode), (String)this.bankAccountPayload.getBankId()).second).setMouseTransparent(false);
        }
        if (BankUtil.isBranchIdRequired((String)countryCode)) {
            ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)BankUtil.getBranchIdLabel((String)countryCode), (String)this.bankAccountPayload.getBranchId()).second).setMouseTransparent(false);
        }
        if (BankUtil.isNationalAccountIdRequired((String)countryCode)) {
            ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)BankUtil.getNationalAccountIdLabel((String)countryCode), (String)this.bankAccountPayload.getNationalAccountId()).second).setMouseTransparent(false);
        }
        if (BankUtil.isAccountNrRequired((String)countryCode)) {
            ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)BankUtil.getAccountNrLabel((String)countryCode), (String)this.bankAccountPayload.getAccountNr()).second).setMouseTransparent(false);
        }
        if (BankUtil.isAccountTypeRequired((String)countryCode)) {
            ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)BankUtil.getAccountTypeLabel((String)countryCode), (String)this.bankAccountPayload.getAccountType()).second).setMouseTransparent(false);
        }
        this.addLimitations(true);
    }

    @Override
    public void addFormForAddAccount() {
        this.accountNrInputTextFieldEdited = false;
        this.gridRowFrom = this.gridRow + 1;
        Tuple2<ComboBox<TradeCurrency>, Integer> tuple = GUIUtil.addRegionCountryTradeCurrencyComboBoxes(this.gridPane, this.gridRow, this::onCountrySelected, this::onTradeCurrencySelected);
        this.currencyComboBox = (ComboBox)tuple.first;
        this.gridRow = (Integer)tuple.second;
        this.addAcceptedBanksForAddAccount();
        this.addHolderNameAndId();
        this.nationalAccountIdInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, BankUtil.getNationalAccountIdLabel((String)""));
        this.nationalAccountIdInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.bankAccountPayload.setNationalAccountId(newValue);
            this.updateFromInputs();
        });
        this.bankNameInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.bank.name"));
        this.bankNameInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.bankAccountPayload.setBankName(newValue.trim());
            this.updateFromInputs();
        });
        this.bankIdInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, BankUtil.getBankIdLabel((String)""));
        this.bankIdInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.bankAccountPayload.setBankId(newValue.trim());
            this.updateFromInputs();
        });
        this.branchIdInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, BankUtil.getBranchIdLabel((String)""));
        this.branchIdInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.bankAccountPayload.setBranchId(newValue.trim());
            this.updateFromInputs();
        });
        this.accountNrInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, BankUtil.getAccountNrLabel((String)""));
        this.accountNrInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.bankAccountPayload.setAccountNr(newValue.trim());
            this.updateFromInputs();
        });
        this.accountTypeComboBox = FormBuilder.addComboBox(this.gridPane, ++this.gridRow, "");
        this.accountTypeComboBox.setPromptText(Res.get((String)"payment.select.account"));
        this.accountTypeComboBox.setOnAction(e -> {
            if (BankUtil.isAccountTypeRequired((String)this.bankAccountPayload.getCountryCode())) {
                this.bankAccountPayload.setAccountType((String)this.accountTypeComboBox.getSelectionModel().getSelectedItem());
                this.updateFromInputs();
            }
        });
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        this.updateFromInputs();
    }

    private void onCountrySelected(Country country) {
        this.selectedCountry = country;
        if (country != null) {
            this.getCountryBasedPaymentAccount().setCountry(country);
            String countryCode = country.code;
            TraditionalCurrency currency = CurrencyUtil.getCurrencyByCountryCode((String)countryCode);
            this.paymentAccount.setSingleTradeCurrency((TradeCurrency)currency);
            this.currencyComboBox.setDisable(false);
            this.currencyComboBox.getSelectionModel().select((Object)currency);
            this.bankIdInputTextField.setPromptText(BankUtil.getBankIdLabel((String)countryCode));
            this.branchIdInputTextField.setPromptText(BankUtil.getBranchIdLabel((String)countryCode));
            this.nationalAccountIdInputTextField.setPromptText(BankUtil.getNationalAccountIdLabel((String)countryCode));
            this.accountNrInputTextField.setPromptText(BankUtil.getAccountNrLabel((String)countryCode));
            this.accountTypeComboBox.setPromptText(BankUtil.getAccountTypeLabel((String)countryCode));
            this.bankNameInputTextField.setText("");
            this.bankIdInputTextField.setText("");
            this.branchIdInputTextField.setText("");
            this.nationalAccountIdInputTextField.setText("");
            this.accountNrInputTextField.setText("");
            this.accountNrInputTextField.focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    this.accountNrInputTextFieldEdited = true;
                }
            });
            this.accountTypeComboBox.getSelectionModel().clearSelection();
            this.accountTypeComboBox.setItems(FXCollections.observableArrayList((Collection)BankUtil.getAccountTypeValues((String)countryCode)));
            this.validateInput(countryCode);
            this.holderNameInputTextField.resetValidation();
            this.holderNameInputTextField.validate();
            this.bankNameInputTextField.resetValidation();
            this.bankNameInputTextField.validate();
            this.bankIdInputTextField.resetValidation();
            this.bankIdInputTextField.validate();
            this.branchIdInputTextField.resetValidation();
            this.branchIdInputTextField.validate();
            this.accountNrInputTextField.resetValidation();
            this.accountNrInputTextField.validate();
            this.nationalAccountIdInputTextField.resetValidation();
            this.nationalAccountIdInputTextField.validate();
            boolean requiresHolderId = BankUtil.isHolderIdRequired((String)countryCode);
            if (requiresHolderId) {
                this.holderNameInputTextField.minWidthProperty().unbind();
                this.holderNameInputTextField.setMinWidth(250.0);
            } else {
                this.holderNameInputTextField.minWidthProperty().bind((ObservableValue)this.currencyComboBox.widthProperty());
            }
            this.updateHolderIDInput(countryCode, requiresHolderId);
            boolean nationalAccountIdRequired = BankUtil.isNationalAccountIdRequired((String)countryCode);
            this.nationalAccountIdInputTextField.setVisible(nationalAccountIdRequired);
            this.nationalAccountIdInputTextField.setManaged(nationalAccountIdRequired);
            boolean bankNameRequired = BankUtil.isBankNameRequired((String)countryCode);
            this.bankNameInputTextField.setVisible(bankNameRequired);
            this.bankNameInputTextField.setManaged(bankNameRequired);
            boolean bankIdRequired = BankUtil.isBankIdRequired((String)countryCode);
            this.bankIdInputTextField.setVisible(bankIdRequired);
            this.bankIdInputTextField.setManaged(bankIdRequired);
            boolean branchIdRequired = BankUtil.isBranchIdRequired((String)countryCode);
            this.branchIdInputTextField.setVisible(branchIdRequired);
            this.branchIdInputTextField.setManaged(branchIdRequired);
            boolean accountNrRequired = BankUtil.isAccountNrRequired((String)countryCode);
            this.accountNrInputTextField.setVisible(accountNrRequired);
            this.accountNrInputTextField.setManaged(accountNrRequired);
            boolean accountTypeRequired = BankUtil.isAccountTypeRequired((String)countryCode);
            this.accountTypeComboBox.setVisible(accountTypeRequired);
            this.accountTypeComboBox.setManaged(accountTypeRequired);
            this.updateFromInputs();
            this.onCountryChanged();
        }
    }

    private void onTradeCurrencySelected(TradeCurrency tradeCurrency) {
        TraditionalCurrency defaultCurrency = CurrencyUtil.getCurrencyByCountryCode((String)this.selectedCountry.code);
        this.applyTradeCurrency(tradeCurrency, defaultCurrency);
    }

    private CountryBasedPaymentAccount getCountryBasedPaymentAccount() {
        return (CountryBasedPaymentAccount)this.paymentAccount;
    }

    protected void onCountryChanged() {
    }

    private void addHolderNameAndId() {
        Tuple2<InputTextField, InputTextField> tuple = FormBuilder.addInputTextFieldInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"), BankUtil.getHolderIdLabel((String)""));
        this.holderNameInputTextField = (InputTextField)((Object)tuple.first);
        this.holderNameInputTextField.setMinWidth(250.0);
        this.holderNameInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.bankAccountPayload.setHolderName(newValue.trim());
            this.updateFromInputs();
        });
        this.holderNameInputTextField.minWidthProperty().bind((ObservableValue)this.currencyComboBox.widthProperty());
        this.holderNameInputTextField.setValidator(this.inputValidator);
        this.useHolderID = true;
        this.holderIdInputTextField = (InputTextField)((Object)tuple.second);
        this.holderIdInputTextField.setVisible(false);
        this.holderIdInputTextField.setManaged(false);
        this.holderIdInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.bankAccountPayload.setHolderTaxId(newValue);
            this.updateFromInputs();
        });
    }

    @Override
    public void updateAllInputsValid() {
        boolean result = this.isAccountNameValid() && this.paymentAccount.getSingleTradeCurrency() != null && this.getCountryBasedPaymentAccount().getCountry() != null && this.inputValidator.validate((String)this.bankAccountPayload.getHolderName()).isValid;
        String countryCode = this.bankAccountPayload.getCountryCode();
        result = this.getValidationResult(result, countryCode, this.bankAccountPayload.getBankName(), this.bankAccountPayload.getBankId(), this.bankAccountPayload.getBranchId(), this.bankAccountPayload.getAccountNr(), this.bankAccountPayload.getAccountType(), this.bankAccountPayload.getHolderTaxId(), this.bankAccountPayload.getNationalAccountId());
        this.allInputsValid.set(result);
    }

    private void addHolderNameAndIdForDisplayAccount() {
        String countryCode = this.bankAccountPayload.getCountryCode();
        if (BankUtil.isHolderIdRequired((String)countryCode)) {
            Tuple4<Label, TextField, Label, TextField> tuple = FormBuilder.addCompactTopLabelTextFieldTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"), BankUtil.getHolderIdLabel((String)countryCode));
            TextField holderNameTextField = (TextField)tuple.second;
            holderNameTextField.setText(this.bankAccountPayload.getHolderName());
            holderNameTextField.setMinWidth(250.0);
            ((TextField)tuple.fourth).setText(this.bankAccountPayload.getHolderTaxId());
        } else {
            FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"), this.bankAccountPayload.getHolderName());
        }
    }

    protected void addAcceptedBanksForAddAccount() {
    }

    public void addAcceptedBanksForDisplayAccount() {
    }
}

