/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import com.jfoenix.controls.JFXTextArea;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.AustraliaPayidAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.AustraliaPayidAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.validation.AustraliaPayidValidator;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public class AustraliaPayidForm
extends PaymentMethodForm {
    private final AustraliaPayidAccount australiaPayidAccount;
    private final AustraliaPayidValidator australiaPayidValidator;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        FormBuilder.addCompactTopLabelTextField(gridPane, ++gridRow, Res.get((String)"payment.account.owner"), ((AustraliaPayidAccountPayload)paymentAccountPayload).getBankAccountName());
        FormBuilder.addCompactTopLabelTextField(gridPane, gridRow, 1, Res.get((String)"payment.payid"), ((AustraliaPayidAccountPayload)paymentAccountPayload).getPayid());
        AustraliaPayidAccountPayload payId = (AustraliaPayidAccountPayload)paymentAccountPayload;
        TextArea textExtraInfo = (TextArea)FormBuilder.addCompactTopLabelTextArea((GridPane)gridPane, (int)(++gridRow), (String)Res.get((String)"payment.shared.extraInfo"), (String)"").second;
        textExtraInfo.setMinHeight(70.0);
        textExtraInfo.setEditable(false);
        textExtraInfo.setText(payId.getExtraInfo());
        return gridRow;
    }

    public AustraliaPayidForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, AustraliaPayidValidator australiaPayidValidator, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.australiaPayidAccount = (AustraliaPayidAccount)paymentAccount;
        this.australiaPayidValidator = australiaPayidValidator;
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow + 1;
        InputTextField holderNameInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.owner"));
        holderNameInputTextField.setValidator(this.inputValidator);
        holderNameInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.australiaPayidAccount.setBankAccountName(newValue);
            this.updateFromInputs();
        });
        InputTextField mobileNrInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.payid"));
        mobileNrInputTextField.setValidator((InputValidator)this.australiaPayidValidator);
        mobileNrInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.australiaPayidAccount.setPayid(newValue);
            this.updateFromInputs();
        });
        TextArea extraTextArea = (TextArea)FormBuilder.addTopLabelTextArea((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.shared.optionalExtra"), (String)Res.get((String)"payment.shared.extraInfo.prompt.paymentAccount")).second;
        extraTextArea.setMinHeight(70.0);
        ((JFXTextArea)extraTextArea).setLabelFloat(false);
        extraTextArea.textProperty().addListener((ov, oldValue, newValue) -> {
            this.australiaPayidAccount.setExtraInfo(newValue);
            this.updateFromInputs();
        });
        TradeCurrency singleTradeCurrency = this.australiaPayidAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "null";
        FormBuilder.addTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.australiaPayidAccount.getPayid());
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.australiaPayidAccount.getPaymentMethod().getId()));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.payid"), this.australiaPayidAccount.getPayid());
        TextField field = (TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.account.owner"), (String)this.australiaPayidAccount.getBankAccountName()).second;
        field.setMouseTransparent(false);
        TextArea textAreaExtra = (TextArea)FormBuilder.addCompactTopLabelTextArea((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.shared.extraInfo"), (String)"").second;
        textAreaExtra.setText(this.australiaPayidAccount.getExtraInfo());
        textAreaExtra.setMinHeight(70.0);
        textAreaExtra.setEditable(false);
        TradeCurrency singleTradeCurrency = this.australiaPayidAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "null";
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        this.addLimitations(true);
    }

    @Override
    public void updateAllInputsValid() {
        this.allInputsValid.set(this.isAccountNameValid() && this.australiaPayidValidator.validate((String)this.australiaPayidAccount.getPayid()).isValid && this.inputValidator.validate((String)this.australiaPayidAccount.getBankAccountName()).isValid && this.australiaPayidAccount.getTradeCurrencies().size() > 0);
    }
}

