/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.common.UserThread;
import haveno.common.util.Tuple3;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.filter.FilterManager;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.AssetAccount;
import haveno.core.payment.InstantCryptoCurrencyAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.AssetAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.validation.CryptoAddressValidator;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.AutocompleteComboBox;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;

public class AssetsForm
extends PaymentMethodForm {
    public static final String INSTANT_TRADE_NEWS = "instantTradeNews0.9.5";
    private final AssetAccount assetAccount;
    private final CryptoAddressValidator altCoinAddressValidator;
    private final FilterManager filterManager;
    private InputTextField addressInputTextField;
    private CheckBox tradeInstantCheckBox;
    private boolean tradeInstant;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload, String labelTitle) {
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, labelTitle, ((AssetAccountPayload)paymentAccountPayload).getAddress());
        return gridRow;
    }

    public AssetsForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, CryptoAddressValidator altCoinAddressValidator, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter, FilterManager filterManager) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.assetAccount = (AssetAccount)paymentAccount;
        this.altCoinAddressValidator = altCoinAddressValidator;
        this.filterManager = filterManager;
        this.tradeInstant = paymentAccount instanceof InstantCryptoCurrencyAccount;
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow + 1;
        this.addTradeCurrencyComboBox();
        this.currencyComboBox.setPrefWidth(250.0);
        this.tradeInstantCheckBox = FormBuilder.addLabelCheckBox(this.gridPane, ++this.gridRow, Res.get((String)"payment.crypto.tradeInstantCheckbox"), 10.0);
        this.tradeInstantCheckBox.setSelected(this.tradeInstant);
        this.tradeInstantCheckBox.setOnAction(e -> {
            this.tradeInstant = this.tradeInstantCheckBox.isSelected();
            if (this.tradeInstant) {
                ((Popup)new Popup().information(Res.get((String)"payment.crypto.tradeInstant.popup"))).show();
            }
            this.paymentLimitationsTextField.setText(this.getLimitationsText());
        });
        this.gridPane.getChildren().remove((Object)this.tradeInstantCheckBox);
        this.tradeInstantCheckBox.setPadding(new Insets(0.0, 40.0, 0.0, 0.0));
        this.gridPane.getChildren().add((Object)this.tradeInstantCheckBox);
        this.addressInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.crypto.address"));
        this.addressInputTextField.setValidator((InputValidator)this.altCoinAddressValidator);
        this.addressInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            if (newValue.startsWith("monero:")) {
                UserThread.execute(() -> {
                    String addressWithoutPrefix = newValue.replace("monero:", "");
                    this.addressInputTextField.setText(addressWithoutPrefix);
                });
                return;
            }
            this.assetAccount.setAddress(newValue);
            this.updateFromInputs();
        });
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    @Override
    public PaymentAccount getPaymentAccount() {
        if (this.tradeInstant) {
            InstantCryptoCurrencyAccount instantCryptoCurrencyAccount = new InstantCryptoCurrencyAccount();
            instantCryptoCurrencyAccount.init();
            instantCryptoCurrencyAccount.setAccountName(this.paymentAccount.getAccountName());
            instantCryptoCurrencyAccount.setSaltAsHex(this.paymentAccount.getSaltAsHex());
            instantCryptoCurrencyAccount.setSalt(this.paymentAccount.getSalt());
            instantCryptoCurrencyAccount.setSingleTradeCurrency(this.paymentAccount.getSingleTradeCurrency());
            instantCryptoCurrencyAccount.setSelectedTradeCurrency(this.paymentAccount.getSelectedTradeCurrency());
            instantCryptoCurrencyAccount.setAddress(this.assetAccount.getAddress());
            return instantCryptoCurrencyAccount;
        }
        return this.paymentAccount;
    }

    @Override
    public void updateFromInputs() {
        if (this.addressInputTextField != null && this.assetAccount.getSingleTradeCurrency() != null) {
            this.addressInputTextField.setPromptText(Res.get((String)"payment.crypto.address.dyn", (Object[])new Object[]{this.assetAccount.getSingleTradeCurrency().getName()}));
        }
        super.updateFromInputs();
    }

    @Override
    protected void autoFillNameTextField() {
        if (this.useCustomAccountNameToggleButton != null && !this.useCustomAccountNameToggleButton.isSelected()) {
            this.accountNameTextField.setText(DisplayUtils.createAssetsAccountName(this.paymentAccount, this.assetAccount.getAddress()));
        }
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.assetAccount.getPaymentMethod().getId()));
        Tuple3<Label, TextField, VBox> tuple2 = FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.crypto.address"), this.assetAccount.getAddress());
        TextField field = (TextField)tuple2.second;
        field.setMouseTransparent(false);
        TradeCurrency singleTradeCurrency = this.assetAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "";
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.crypto"), nameAndCode);
        this.addLimitations(true);
    }

    @Override
    public void updateAllInputsValid() {
        TradeCurrency selectedTradeCurrency = this.assetAccount.getSelectedTradeCurrency();
        if (selectedTradeCurrency != null) {
            this.altCoinAddressValidator.setCurrencyCode(selectedTradeCurrency.getCode());
            this.allInputsValid.set(this.isAccountNameValid() && this.altCoinAddressValidator.validate((String)this.assetAccount.getAddress()).isValid && this.assetAccount.getSingleTradeCurrency() != null);
        }
    }

    @Override
    protected void addTradeCurrencyComboBox() {
        this.currencyComboBox = (ComboBox)FormBuilder.addLabelAutocompleteComboBox((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.crypto"), (double)40.0).second;
        this.currencyComboBox.setPromptText(Res.get((String)"payment.select.crypto"));
        this.currencyComboBox.setButtonCell(GUIUtil.getComboBoxButtonCell(Res.get((String)"payment.select.crypto"), this.currencyComboBox));
        this.currencyComboBox.getEditor().focusedProperty().addListener(observable -> this.currencyComboBox.setPromptText(""));
        ((AutocompleteComboBox)this.currencyComboBox).setAutocompleteItems(CurrencyUtil.getActiveSortedCryptoCurrencies((FilterManager)this.filterManager));
        this.currencyComboBox.setVisibleRowCount(Math.min(this.currencyComboBox.getItems().size(), 10));
        this.currencyComboBox.setCellFactory(GUIUtil.getTradeCurrencyCellFactoryNameAndCode());
        this.currencyComboBox.setConverter((StringConverter)new StringConverter<TradeCurrency>(){

            public String toString(TradeCurrency tradeCurrency) {
                return tradeCurrency != null ? tradeCurrency.getNameAndCode() : "";
            }

            public TradeCurrency fromString(String s) {
                return AssetsForm.this.currencyComboBox.getItems().stream().filter(item -> item.getNameAndCode().equals(s)).findAny().orElse(null);
            }
        });
        ((AutocompleteComboBox)this.currencyComboBox).setOnChangeConfirmed((EventHandler<Event>)((EventHandler)e -> {
            this.addressInputTextField.resetValidation();
            this.addressInputTextField.validate();
            TradeCurrency tradeCurrency = (TradeCurrency)this.currencyComboBox.getSelectionModel().getSelectedItem();
            this.paymentAccount.setSingleTradeCurrency(tradeCurrency);
            this.updateFromInputs();
            if (tradeCurrency != null && tradeCurrency.getCode().equals("BSQ")) {
                ((Popup)new Popup().information(Res.get((String)"payment.select.crypto.bsq.warning"))).show();
            }
        }));
    }
}

