/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Country;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.AmazonGiftCardAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.AmazonGiftCardAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import java.util.Collection;
import java.util.HashMap;
import javafx.collections.FXCollections;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonGiftCardForm
extends PaymentMethodForm {
    private static final Logger log = LoggerFactory.getLogger(AmazonGiftCardForm.class);
    ComboBox<Country> countryCombo;
    private final AmazonGiftCardAccount amazonGiftCardAccount;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        AmazonGiftCardAccountPayload amazonGiftCardAccountPayload = (AmazonGiftCardAccountPayload)paymentAccountPayload;
        FormBuilder.addTopLabelTextFieldWithCopyIcon(gridPane, gridRow, 1, Res.get((String)"payment.amazon.site"), AmazonGiftCardForm.countryToAmazonSite(amazonGiftCardAccountPayload.getCountryCode()), 50.0);
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, Res.get((String)"payment.email.mobile"), amazonGiftCardAccountPayload.getEmailOrMobileNr());
        String countryText = CountryUtil.getNameAndCode((String)amazonGiftCardAccountPayload.getCountryCode());
        if (countryText.isEmpty()) {
            countryText = Res.get((String)"payment.ask");
        }
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, gridRow, 1, Res.get((String)"shared.country"), countryText);
        return gridRow;
    }

    public AmazonGiftCardForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.amazonGiftCardAccount = (AmazonGiftCardAccount)paymentAccount;
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow + 1;
        InputTextField accountNrInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.email.mobile"));
        accountNrInputTextField.setValidator(this.inputValidator);
        accountNrInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.amazonGiftCardAccount.setEmailOrMobileNr(newValue);
            this.updateFromInputs();
        });
        this.countryCombo = FormBuilder.addComboBox(this.gridPane, ++this.gridRow, Res.get((String)"shared.country"));
        this.countryCombo.setPromptText(Res.get((String)"payment.select.country"));
        this.countryCombo.setItems(FXCollections.observableArrayList((Collection)CountryUtil.getAllAmazonGiftCardCountries()));
        TextField ccyField = (TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"shared.currency"), (String)"").second;
        this.countryCombo.setConverter((StringConverter)new StringConverter<Country>(this){

            public String toString(Country country) {
                return country.name + " (" + country.code + ")";
            }

            public Country fromString(String s) {
                return null;
            }
        });
        this.countryCombo.setOnAction(e -> {
            Country countryCode = (Country)this.countryCombo.getValue();
            this.amazonGiftCardAccount.setCountry(countryCode);
            TraditionalCurrency currency = CurrencyUtil.getCurrencyByCountryCode((String)countryCode.code);
            this.paymentAccount.setSingleTradeCurrency((TradeCurrency)currency);
            ccyField.setText(currency.getNameAndCode());
            this.updateFromInputs();
        });
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.amazonGiftCardAccount.getEmailOrMobileNr() == null ? "" : this.amazonGiftCardAccount.getEmailOrMobileNr());
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.paymentAccount.getPaymentMethod().getId()));
        TextField field = (TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.email.mobile"), (String)this.amazonGiftCardAccount.getEmailOrMobileNr()).second;
        field.setMouseTransparent(false);
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.country"), this.amazonGiftCardAccount.getCountry() != null ? this.amazonGiftCardAccount.getCountry().name : "");
        String nameAndCode = this.paymentAccount.getSingleTradeCurrency() != null ? this.paymentAccount.getSingleTradeCurrency().getNameAndCode() : "";
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        this.addLimitations(true);
    }

    @Override
    public void updateAllInputsValid() {
        this.allInputsValid.set(this.isAccountNameValid() && this.inputValidator.validate((String)this.amazonGiftCardAccount.getEmailOrMobileNr()).isValid && this.paymentAccount.getTradeCurrencies().size() > 0);
    }

    private static String countryToAmazonSite(String countryCode) {
        HashMap<String, String> mapCountryToSite = new HashMap<String, String>(){
            {
                this.put("AU", "https://www.amazon.au");
                this.put("CA", "https://www.amazon.ca");
                this.put("FR", "https://www.amazon.fr");
                this.put("DE", "https://www.amazon.de");
                this.put("IT", "https://www.amazon.it");
                this.put("NL", "https://www.amazon.nl");
                this.put("ES", "https://www.amazon.es");
                this.put("UK", "https://www.amazon.co.uk");
                this.put("IN", "https://www.amazon.in");
                this.put("JP", "https://www.amazon.co.jp");
                this.put("SA", "https://www.amazon.sa");
                this.put("SE", "https://www.amazon.se");
                this.put("SG", "https://www.amazon.sg");
                this.put("TR", "https://www.amazon.tr");
                this.put("US", "https://www.amazon.com");
                this.put("", Res.get((String)"payment.ask"));
            }
        };
        return (String)mapCountryToSite.get(countryCode);
    }
}

