/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.BankUtil;
import haveno.core.locale.Country;
import haveno.core.locale.Res;
import haveno.core.payment.AchTransferAccount;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.AchTransferAccountPayload;
import haveno.core.payment.payload.BankAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.paymentmethods.GeneralUsBankForm;
import haveno.desktop.util.FormBuilder;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.GridPane;

public class AchTransferForm
extends GeneralUsBankForm {
    private final AchTransferAccount achTransferAccount;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        AchTransferAccountPayload achTransferAccountPayload = (AchTransferAccountPayload)paymentAccountPayload;
        return AchTransferForm.addFormForBuyer(gridPane, gridRow, paymentAccountPayload, achTransferAccountPayload.getAccountType(), achTransferAccountPayload.getHolderAddress());
    }

    public AchTransferForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.achTransferAccount = (AchTransferAccount)paymentAccount;
    }

    @Override
    public void addFormForEditAccount() {
        this.addFormForEditAccount((BankAccountPayload)this.achTransferAccount.getPayload(), this.achTransferAccount.getPayload().getHolderAddress());
    }

    @Override
    public void addFormForAddAccount() {
        this.addFormForAddAccountInternal((BankAccountPayload)this.achTransferAccount.getPayload(), this.achTransferAccount.getPayload().getHolderAddress());
    }

    @Override
    protected void setHolderAddress(String holderAddress) {
        this.achTransferAccount.getPayload().setHolderAddress(holderAddress);
    }

    @Override
    protected void maybeAddAccountTypeCombo(BankAccountPayload bankAccountPayload, Country country) {
        ComboBox accountTypeComboBox = FormBuilder.addComboBox(this.gridPane, ++this.gridRow, Res.get((String)"payment.select.account"));
        accountTypeComboBox.setItems(FXCollections.observableArrayList((Collection)BankUtil.getAccountTypeValues((String)country.code)));
        accountTypeComboBox.setOnAction(e -> {
            if (BankUtil.isAccountTypeRequired((String)country.code)) {
                bankAccountPayload.setAccountType((String)accountTypeComboBox.getSelectionModel().getSelectedItem());
                this.updateFromInputs();
            }
        });
    }

    @Override
    public void updateAllInputsValid() {
        AchTransferAccountPayload achTransferAccountPayload = this.achTransferAccount.getPayload();
        boolean result = this.isAccountNameValid() && this.paymentAccount.getSingleTradeCurrency() != null && ((CountryBasedPaymentAccount)this.paymentAccount).getCountry() != null && this.inputValidator.validate((String)achTransferAccountPayload.getHolderName()).isValid && this.inputValidator.validate((String)achTransferAccountPayload.getHolderAddress()).isValid;
        result = this.getValidationResult(result, achTransferAccountPayload.getCountryCode(), achTransferAccountPayload.getBankName(), achTransferAccountPayload.getBankId(), achTransferAccountPayload.getBranchId(), achTransferAccountPayload.getAccountNr(), achTransferAccountPayload.getAccountType(), achTransferAccountPayload.getHolderTaxId(), achTransferAccountPayload.getNationalAccountId());
        this.allInputsValid.set(result);
    }
}

