/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.list;

import haveno.common.UserThread;
import haveno.desktop.components.InputTextField;
import haveno.desktop.util.filtering.FilterableListItem;
import javafx.beans.value.ChangeListener;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Node;
import javafx.scene.control.TableView;
import javafx.scene.layout.HBox;

public class FilterBox
extends HBox {
    private final InputTextField textField;
    private FilteredList<? extends FilterableListItem> filteredList;
    private ChangeListener<String> listener;

    public FilterBox() {
        this.setSpacing(5.0);
        this.textField = new InputTextField();
        this.textField.setMinWidth(500.0);
        this.getChildren().addAll((Object[])new Node[]{this.textField});
    }

    public void initialize(FilteredList<? extends FilterableListItem> filteredList, TableView<? extends FilterableListItem> tableView) {
        this.filteredList = filteredList;
        this.listener = (observable, oldValue, newValue) -> UserThread.execute(() -> {
            tableView.getSelectionModel().clearSelection();
            this.applyFilteredListPredicate(this.textField.getText());
        });
    }

    public void activate() {
        this.textField.textProperty().addListener(this.listener);
        this.applyFilteredListPredicate(this.textField.getText());
    }

    public void deactivate() {
        this.textField.textProperty().removeListener(this.listener);
    }

    private void applyFilteredListPredicate(String filterString) {
        this.filteredList.setPredicate(item -> item.match(filterString));
    }

    public void setPromptText(String promptText) {
        this.textField.setPromptText(promptText);
    }
}

