/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.indicator.skin;

import haveno.desktop.components.indicator.TxConfidenceIndicator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableIntegerProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.PaintConverter;
import javafx.css.converter.SizeConverter;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;

public class StaticProgressIndicatorSkin
extends SkinBase<TxConfidenceIndicator> {
    private IndeterminateSpinner spinner;
    private final IntegerProperty indeterminateSegmentCount = new StyleableIntegerProperty(8){

        protected void invalidated() {
            if (StaticProgressIndicatorSkin.this.spinner != null) {
                StaticProgressIndicatorSkin.this.spinner.rebuild();
            }
        }

        public Object getBean() {
            return StaticProgressIndicatorSkin.this;
        }

        public String getName() {
            return "indeterminateSegmentCount";
        }

        public CssMetaData<TxConfidenceIndicator, Number> getCssMetaData() {
            return StyleableProperties.INDETERMINATE_SEGMENT_COUNT;
        }
    };
    private final BooleanProperty spinEnabled = new StyleableBooleanProperty(false){

        protected void invalidated() {
            if (StaticProgressIndicatorSkin.this.spinner != null) {
                StaticProgressIndicatorSkin.this.spinner.setSpinEnabled(this.get());
            }
        }

        public CssMetaData<TxConfidenceIndicator, Boolean> getCssMetaData() {
            return StyleableProperties.SPIN_ENABLED;
        }

        public Object getBean() {
            return StaticProgressIndicatorSkin.this;
        }

        public String getName() {
            return "spinEnabled";
        }
    };
    private DeterminateIndicator determinateIndicator;
    private final ObjectProperty<Paint> progressColor = new StyleableObjectProperty<Paint>(null){

        public void set(Paint newProgressColor) {
            Paint color = newProgressColor instanceof Color ? newProgressColor : null;
            super.set((Object)color);
        }

        protected void invalidated() {
            if (StaticProgressIndicatorSkin.this.spinner != null) {
                StaticProgressIndicatorSkin.this.spinner.setFillOverride((Paint)this.get());
            }
            if (StaticProgressIndicatorSkin.this.determinateIndicator != null) {
                StaticProgressIndicatorSkin.this.determinateIndicator.setFillOverride((Paint)this.get());
            }
        }

        public Object getBean() {
            return StaticProgressIndicatorSkin.this;
        }

        public String getName() {
            return "progressColorProperty";
        }

        public CssMetaData<TxConfidenceIndicator, Paint> getCssMetaData() {
            return StyleableProperties.PROGRESS_COLOR;
        }
    };
    private boolean timeLineNulled = false;

    public StaticProgressIndicatorSkin(TxConfidenceIndicator control) {
        super((Control)control);
        InvalidationListener indeterminateListener = valueModel -> this.initialize();
        control.indeterminateProperty().addListener(indeterminateListener);
        InvalidationListener visibilityListener = valueModel -> {
            if (((TxConfidenceIndicator)this.getSkinnable()).isIndeterminate() && this.timeLineNulled && this.spinner == null) {
                this.timeLineNulled = false;
                this.spinner = new IndeterminateSpinner((TxConfidenceIndicator)this.getSkinnable(), this, this.spinEnabled.get(), (Paint)this.progressColor.get());
                this.getChildren().add((Object)this.spinner);
            }
            if (this.spinner != null && ((TxConfidenceIndicator)this.getSkinnable()).getScene() != null) {
                this.getChildren().remove((Object)this.spinner);
                this.spinner = null;
                this.timeLineNulled = true;
            }
        };
        control.visibleProperty().addListener(visibilityListener);
        control.parentProperty().addListener(visibilityListener);
        InvalidationListener sceneListener = valueModel -> {
            if (this.spinner != null) {
                if (((TxConfidenceIndicator)this.getSkinnable()).getScene() == null) {
                    this.getChildren().remove((Object)this.spinner);
                    this.spinner = null;
                    this.timeLineNulled = true;
                }
            } else if (((TxConfidenceIndicator)this.getSkinnable()).getScene() != null && ((TxConfidenceIndicator)this.getSkinnable()).isIndeterminate()) {
                this.timeLineNulled = false;
                this.spinner = new IndeterminateSpinner((TxConfidenceIndicator)this.getSkinnable(), this, this.spinEnabled.get(), (Paint)this.progressColor.get());
                this.getChildren().add((Object)this.spinner);
                ((TxConfidenceIndicator)this.getSkinnable()).requestLayout();
            }
        };
        control.sceneProperty().addListener(sceneListener);
        this.initialize();
        ((TxConfidenceIndicator)this.getSkinnable()).requestLayout();
    }

    public static ObservableList<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private void initialize() {
        TxConfidenceIndicator control = (TxConfidenceIndicator)this.getSkinnable();
        boolean isIndeterminate = control.isIndeterminate();
        if (isIndeterminate) {
            this.determinateIndicator = null;
            this.spinner = new IndeterminateSpinner(control, this, this.spinEnabled.get(), (Paint)this.progressColor.get());
            this.getChildren().clear();
            this.getChildren().add((Object)this.spinner);
        } else {
            if (this.spinner != null) {
                this.spinner = null;
            }
            this.determinateIndicator = new DeterminateIndicator(control, this, (Paint)this.progressColor.get());
            this.getChildren().clear();
            this.getChildren().add((Object)this.determinateIndicator);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.spinner != null) {
            this.spinner = null;
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        if (this.spinner != null && ((TxConfidenceIndicator)this.getSkinnable()).isIndeterminate()) {
            this.spinner.layoutChildren();
            this.spinner.resizeRelocate(0.0, 0.0, w, h);
        } else if (this.determinateIndicator != null) {
            this.determinateIndicator.layoutChildren();
            this.determinateIndicator.resizeRelocate(0.0, 0.0, w, h);
        }
    }

    public Paint getProgressColor() {
        return (Paint)this.progressColor.get();
    }

    public ObservableList<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return StaticProgressIndicatorSkin.getClassCssMetaData();
    }

    private static class StyleableProperties {
        static final ObservableList<CssMetaData<? extends Styleable, ?>> STYLEABLES;
        private static final CssMetaData<TxConfidenceIndicator, Paint> PROGRESS_COLOR;
        private static final CssMetaData<TxConfidenceIndicator, Number> INDETERMINATE_SEGMENT_COUNT;
        private static final CssMetaData<TxConfidenceIndicator, Boolean> SPIN_ENABLED;

        private StyleableProperties() {
        }

        static {
            PROGRESS_COLOR = new CssMetaData<TxConfidenceIndicator, Paint>("-fx-progress-color", PaintConverter.getInstance(), null){

                public boolean isSettable(TxConfidenceIndicator n) {
                    StaticProgressIndicatorSkin skin = (StaticProgressIndicatorSkin)n.getSkin();
                    return skin.progressColor == null || !skin.progressColor.isBound();
                }

                public StyleableProperty<Paint> getStyleableProperty(TxConfidenceIndicator n) {
                    StaticProgressIndicatorSkin skin = (StaticProgressIndicatorSkin)n.getSkin();
                    return (StyleableProperty)skin.progressColor;
                }
            };
            INDETERMINATE_SEGMENT_COUNT = new CssMetaData<TxConfidenceIndicator, Number>("-fx-indeterminate-segment-count", SizeConverter.getInstance(), (Number)8){

                public void set(TxConfidenceIndicator node, Number value, StyleOrigin origin) {
                    super.set((Styleable)node, (Object)value.intValue(), origin);
                }

                public boolean isSettable(TxConfidenceIndicator n) {
                    StaticProgressIndicatorSkin skin = (StaticProgressIndicatorSkin)n.getSkin();
                    return skin.indeterminateSegmentCount == null || !skin.indeterminateSegmentCount.isBound();
                }

                public StyleableProperty<Number> getStyleableProperty(TxConfidenceIndicator n) {
                    StaticProgressIndicatorSkin skin = (StaticProgressIndicatorSkin)n.getSkin();
                    return (StyleableProperty)skin.indeterminateSegmentCount;
                }
            };
            SPIN_ENABLED = new CssMetaData<TxConfidenceIndicator, Boolean>("-fx-spin-enabled", BooleanConverter.getInstance(), Boolean.FALSE){

                public boolean isSettable(TxConfidenceIndicator node) {
                    StaticProgressIndicatorSkin skin = (StaticProgressIndicatorSkin)node.getSkin();
                    return skin.spinEnabled == null || !skin.spinEnabled.isBound();
                }

                public StyleableProperty<Boolean> getStyleableProperty(TxConfidenceIndicator node) {
                    StaticProgressIndicatorSkin skin = (StaticProgressIndicatorSkin)node.getSkin();
                    return (StyleableProperty)skin.spinEnabled;
                }
            };
            ObservableList styleables = FXCollections.observableArrayList((Collection)SkinBase.getClassCssMetaData());
            styleables.add(PROGRESS_COLOR);
            styleables.add(INDETERMINATE_SEGMENT_COUNT);
            styleables.add(SPIN_ENABLED);
            STYLEABLES = FXCollections.unmodifiableObservableList((ObservableList)styleables);
        }
    }

    static class DeterminateIndicator
    extends Region {
        private final TxConfidenceIndicator control;
        private final StackPane indicator;
        private final StackPane progress;
        private final StackPane tick;
        private final Arc arcShape;
        private final Circle indicatorCircle;
        private int intProgress;
        private int degProgress;

        DeterminateIndicator(TxConfidenceIndicator control, StaticProgressIndicatorSkin s, Paint fillOverride) {
            this.control = control;
            this.getStyleClass().add((Object)"determinate-indicator");
            this.intProgress = (int)Math.round(control.getProgress() * 100.0);
            this.degProgress = (int)(360.0 * control.getProgress());
            InvalidationListener progressListener = valueModel -> this.updateProgress();
            control.progressProperty().addListener(progressListener);
            this.getChildren().clear();
            this.indicator = new StackPane();
            this.indicator.setScaleShape(false);
            this.indicator.setCenterShape(false);
            this.indicator.getStyleClass().setAll((Object[])new String[]{"indicator"});
            this.indicatorCircle = new Circle();
            this.indicator.setShape((Shape)this.indicatorCircle);
            this.arcShape = new Arc();
            this.arcShape.setType(ArcType.ROUND);
            this.arcShape.setStartAngle(90.0);
            this.progress = new StackPane();
            this.progress.getStyleClass().setAll((Object[])new String[]{"progress"});
            this.progress.setScaleShape(false);
            this.progress.setCenterShape(false);
            this.progress.setShape((Shape)this.arcShape);
            this.progress.getChildren().clear();
            this.setFillOverride(fillOverride);
            this.tick = new StackPane();
            this.tick.getStyleClass().setAll((Object[])new String[]{"tick"});
            this.getChildren().setAll((Object[])new Node[]{this.indicator, this.progress, this.tick});
            this.updateProgress();
        }

        private void setFillOverride(Paint fillOverride) {
            if (fillOverride instanceof Color) {
                Color c = (Color)fillOverride;
                this.progress.setStyle("-fx-background-color: rgba(" + (int)(255.0 * c.getRed()) + "," + (int)(255.0 * c.getGreen()) + "," + (int)(255.0 * c.getBlue()) + "," + c.getOpacity() + ");");
            } else {
                this.progress.setStyle(null);
            }
        }

        public boolean isAutomaticallyMirrored() {
            return false;
        }

        private void updateProgress() {
            this.intProgress = (int)Math.round(this.control.getProgress() * 100.0);
            this.degProgress = (int)(360.0 * this.control.getProgress());
            this.arcShape.setLength((double)(-this.degProgress));
            this.indicator.setOpacity(this.control.getProgress() == 0.0 ? 0.0 : 1.0);
            this.requestLayout();
        }

        protected void layoutChildren() {
            Insets controlInsets = this.control.getInsets();
            double left = this.snapSizeX(controlInsets.getLeft());
            double right = this.snapSizeX(controlInsets.getRight());
            double top = this.snapSizeY(controlInsets.getTop());
            double bottom = this.snapSizeY(controlInsets.getBottom());
            double areaW = this.control.getWidth() - left - right;
            double areaH = this.control.getHeight() - top - bottom;
            double radiusW = areaW / 2.0;
            double radiusH = areaH / 2.0;
            double radius = Math.round(Math.min(radiusW, radiusH));
            double centerX = this.snapPositionX(left + radiusW);
            double centerY = this.snapPositionY(top + radius);
            Insets indicatorInsets = this.indicator.getInsets();
            double iLeft = this.snapSizeX(indicatorInsets.getLeft());
            double iRight = this.snapSizeX(indicatorInsets.getRight());
            double iTop = this.snapSizeY(indicatorInsets.getTop());
            double iBottom = this.snapSizeY(indicatorInsets.getBottom());
            double progressRadius = this.snapSizeX(Math.min(Math.min(radius - iLeft, radius - iRight), Math.min(radius - iTop, radius - iBottom)));
            this.indicatorCircle.setRadius(radius);
            this.indicator.setLayoutX(centerX);
            this.indicator.setLayoutY(centerY);
            this.arcShape.setRadiusX(progressRadius);
            this.arcShape.setRadiusY(progressRadius);
            this.progress.setLayoutX(centerX);
            this.progress.setLayoutY(centerY);
            Insets progressInsets = this.progress.getInsets();
            double pLeft = this.snapSizeX(progressInsets.getLeft());
            double pRight = this.snapSizeX(progressInsets.getRight());
            double pTop = this.snapSizeY(progressInsets.getTop());
            double pBottom = this.snapSizeY(progressInsets.getBottom());
            double indicatorRadius = this.snapSizeX(Math.min(Math.min(progressRadius - pLeft, progressRadius - pRight), Math.min(progressRadius - pTop, progressRadius - pBottom)));
            double squareBoxHalfWidth = Math.ceil(Math.sqrt(indicatorRadius * indicatorRadius / 2.0));
            this.tick.setLayoutX(centerX - squareBoxHalfWidth);
            this.tick.setLayoutY(centerY - squareBoxHalfWidth);
            this.tick.resize(squareBoxHalfWidth + squareBoxHalfWidth, squareBoxHalfWidth + squareBoxHalfWidth);
            this.tick.setVisible(this.control.getProgress() >= 1.0);
        }

        protected double computePrefWidth(double height) {
            Insets controlInsets = this.control.getInsets();
            double left = this.snapSizeX(controlInsets.getLeft());
            double right = this.snapSizeX(controlInsets.getRight());
            Insets indicatorInsets = this.indicator.getInsets();
            double iLeft = this.snapSizeX(indicatorInsets.getLeft());
            double iRight = this.snapSizeX(indicatorInsets.getRight());
            double iTop = this.snapSizeY(indicatorInsets.getTop());
            double iBottom = this.snapSizeY(indicatorInsets.getBottom());
            double indicatorMax = this.snapSizeX(Math.max(Math.max(iLeft, iRight), Math.max(iTop, iBottom)));
            Insets progressInsets = this.progress.getInsets();
            double pLeft = this.snapSizeX(progressInsets.getLeft());
            double pRight = this.snapSizeX(progressInsets.getRight());
            double pTop = this.snapSizeY(progressInsets.getTop());
            double pBottom = this.snapSizeY(progressInsets.getBottom());
            double progressMax = this.snapSizeX(Math.max(Math.max(pLeft, pRight), Math.max(pTop, pBottom)));
            Insets tickInsets = this.tick.getInsets();
            double tLeft = this.snapSizeX(tickInsets.getLeft());
            double tRight = this.snapSizeX(tickInsets.getRight());
            double indicatorWidth = indicatorMax + progressMax + tLeft + tRight + progressMax + indicatorMax;
            return left + indicatorWidth + right;
        }

        protected double computePrefHeight(double width) {
            Insets controlInsets = this.control.getInsets();
            double top = this.snapSizeY(controlInsets.getTop());
            double bottom = this.snapSizeY(controlInsets.getBottom());
            Insets indicatorInsets = this.indicator.getInsets();
            double iLeft = this.snapSizeX(indicatorInsets.getLeft());
            double iRight = this.snapSizeX(indicatorInsets.getRight());
            double iTop = this.snapSizeY(indicatorInsets.getTop());
            double iBottom = this.snapSizeY(indicatorInsets.getBottom());
            double indicatorMax = this.snapSizeX(Math.max(Math.max(iLeft, iRight), Math.max(iTop, iBottom)));
            Insets progressInsets = this.progress.getInsets();
            double pLeft = this.snapSizeX(progressInsets.getLeft());
            double pRight = this.snapSizeX(progressInsets.getRight());
            double pTop = this.snapSizeY(progressInsets.getTop());
            double pBottom = this.snapSizeY(progressInsets.getBottom());
            double progressMax = this.snapSizeX(Math.max(Math.max(pLeft, pRight), Math.max(pTop, pBottom)));
            Insets tickInsets = this.tick.getInsets();
            double tTop = this.snapSizeY(tickInsets.getTop());
            double tBottom = this.snapSizeY(tickInsets.getBottom());
            double indicatorHeight = indicatorMax + progressMax + tTop + tBottom + progressMax + indicatorMax;
            return top + indicatorHeight + bottom;
        }

        protected double computeMaxWidth(double height) {
            return this.computePrefWidth(height);
        }

        protected double computeMaxHeight(double width) {
            return this.computePrefHeight(width);
        }
    }

    static class IndeterminateSpinner
    extends Region {
        private final TxConfidenceIndicator control;
        private final StaticProgressIndicatorSkin skin;
        private final IndicatorPaths pathsG;
        private final List<Double> opacities = new ArrayList<Double>();
        private Paint fillOverride = null;

        IndeterminateSpinner(TxConfidenceIndicator control, StaticProgressIndicatorSkin s, boolean spinEnabled, Paint fillOverride) {
            this.control = control;
            this.skin = s;
            this.fillOverride = fillOverride;
            this.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
            this.getStyleClass().setAll((Object[])new String[]{"spinner"});
            this.pathsG = new IndicatorPaths(this, this);
            this.getChildren().add((Object)this.pathsG);
            this.rebuild();
        }

        void setFillOverride(Paint fillOverride) {
            this.fillOverride = fillOverride;
            this.rebuild();
        }

        void setSpinEnabled(boolean spinEnabled) {
        }

        protected void layoutChildren() {
            double scaleX;
            Insets controlInsets = this.control.getInsets();
            double w = this.control.getWidth() - controlInsets.getLeft() - controlInsets.getRight();
            double h = this.control.getHeight() - controlInsets.getTop() - controlInsets.getBottom();
            double prefW = this.pathsG.prefWidth(-1.0);
            double prefH = this.pathsG.prefHeight(-1.0);
            double scale = scaleX = w / prefW;
            if (scaleX * prefH > h) {
                scale = h / prefH;
            }
            double indicatorW = prefW * scale - 3.0;
            double indicatorH = prefH * scale - 3.0;
            this.pathsG.resizeRelocate((w - indicatorW) / 2.0, (h - indicatorH) / 2.0, indicatorW, indicatorH);
        }

        private void rebuild() {
            int segments = this.skin.indeterminateSegmentCount.get();
            this.opacities.clear();
            this.pathsG.getChildren().clear();
            double step = 0.8 / (double)(segments - 1);
            for (int i = 0; i < segments; ++i) {
                Region region = new Region();
                region.setScaleShape(false);
                region.setCenterShape(false);
                region.getStyleClass().addAll((Object[])new String[]{"segment", "segment" + i});
                if (this.fillOverride instanceof Color) {
                    Color c = (Color)this.fillOverride;
                    region.setStyle("-fx-background-color: rgba(" + (int)(255.0 * c.getRed()) + "," + (int)(255.0 * c.getGreen()) + "," + (int)(255.0 * c.getBlue()) + "," + c.getOpacity() + ");");
                } else {
                    region.setStyle(null);
                }
                double opacity = Math.min(1.0, (double)i * step);
                this.opacities.add(opacity);
                region.setOpacity(opacity);
                this.pathsG.getChildren().add((Object)region);
            }
        }

        private class IndicatorPaths
        extends Pane {
            final IndeterminateSpinner piSkin;

            IndicatorPaths(IndeterminateSpinner indeterminateSpinner, IndeterminateSpinner pi) {
                this.piSkin = pi;
            }

            protected double computePrefWidth(double height) {
                double w = 0.0;
                for (Node child : this.getChildren()) {
                    if (!(child instanceof Region)) continue;
                    Region region = (Region)child;
                    if (region.getShape() != null) {
                        w = Math.max(w, region.getShape().getLayoutBounds().getMaxX());
                        continue;
                    }
                    w = Math.max(w, region.prefWidth(height));
                }
                return w;
            }

            protected double computePrefHeight(double width) {
                double h = 0.0;
                for (Node child : this.getChildren()) {
                    if (!(child instanceof Region)) continue;
                    Region region = (Region)child;
                    if (region.getShape() != null) {
                        h = Math.max(h, region.getShape().getLayoutBounds().getMaxY());
                        continue;
                    }
                    h = Math.max(h, region.prefHeight(width));
                }
                return h;
            }

            protected void layoutChildren() {
                double scale = this.getWidth() / this.computePrefWidth(-1.0);
                this.getChildren().stream().filter(child -> child instanceof Region).forEach(child -> {
                    Region region = (Region)child;
                    if (region.getShape() != null) {
                        region.resize(region.getShape().getLayoutBounds().getMaxX(), region.getShape().getLayoutBounds().getMaxY());
                        region.getTransforms().setAll((Object[])new Transform[]{new Scale(scale, scale, 0.0, 0.0)});
                    } else {
                        region.autosize();
                    }
                });
            }
        }
    }
}

