/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.indicator;

import haveno.common.UserThread;
import haveno.desktop.components.indicator.skin.StaticProgressIndicatorSkin;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.css.PseudoClass;
import javafx.css.StyleableProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class TxConfidenceIndicator
extends Control {
    public static final double INDETERMINATE_PROGRESS = -1.0;
    private static final String DEFAULT_STYLE_CLASS = "progress-indicator";
    private static final PseudoClass PSEUDO_CLASS_DETERMINATE = PseudoClass.getPseudoClass((String)"determinate");
    private static final PseudoClass PSEUDO_CLASS_INDETERMINATE = PseudoClass.getPseudoClass((String)"indeterminate");
    private ReadOnlyBooleanWrapper indeterminate;
    private DoubleProperty progress;

    public TxConfidenceIndicator() {
        this(-1.0);
    }

    public TxConfidenceIndicator(double progress) {
        ((StyleableProperty)this.focusTraversableProperty()).applyStyle(null, (Object)Boolean.FALSE);
        this.setProgress(progress);
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        int c = Double.compare(-1.0, progress);
        this.pseudoClassStateChanged(PSEUDO_CLASS_INDETERMINATE, c == 0);
        this.pseudoClassStateChanged(PSEUDO_CLASS_DETERMINATE, c != 0);
    }

    public final boolean isIndeterminate() {
        return this.indeterminate == null || this.indeterminate.get();
    }

    private void setIndeterminate(boolean value) {
        this.indeterminatePropertyImpl().set(value);
    }

    public final ReadOnlyBooleanProperty indeterminateProperty() {
        return this.indeterminatePropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper indeterminatePropertyImpl() {
        if (this.indeterminate == null) {
            this.indeterminate = new ReadOnlyBooleanWrapper(true){

                protected void invalidated() {
                    boolean active = this.get();
                    TxConfidenceIndicator.this.pseudoClassStateChanged(PSEUDO_CLASS_INDETERMINATE, active);
                    TxConfidenceIndicator.this.pseudoClassStateChanged(PSEUDO_CLASS_DETERMINATE, !active);
                }

                public Object getBean() {
                    return TxConfidenceIndicator.this;
                }

                public String getName() {
                    return "indeterminate";
                }
            };
        }
        return this.indeterminate;
    }

    public final double getProgress() {
        return this.progress == null ? -1.0 : this.progress.get();
    }

    public final void setProgress(double value) {
        UserThread.execute(() -> this.progressProperty().set(value));
    }

    public final DoubleProperty progressProperty() {
        if (this.progress == null) {
            this.progress = new DoublePropertyBase(-1.0){

                protected void invalidated() {
                    TxConfidenceIndicator.this.setIndeterminate(TxConfidenceIndicator.this.getProgress() < 0.0);
                }

                public Object getBean() {
                    return TxConfidenceIndicator.this;
                }

                public String getName() {
                    return "progress";
                }
            };
        }
        return this.progress;
    }

    protected Skin<?> createDefaultSkin() {
        return new StaticProgressIndicatorSkin(this);
    }

    @Deprecated
    protected Boolean impl_cssGetFocusTraversableInitialValue() {
        return Boolean.FALSE;
    }
}

