/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.controlsfx.control;

import haveno.desktop.components.controlsfx.skin.PopOverSkin;
import java.util.Objects;
import javafx.animation.FadeTransition;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.stage.PopupWindow;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopOver
extends PopupControl {
    private static final String DEFAULT_STYLE_CLASS = "popover";
    private static final Duration DEFAULT_FADE_DURATION = Duration.seconds((double)0.2);
    private double targetX;
    private double targetY;
    private final SimpleBooleanProperty animated = new SimpleBooleanProperty(true);
    private final ObjectProperty<Duration> fadeInDuration = new SimpleObjectProperty((Object)DEFAULT_FADE_DURATION);
    private final ObjectProperty<Duration> fadeOutDuration = new SimpleObjectProperty((Object)DEFAULT_FADE_DURATION);
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final StackPane root = new StackPane();
    private final ObjectProperty<Node> contentNode = new SimpleObjectProperty<Node>(this, (Object)this, "contentNode"){

        public void setValue(Node node) {
            if (node == null) {
                throw new IllegalArgumentException("content node can not be null");
            }
        }
    };
    private final InvalidationListener hideListener = observable -> {
        if (!this.isDetached()) {
            this.hide(Duration.ZERO);
        }
    };
    private final WeakInvalidationListener weakHideListener = new WeakInvalidationListener(this.hideListener);
    private final ChangeListener<Number> xListener = (value, oldX, newX) -> {
        if (!this.isDetached()) {
            this.setAnchorX(this.getAnchorX() + (newX.doubleValue() - oldX.doubleValue()));
        }
    };
    private final WeakChangeListener<Number> weakXListener = new WeakChangeListener(this.xListener);
    private final ChangeListener<Number> yListener = (value, oldY, newY) -> {
        if (!this.isDetached()) {
            this.setAnchorY(this.getAnchorY() + (newY.doubleValue() - oldY.doubleValue()));
        }
    };
    private final WeakChangeListener<Number> weakYListener = new WeakChangeListener(this.yListener);
    private Window ownerWindow;
    private final EventHandler<WindowEvent> closePopOverOnOwnerWindowCloseLambda = event -> this.ownerWindowClosing();
    private final WeakEventHandler<WindowEvent> closePopOverOnOwnerWindowClose = new WeakEventHandler(this.closePopOverOnOwnerWindowCloseLambda);
    private final BooleanProperty headerAlwaysVisible = new SimpleBooleanProperty((Object)this, "headerAlwaysVisible");
    private final BooleanProperty closeButtonEnabled = new SimpleBooleanProperty((Object)this, "closeButtonEnabled", true);
    private final BooleanProperty detachable = new SimpleBooleanProperty((Object)this, "detachable", true);
    private final BooleanProperty detached = new SimpleBooleanProperty((Object)this, "detached", false);
    private final DoubleProperty arrowSize = new SimpleDoubleProperty((Object)this, "arrowSize", 12.0);
    private final DoubleProperty arrowIndent = new SimpleDoubleProperty((Object)this, "arrowIndent", 12.0);
    private final DoubleProperty cornerRadius = new SimpleDoubleProperty((Object)this, "cornerRadius", 6.0);
    private final StringProperty title = new SimpleStringProperty((Object)this, "title", "No title set");
    private final ObjectProperty<ArrowLocation> arrowLocation = new SimpleObjectProperty((Object)this, "arrowLocation", (Object)ArrowLocation.LEFT_TOP);

    public PopOver() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.getRoot().getStylesheets().add((Object)Objects.requireNonNull(PopOver.class.getResource("popover.css")).toExternalForm());
        this.setAnchorLocation(PopupWindow.AnchorLocation.WINDOW_TOP_LEFT);
        this.setOnHiding(evt -> this.setDetached(false));
        Label label = new Label("No content set");
        label.setPrefSize(200.0, 200.0);
        label.setPadding(new Insets(4.0));
        this.setContentNode((Node)label);
        InvalidationListener repositionListener = observable -> {
            if (this.isShowing() && !this.isDetached()) {
                this.show(this.getOwnerNode(), this.targetX, this.targetY);
                this.adjustWindowLocation();
            }
        };
        this.arrowSize.addListener(repositionListener);
        this.cornerRadius.addListener(repositionListener);
        this.arrowLocation.addListener(repositionListener);
        this.arrowIndent.addListener(repositionListener);
        this.headerAlwaysVisible.addListener(repositionListener);
        this.detached.addListener(it -> this.setAutoHide(!this.isDetached()));
        this.setAutoHide(true);
    }

    public PopOver(Node content) {
        this();
        this.setContentNode(content);
    }

    protected Skin<?> createDefaultSkin() {
        return new PopOverSkin(this);
    }

    public final StackPane getRoot() {
        return this.root;
    }

    public final ObjectProperty<Node> contentNodeProperty() {
        return this.contentNode;
    }

    public final Node getContentNode() {
        return (Node)this.contentNodeProperty().get();
    }

    public final void setContentNode(Node content) {
        this.contentNodeProperty().set((Object)content);
    }

    public final void show(Node owner) {
        this.show(owner, 4.0);
    }

    public final void show(Node owner, double offset) {
        Objects.requireNonNull(owner);
        Bounds bounds = owner.localToScreen(owner.getBoundsInLocal());
        switch (this.getArrowLocation().ordinal()) {
            case 9: 
            case 10: 
            case 11: {
                this.show(owner, bounds.getMinX() + bounds.getWidth() / 2.0, bounds.getMinY() + offset);
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                this.show(owner, bounds.getMaxX() - offset, bounds.getMinY() + bounds.getHeight() / 2.0);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.show(owner, bounds.getMinX() + offset, bounds.getMinY() + bounds.getHeight() / 2.0);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.show(owner, bounds.getMinX() + bounds.getWidth() / 2.0, bounds.getMinY() + bounds.getHeight() - offset);
                break;
            }
        }
    }

    public final void show(Window owner) {
        super.show(owner);
        this.ownerWindow = owner;
        if (this.isAnimated()) {
            this.showFadeInAnimation(this.getFadeInDuration());
        }
        this.ownerWindow.addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, this.closePopOverOnOwnerWindowClose);
        this.ownerWindow.addEventFilter(WindowEvent.WINDOW_HIDING, this.closePopOverOnOwnerWindowClose);
    }

    public final void show(Window ownerWindow, double anchorX, double anchorY) {
        super.show(ownerWindow, anchorX, anchorY);
        this.ownerWindow = ownerWindow;
        if (this.isAnimated()) {
            this.showFadeInAnimation(this.getFadeInDuration());
        }
        ownerWindow.addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, this.closePopOverOnOwnerWindowClose);
        ownerWindow.addEventFilter(WindowEvent.WINDOW_HIDING, this.closePopOverOnOwnerWindowClose);
    }

    public final void show(Node owner, double x, double y) {
        this.show(owner, x, y, this.getFadeInDuration());
    }

    public final void show(Node owner, double x, double y, Duration fadeInDuration) {
        if (this.ownerWindow != null && this.isShowing()) {
            super.hide();
        }
        this.targetX = x;
        this.targetY = y;
        if (owner == null) {
            throw new IllegalArgumentException("owner can not be null");
        }
        if (fadeInDuration == null) {
            fadeInDuration = DEFAULT_FADE_DURATION;
        }
        if (this.ownerWindow != null) {
            this.ownerWindow.xProperty().removeListener(this.weakXListener);
            this.ownerWindow.yProperty().removeListener(this.weakYListener);
            this.ownerWindow.widthProperty().removeListener((InvalidationListener)this.weakHideListener);
            this.ownerWindow.heightProperty().removeListener((InvalidationListener)this.weakHideListener);
        }
        this.ownerWindow = owner.getScene().getWindow();
        this.ownerWindow.xProperty().addListener(this.weakXListener);
        this.ownerWindow.yProperty().addListener(this.weakYListener);
        this.ownerWindow.widthProperty().addListener((InvalidationListener)this.weakHideListener);
        this.ownerWindow.heightProperty().addListener((InvalidationListener)this.weakHideListener);
        this.setOnShown(evt -> {
            this.getScene().addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
                if (mouseEvent.getTarget().equals((Object)this.getScene().getRoot()) && !this.isDetached()) {
                    this.hide();
                }
            });
            this.adjustWindowLocation();
        });
        super.show(owner, x, y);
        if (this.isAnimated()) {
            this.showFadeInAnimation(fadeInDuration);
        }
        this.ownerWindow.addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, this.closePopOverOnOwnerWindowClose);
        this.ownerWindow.addEventFilter(WindowEvent.WINDOW_HIDING, this.closePopOverOnOwnerWindowClose);
    }

    private void showFadeInAnimation(Duration fadeInDuration) {
        Node skinNode = this.getSkin().getNode();
        skinNode.setOpacity(0.0);
        FadeTransition fadeIn = new FadeTransition(fadeInDuration, skinNode);
        fadeIn.setFromValue(0.0);
        fadeIn.setToValue(1.0);
        fadeIn.play();
    }

    private void ownerWindowClosing() {
        this.hide(Duration.ZERO);
    }

    public final void hide() {
        this.hide(this.getFadeOutDuration());
    }

    public final void hide(Duration fadeOutDuration) {
        this.log.debug("hide:" + fadeOutDuration.toString());
        if (this.ownerWindow != null) {
            this.ownerWindow.removeEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, this.closePopOverOnOwnerWindowClose);
            this.ownerWindow.removeEventFilter(WindowEvent.WINDOW_HIDING, this.closePopOverOnOwnerWindowClose);
        }
        if (fadeOutDuration == null) {
            fadeOutDuration = DEFAULT_FADE_DURATION;
        }
        if (this.isShowing()) {
            super.hide();
        }
    }

    private void adjustWindowLocation() {
        Bounds bounds = this.getSkin().getNode().getBoundsInParent();
        switch (this.getArrowLocation().ordinal()) {
            case 6: 
            case 7: 
            case 8: {
                this.setAnchorX(this.getAnchorX() + bounds.getMinX() - this.computeXOffset());
                this.setAnchorY(this.getAnchorY() + bounds.getMinY() + this.getArrowSize());
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                this.setAnchorX(this.getAnchorX() + bounds.getMinX() + this.getArrowSize());
                this.setAnchorY(this.getAnchorY() + bounds.getMinY() - this.computeYOffset());
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                this.setAnchorX(this.getAnchorX() + bounds.getMinX() - this.computeXOffset());
                this.setAnchorY(this.getAnchorY() - bounds.getMinY() - bounds.getMaxY() - 1.0);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.setAnchorX(this.getAnchorX() - bounds.getMinX() - bounds.getMaxX() - 1.0);
                this.setAnchorY(this.getAnchorY() + bounds.getMinY() - this.computeYOffset());
            }
        }
    }

    private double computeXOffset() {
        switch (this.getArrowLocation().ordinal()) {
            case 6: 
            case 9: {
                return this.getCornerRadius() + this.getArrowIndent() + this.getArrowSize();
            }
            case 7: 
            case 10: {
                return this.getContentNode().prefWidth(-1.0) / 2.0;
            }
            case 8: 
            case 11: {
                return this.getContentNode().prefWidth(-1.0) - this.getArrowIndent() - this.getCornerRadius() - this.getArrowSize();
            }
        }
        return 0.0;
    }

    private double computeYOffset() {
        double prefContentHeight = this.getContentNode().prefHeight(-1.0);
        switch (this.getArrowLocation().ordinal()) {
            case 0: 
            case 3: {
                return this.getCornerRadius() + this.getArrowIndent() + this.getArrowSize();
            }
            case 1: 
            case 4: {
                return Math.max(prefContentHeight, 2.0 * (this.getCornerRadius() + this.getArrowIndent() + this.getArrowSize())) / 2.0;
            }
            case 2: 
            case 5: {
                return Math.max(prefContentHeight - this.getCornerRadius() - this.getArrowIndent() - this.getArrowSize(), this.getCornerRadius() + this.getArrowIndent() + this.getArrowSize());
            }
        }
        return 0.0;
    }

    public final void detach() {
        if (this.isDetachable()) {
            this.setDetached(true);
        }
    }

    public final BooleanProperty headerAlwaysVisibleProperty() {
        return this.headerAlwaysVisible;
    }

    public final void setHeaderAlwaysVisible(boolean visible) {
        this.headerAlwaysVisible.setValue(Boolean.valueOf(visible));
    }

    public final boolean isHeaderAlwaysVisible() {
        return this.headerAlwaysVisible.getValue();
    }

    public final BooleanProperty closeButtonEnabledProperty() {
        return this.closeButtonEnabled;
    }

    public final void setCloseButtonEnabled(boolean enabled) {
        this.closeButtonEnabled.setValue(Boolean.valueOf(enabled));
    }

    public final boolean isCloseButtonEnabled() {
        return this.closeButtonEnabled.getValue();
    }

    public final BooleanProperty detachableProperty() {
        return this.detachable;
    }

    public final void setDetachable(boolean detachable) {
        this.detachableProperty().set(detachable);
    }

    public final boolean isDetachable() {
        return this.detachableProperty().get();
    }

    public final BooleanProperty detachedProperty() {
        return this.detached;
    }

    public final void setDetached(boolean detached) {
        this.detachedProperty().set(detached);
    }

    public final boolean isDetached() {
        return this.detachedProperty().get();
    }

    public final DoubleProperty arrowSizeProperty() {
        return this.arrowSize;
    }

    public final double getArrowSize() {
        return this.arrowSizeProperty().get();
    }

    public final void setArrowSize(double size) {
        this.arrowSizeProperty().set(size);
    }

    public final DoubleProperty arrowIndentProperty() {
        return this.arrowIndent;
    }

    public final double getArrowIndent() {
        return this.arrowIndentProperty().get();
    }

    public final void setArrowIndent(double size) {
        this.arrowIndentProperty().set(size);
    }

    public final DoubleProperty cornerRadiusProperty() {
        return this.cornerRadius;
    }

    public final double getCornerRadius() {
        return this.cornerRadiusProperty().get();
    }

    public final void setCornerRadius(double radius) {
        this.cornerRadiusProperty().set(radius);
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    public final String getTitle() {
        return (String)this.titleProperty().get();
    }

    public final void setTitle(String title) {
        if (title == null) {
            throw new IllegalArgumentException("title can not be null");
        }
        this.titleProperty().set((Object)title);
    }

    public final ObjectProperty<ArrowLocation> arrowLocationProperty() {
        return this.arrowLocation;
    }

    public final void setArrowLocation(ArrowLocation location) {
        this.arrowLocationProperty().set((Object)location);
    }

    public final ArrowLocation getArrowLocation() {
        return (ArrowLocation)((Object)this.arrowLocationProperty().get());
    }

    public final ObjectProperty<Duration> fadeInDurationProperty() {
        return this.fadeInDuration;
    }

    public final ObjectProperty<Duration> fadeOutDurationProperty() {
        return this.fadeOutDuration;
    }

    public final Duration getFadeInDuration() {
        return (Duration)this.fadeInDurationProperty().get();
    }

    public final void setFadeInDuration(Duration duration) {
        this.fadeInDurationProperty().setValue((Object)duration);
    }

    public final Duration getFadeOutDuration() {
        return (Duration)this.fadeOutDurationProperty().get();
    }

    public final void setFadeOutDuration(Duration duration) {
        this.fadeOutDurationProperty().setValue((Object)duration);
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    public final boolean isAnimated() {
        return this.animatedProperty().get();
    }

    public final void setAnimated(boolean animated) {
        this.animatedProperty().set(animated);
    }

    public static enum ArrowLocation {
        LEFT_TOP,
        LEFT_CENTER,
        LEFT_BOTTOM,
        RIGHT_TOP,
        RIGHT_CENTER,
        RIGHT_BOTTOM,
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;

    }
}

