/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.chart;

import haveno.common.util.MathUtils;
import java.math.RoundingMode;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporalAdjusterModel {
    private static final Logger log = LoggerFactory.getLogger(TemporalAdjusterModel.class);
    private static final ZoneId ZONE_ID = ZoneId.systemDefault();
    protected TemporalAdjuster temporalAdjuster = Interval.DAY.getAdjuster();

    public void setTemporalAdjuster(TemporalAdjuster temporalAdjuster) {
        this.temporalAdjuster = temporalAdjuster;
    }

    public TemporalAdjuster getTemporalAdjuster() {
        return this.temporalAdjuster;
    }

    public long toTimeInterval(Instant instant) {
        return this.toTimeInterval(instant, this.temporalAdjuster);
    }

    public long toTimeInterval(Instant instant, TemporalAdjuster temporalAdjuster) {
        return instant.atZone(ZONE_ID).toLocalDate().with(temporalAdjuster).atStartOfDay(ZONE_ID).toInstant().getEpochSecond();
    }

    public static enum Interval {
        YEAR(TemporalAdjusters.firstDayOfYear()),
        HALF_YEAR(temporal -> {
            long halfYear = temporal.range(ChronoField.DAY_OF_YEAR).getMaximum() / 2L;
            int dayOfYear = 0;
            if (temporal instanceof LocalDate) {
                dayOfYear = ((LocalDate)temporal).getDayOfYear();
            }
            if ((long)dayOfYear <= halfYear) {
                return temporal.with(ChronoField.DAY_OF_YEAR, 1L);
            }
            return temporal.with(ChronoField.DAY_OF_YEAR, halfYear + 1L);
        }),
        QUARTER(temporal -> {
            long quarter1 = temporal.range(ChronoField.DAY_OF_YEAR).getMaximum() / 4L;
            long halfYear = temporal.range(ChronoField.DAY_OF_YEAR).getMaximum() / 2L;
            long quarter3 = MathUtils.roundDoubleToLong((double)((double)temporal.range(ChronoField.DAY_OF_YEAR).getMaximum() * 0.75), (RoundingMode)RoundingMode.FLOOR);
            int dayOfYear = 0;
            if (temporal instanceof LocalDate) {
                dayOfYear = ((LocalDate)temporal).getDayOfYear();
            }
            if ((long)dayOfYear <= quarter1) {
                return temporal.with(ChronoField.DAY_OF_YEAR, 1L);
            }
            if ((long)dayOfYear <= halfYear) {
                return temporal.with(ChronoField.DAY_OF_YEAR, quarter1 + 1L);
            }
            if ((long)dayOfYear <= quarter3) {
                return temporal.with(ChronoField.DAY_OF_YEAR, halfYear + 1L);
            }
            return temporal.with(ChronoField.DAY_OF_YEAR, quarter3 + 1L);
        }),
        MONTH(TemporalAdjusters.firstDayOfMonth()),
        WEEK(TemporalAdjusters.next(DayOfWeek.MONDAY)),
        DAY(TemporalAdjusters.ofDateAdjuster(d -> d));

        private final TemporalAdjuster adjuster;

        private Interval(TemporalAdjuster adjuster) {
            this.adjuster = adjuster;
        }

        public TemporalAdjuster getAdjuster() {
            return this.adjuster;
        }
    }
}

