/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.chart;

import haveno.common.util.Tuple2;
import haveno.desktop.common.model.ActivatableWithDataModel;
import haveno.desktop.components.chart.ChartDataModel;
import haveno.desktop.components.chart.TemporalAdjusterModel;
import haveno.desktop.util.DisplayUtils;
import java.time.temporal.TemporalAdjuster;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.scene.chart.XYChart;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChartViewModel<T extends ChartDataModel>
extends ActivatableWithDataModel<T> {
    private static final Logger log = LoggerFactory.getLogger(ChartViewModel.class);
    private static final double LEFT_TIMELINE_SNAP_VALUE = 0.01;
    private static final double RIGHT_TIMELINE_SNAP_VALUE = 0.99;
    private final Double[] dividerPositions = new Double[]{0.0, 1.0};
    protected Number lowerBound;
    protected Number upperBound;
    protected String dateFormatPatters = "dd MMM\nyyyy";
    long fromDate;
    long toDate;

    public ChartViewModel(T dataModel) {
        super(dataModel);
    }

    @Override
    public void activate() {
        this.dividerPositions[0] = 0.0;
        this.dividerPositions[1] = 1.0;
    }

    protected void applyTemporalAdjuster(TemporalAdjuster temporalAdjuster) {
        ((ChartDataModel)this.dataModel).setTemporalAdjuster(temporalAdjuster);
    }

    void setDateFormatPattern(TemporalAdjusterModel.Interval interval) {
        switch (interval) {
            case YEAR: {
                this.dateFormatPatters = "yyyy";
                break;
            }
            case HALF_YEAR: 
            case QUARTER: 
            case MONTH: {
                this.dateFormatPatters = "MMM\nyyyy";
                break;
            }
            default: {
                this.dateFormatPatters = "MMM dd\nyyyy";
            }
        }
    }

    protected TemporalAdjuster getTemporalAdjuster() {
        return ((ChartDataModel)this.dataModel).getTemporalAdjuster();
    }

    void onTimelineNavigationChanged(double leftPos, double rightPos) {
        this.applyFromToDates(leftPos, rightPos);
        long from = leftPos < 0.01 ? 0L : this.fromDate;
        long to = rightPos > 0.99 ? new Date().getTime() / 1000L + TimeUnit.DAYS.toSeconds(365L) : this.toDate;
        this.dividerPositions[0] = leftPos;
        this.dividerPositions[1] = rightPos;
        ((ChartDataModel)this.dataModel).setDateFilter(from, to);
    }

    void applyFromToDates(double leftPos, double rightPos) {
        if (leftPos < 0.01) {
            leftPos = 0.0;
        }
        if (rightPos > 0.99) {
            rightPos = 1.0;
        }
        long lowerBoundAsLong = this.lowerBound.longValue();
        long totalRange = this.upperBound.longValue() - lowerBoundAsLong;
        this.fromDate = (long)((double)lowerBoundAsLong + (double)totalRange * leftPos);
        this.toDate = (long)((double)lowerBoundAsLong + (double)totalRange * rightPos);
    }

    void onTimelineMouseDrag(double leftPos, double rightPos) {
        if (leftPos > 0.01) {
            this.dividerPositions[1] = rightPos;
        }
        if (rightPos < 0.99) {
            this.dividerPositions[0] = leftPos;
        }
    }

    void initBounds(List<XYChart.Data<Number, Number>> data1, List<XYChart.Data<Number, Number>> data2) {
        Tuple2<Double, Double> xMinMaxTradeFee = this.getMinMax(data1);
        Tuple2<Double, Double> xMinMaxCompensationRequest = this.getMinMax(data2);
        this.lowerBound = Math.min((Double)xMinMaxTradeFee.first, (Double)xMinMaxCompensationRequest.first);
        this.upperBound = Math.max((Double)xMinMaxTradeFee.second, (Double)xMinMaxCompensationRequest.second);
    }

    void initBounds(List<XYChart.Data<Number, Number>> data) {
        Tuple2<Double, Double> xMinMaxTradeFee = this.getMinMax(data);
        this.lowerBound = (Number)xMinMaxTradeFee.first;
        this.upperBound = (Number)xMinMaxTradeFee.second;
    }

    StringConverter<Number> getTimeAxisStringConverter() {
        return new StringConverter<Number>(){

            public String toString(Number epochSeconds) {
                Date date = new Date(epochSeconds.longValue() * 1000L);
                return DisplayUtils.formatDateAxis(date, ChartViewModel.this.getDateFormatPatters());
            }

            public Number fromString(String string) {
                return 0;
            }
        };
    }

    protected StringConverter<Number> getYAxisStringConverter() {
        return new StringConverter<Number>(this){

            public String toString(Number value) {
                return String.valueOf(value);
            }

            public Number fromString(String string) {
                return null;
            }
        };
    }

    String getTooltipDateConverter(Number date) {
        return this.getTimeAxisStringConverter().toString((Object)date).replace("\n", " ");
    }

    protected String getTooltipValueConverter(Number value) {
        return this.getYAxisStringConverter().toString((Object)value);
    }

    protected void invalidateCache() {
        ((ChartDataModel)this.dataModel).invalidateCache();
    }

    protected List<XYChart.Data<Number, Number>> toChartData(Map<Long, Long> map) {
        return map.entrySet().stream().map(entry -> new XYChart.Data((Object)((Number)entry.getKey()), (Object)((Number)entry.getValue()))).collect(Collectors.toList());
    }

    protected List<XYChart.Data<Number, Number>> toChartDoubleData(Map<Long, Double> map) {
        return map.entrySet().stream().map(entry -> new XYChart.Data((Object)((Number)entry.getKey()), (Object)((Number)entry.getValue()))).collect(Collectors.toList());
    }

    protected List<XYChart.Data<Number, Number>> toChartLongData(Map<Long, Long> map) {
        return map.entrySet().stream().map(entry -> new XYChart.Data((Object)((Number)entry.getKey()), (Object)((Number)entry.getValue()))).collect(Collectors.toList());
    }

    private Tuple2<Double, Double> getMinMax(List<XYChart.Data<Number, Number>> chartData) {
        long min = Long.MAX_VALUE;
        long max = 0L;
        for (XYChart.Data<Number, Number> data : chartData) {
            long value = ((Number)data.getXValue()).longValue();
            min = Math.min(value, min);
            max = Math.max(value, max);
        }
        return new Tuple2((Object)min, (Object)max);
    }

    public Double[] getDividerPositions() {
        return this.dividerPositions;
    }

    public Number getLowerBound() {
        return this.lowerBound;
    }

    public Number getUpperBound() {
        return this.upperBound;
    }

    public String getDateFormatPatters() {
        return this.dateFormatPatters;
    }

    public long getFromDate() {
        return this.fromDate;
    }

    public long getToDate() {
        return this.toDate;
    }
}

