/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.chart;

import haveno.common.UserThread;
import haveno.core.locale.Res;
import haveno.desktop.common.view.ActivatableViewAndModel;
import haveno.desktop.components.AutoTooltipSlideToggleButton;
import haveno.desktop.components.AutoTooltipToggleButton;
import haveno.desktop.components.chart.ChartDataModel;
import haveno.desktop.components.chart.ChartViewModel;
import haveno.desktop.components.chart.TemporalAdjusterModel;
import java.time.temporal.TemporalAdjuster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.PopupWindow;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChartView<T extends ChartViewModel<? extends ChartDataModel>>
extends ActivatableViewAndModel<VBox, T> {
    private static final Logger log = LoggerFactory.getLogger(ChartView.class);
    private Pane center;
    private SplitPane timelineNavigation;
    protected NumberAxis xAxis;
    protected NumberAxis yAxis;
    protected LineChart<Number, Number> chart;
    private HBox timelineLabels;
    private HBox legendBox2;
    private HBox legendBox3;
    private final ToggleGroup timeIntervalToggleGroup = new ToggleGroup();
    protected final Set<XYChart.Series<Number, Number>> activeSeries = new HashSet<XYChart.Series<Number, Number>>();
    protected final Map<String, Integer> seriesIndexMap = new HashMap<String, Integer>();
    protected final Map<String, AutoTooltipSlideToggleButton> legendToggleBySeriesName = new HashMap<String, AutoTooltipSlideToggleButton>();
    private final List<Node> dividerNodes = new ArrayList<Node>();
    private final List<Tooltip> dividerNodesTooltips = new ArrayList<Tooltip>();
    private ChangeListener<Number> widthListener;
    private ChangeListener<Toggle> timeIntervalChangeListener;
    private ListChangeListener<Node> nodeListChangeListener;
    private int maxSeriesSize;
    private boolean centerPanePressed;
    private double x;
    protected boolean isRadioButtonBehaviour;
    private int maxDataPointsForShowingSymbols = 100;
    private ChangeListener<Number> yAxisWidthListener;
    private EventHandler<MouseEvent> dividerMouseDraggedEventHandler;
    private final StringProperty fromProperty = new SimpleStringProperty();
    private final StringProperty toProperty = new SimpleStringProperty();

    public ChartView(T model) {
        super(model);
        this.root = new VBox();
    }

    @Override
    public void initialize() {
        Collection<XYChart.Series<Number, Number>> seriesForLegend3;
        this.prepareInitialize();
        this.maxSeriesSize = 0;
        this.centerPanePressed = false;
        this.x = 0.0;
        this.createSeries();
        HBox timeIntervalBox = this.getTimeIntervalBox();
        this.xAxis = this.getXAxis();
        this.yAxis = this.getYAxis();
        this.chart = this.getChart();
        this.addTimelineNavigation();
        HBox legendBox1 = this.initLegendsAndGetLegendBox(this.getSeriesForLegend1());
        Collection<XYChart.Series<Number, Number>> seriesForLegend2 = this.getSeriesForLegend2();
        if (seriesForLegend2 != null && !seriesForLegend2.isEmpty()) {
            this.legendBox2 = this.initLegendsAndGetLegendBox(seriesForLegend2);
        }
        if ((seriesForLegend3 = this.getSeriesForLegend3()) != null && !seriesForLegend3.isEmpty()) {
            this.legendBox3 = this.initLegendsAndGetLegendBox(seriesForLegend3);
        }
        this.defineAndAddActiveSeries();
        VBox timelineNavigationBox = new VBox();
        double paddingLeft = 15.0;
        double paddingRight = 89.0;
        this.yAxisWidthListener = (observable, oldValue, newValue) -> {
            double width = newValue.doubleValue();
            if (width > 0.0) {
                double rightPadding = width + 14.0;
                VBox.setMargin((Node)timeIntervalBox, (Insets)new Insets(0.0, rightPadding, 0.0, paddingLeft));
                VBox.setMargin((Node)this.timelineNavigation, (Insets)new Insets(0.0, rightPadding, 0.0, paddingLeft));
                VBox.setMargin((Node)this.timelineLabels, (Insets)new Insets(0.0, rightPadding, 0.0, paddingLeft));
                VBox.setMargin((Node)legendBox1, (Insets)new Insets(10.0, rightPadding, 0.0, paddingLeft));
                if (this.legendBox2 != null) {
                    VBox.setMargin((Node)this.legendBox2, (Insets)new Insets(-20.0, rightPadding, 0.0, paddingLeft));
                }
                if (this.legendBox3 != null) {
                    VBox.setMargin((Node)this.legendBox3, (Insets)new Insets(-20.0, rightPadding, 0.0, paddingLeft));
                }
                if (((ChartViewModel)this.model).getDividerPositions()[0] == 0.0 && ((ChartViewModel)this.model).getDividerPositions()[1] == 1.0) {
                    this.resetTimeNavigation();
                }
            }
        };
        VBox.setMargin((Node)timeIntervalBox, (Insets)new Insets(0.0, paddingRight, 0.0, paddingLeft));
        VBox.setMargin((Node)this.timelineNavigation, (Insets)new Insets(0.0, paddingRight, 0.0, paddingLeft));
        VBox.setMargin((Node)this.timelineLabels, (Insets)new Insets(0.0, paddingRight, 0.0, paddingLeft));
        VBox.setMargin((Node)legendBox1, (Insets)new Insets(0.0, paddingRight, 0.0, paddingLeft));
        timelineNavigationBox.getChildren().addAll((Object[])new Node[]{this.timelineNavigation, this.timelineLabels, legendBox1});
        if (this.legendBox2 != null) {
            VBox.setMargin((Node)this.legendBox2, (Insets)new Insets(-20.0, paddingRight, 0.0, paddingLeft));
            timelineNavigationBox.getChildren().add((Object)this.legendBox2);
        }
        if (this.legendBox3 != null) {
            VBox.setMargin((Node)this.legendBox3, (Insets)new Insets(-20.0, paddingRight, 0.0, paddingLeft));
            timelineNavigationBox.getChildren().add((Object)this.legendBox3);
        }
        ((VBox)this.root).getChildren().addAll((Object[])new Node[]{timeIntervalBox, this.chart, timelineNavigationBox});
        this.widthListener = (observable, oldValue, newValue) -> {
            this.timelineNavigation.setDividerPosition(0, ((ChartViewModel)this.model).getDividerPositions()[0].doubleValue());
            this.timelineNavigation.setDividerPosition(1, ((ChartViewModel)this.model).getDividerPositions()[1].doubleValue());
        };
        this.timeIntervalChangeListener = (observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.onTimeIntervalChanged((Toggle)newValue);
            }
        };
        this.nodeListChangeListener = c -> {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                c.getAddedSubList().stream().filter(node -> node instanceof Text).forEach(node -> node.getStyleClass().add((Object)"axis-tick-mark-text-node"));
            }
        };
    }

    @Override
    public void activate() {
        this.timelineNavigation.setDividerPositions(new double[]{((ChartViewModel)this.model).getDividerPositions()[0], ((ChartViewModel)this.model).getDividerPositions()[1]});
        TemporalAdjuster temporalAdjuster = ((ChartViewModel)this.model).getTemporalAdjuster();
        this.applyTemporalAdjuster(temporalAdjuster);
        this.findTimeIntervalToggleByTemporalAdjuster(temporalAdjuster).ifPresent(arg_0 -> ((ToggleGroup)this.timeIntervalToggleGroup).selectToggle(arg_0));
        this.defineAndAddActiveSeries();
        this.initBoundsForTimelineNavigation();
        ((VBox)this.root).widthProperty().addListener(this.widthListener);
        this.xAxis.getChildrenUnmodifiable().addListener(this.nodeListChangeListener);
        this.yAxis.widthProperty().addListener(this.yAxisWidthListener);
        this.timeIntervalToggleGroup.selectedToggleProperty().addListener(this.timeIntervalChangeListener);
        this.timelineNavigation.setOnMousePressed(this::onMousePressedSplitPane);
        this.timelineNavigation.setOnMouseDragged(this::onMouseDragged);
        this.center.setOnMousePressed(this::onMousePressedCenter);
        this.center.setOnMouseReleased(this::onMouseReleasedCenter);
        this.addLegendToggleActionHandlers(this.getSeriesForLegend1());
        this.addLegendToggleActionHandlers(this.getSeriesForLegend2());
        this.addLegendToggleActionHandlers(this.getSeriesForLegend3());
        this.addActionHandlersToDividers();
    }

    @Override
    public void deactivate() {
        ((VBox)this.root).widthProperty().removeListener(this.widthListener);
        this.xAxis.getChildrenUnmodifiable().removeListener(this.nodeListChangeListener);
        this.yAxis.widthProperty().removeListener(this.yAxisWidthListener);
        this.timeIntervalToggleGroup.selectedToggleProperty().removeListener(this.timeIntervalChangeListener);
        this.timelineNavigation.setOnMousePressed(null);
        this.timelineNavigation.setOnMouseDragged(null);
        this.center.setOnMousePressed(null);
        this.center.setOnMouseReleased(null);
        this.removeLegendToggleActionHandlers(this.getSeriesForLegend1());
        this.removeLegendToggleActionHandlers(this.getSeriesForLegend2());
        this.removeLegendToggleActionHandlers(this.getSeriesForLegend3());
        this.removeActionHandlersToDividers();
        this.activeSeries.clear();
        this.chart.getData().clear();
        this.legendToggleBySeriesName.values().forEach(e -> e.setSelected(false));
        this.dividerNodes.clear();
        this.dividerNodesTooltips.clear();
        ((ChartViewModel)this.model).invalidateCache();
    }

    protected HBox getTimeIntervalBox() {
        ToggleButton year = this.getTimeIntervalToggleButton(Res.get((String)"time.year"), TemporalAdjusterModel.Interval.YEAR, this.timeIntervalToggleGroup, "toggle-left");
        ToggleButton halfYear = this.getTimeIntervalToggleButton(Res.get((String)"time.halfYear"), TemporalAdjusterModel.Interval.HALF_YEAR, this.timeIntervalToggleGroup, "toggle-center");
        ToggleButton quarter = this.getTimeIntervalToggleButton(Res.get((String)"time.quarter"), TemporalAdjusterModel.Interval.QUARTER, this.timeIntervalToggleGroup, "toggle-center");
        ToggleButton month = this.getTimeIntervalToggleButton(Res.get((String)"time.month"), TemporalAdjusterModel.Interval.MONTH, this.timeIntervalToggleGroup, "toggle-center");
        ToggleButton week = this.getTimeIntervalToggleButton(Res.get((String)"time.week"), TemporalAdjusterModel.Interval.WEEK, this.timeIntervalToggleGroup, "toggle-center");
        ToggleButton day = this.getTimeIntervalToggleButton(Res.get((String)"time.day"), TemporalAdjusterModel.Interval.DAY, this.timeIntervalToggleGroup, "toggle-center");
        HBox toggleBox = new HBox();
        toggleBox.setSpacing(0.0);
        toggleBox.setAlignment(Pos.CENTER_LEFT);
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        toggleBox.getChildren().addAll((Object[])new Node[]{spacer, year, halfYear, quarter, month, week, day});
        return toggleBox;
    }

    private ToggleButton getTimeIntervalToggleButton(String label, TemporalAdjusterModel.Interval interval, ToggleGroup toggleGroup, String style) {
        AutoTooltipToggleButton toggleButton = new AutoTooltipToggleButton(label);
        toggleButton.setUserData((Object)interval);
        toggleButton.setToggleGroup(toggleGroup);
        toggleButton.setId(style);
        return toggleButton;
    }

    protected void applyTemporalAdjuster(TemporalAdjuster temporalAdjuster) {
        ((ChartViewModel)this.model).applyTemporalAdjuster(temporalAdjuster);
        this.findTimeIntervalToggleByTemporalAdjuster(temporalAdjuster).map(e -> (TemporalAdjusterModel.Interval)((Object)((Object)e.getUserData()))).ifPresent(((ChartViewModel)this.model)::setDateFormatPattern);
    }

    protected NumberAxis getXAxis() {
        NumberAxis xAxis = new NumberAxis();
        xAxis.setForceZeroInRange(false);
        xAxis.setAutoRanging(true);
        xAxis.setTickLabelFormatter(((ChartViewModel)this.model).getTimeAxisStringConverter());
        return xAxis;
    }

    protected NumberAxis getYAxis() {
        NumberAxis yAxis = new NumberAxis();
        yAxis.setForceZeroInRange(true);
        yAxis.setSide(Side.RIGHT);
        yAxis.setTickLabelFormatter(((ChartViewModel)this.model).getYAxisStringConverter());
        return yAxis;
    }

    protected void onSetYAxisFormatter(XYChart.Series<Number, Number> series) {
    }

    protected LineChart<Number, Number> getChart() {
        LineChart chart = new LineChart((Axis)this.xAxis, (Axis)this.yAxis);
        chart.setAnimated(false);
        chart.setLegendVisible(false);
        chart.setMinHeight(200.0);
        chart.setId("charts-dao");
        return chart;
    }

    protected HBox initLegendsAndGetLegendBox(Collection<XYChart.Series<Number, Number>> collection) {
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        collection.forEach(series -> {
            AutoTooltipSlideToggleButton toggle = new AutoTooltipSlideToggleButton();
            toggle.setMinWidth(200.0);
            toggle.setAlignment(Pos.TOP_LEFT);
            String seriesId = this.getSeriesId((XYChart.Series<Number, Number>)series);
            this.legendToggleBySeriesName.put(seriesId, toggle);
            toggle.setText(seriesId);
            toggle.setId("charts-legend-toggle" + String.valueOf(this.seriesIndexMap.get(seriesId)));
            toggle.setSelected(false);
            hBox.getChildren().add((Object)toggle);
        });
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        hBox.getChildren().add((Object)spacer);
        return hBox;
    }

    private void addLegendToggleActionHandlers(@Nullable Collection<XYChart.Series<Number, Number>> collection) {
        if (collection != null) {
            collection.forEach(series -> this.legendToggleBySeriesName.get(this.getSeriesId((XYChart.Series<Number, Number>)series)).setOnAction(e -> this.onSelectLegendToggle((XYChart.Series<Number, Number>)series)));
        }
    }

    private void removeLegendToggleActionHandlers(@Nullable Collection<XYChart.Series<Number, Number>> collection) {
        if (collection != null) {
            collection.forEach(series -> this.legendToggleBySeriesName.get(this.getSeriesId((XYChart.Series<Number, Number>)series)).setOnAction(null));
        }
    }

    private void addTimelineNavigation() {
        Pane left = new Pane();
        this.center = new Pane();
        this.center.setId("chart-navigation-center-pane");
        Pane right = new Pane();
        this.timelineNavigation = new SplitPane(new Node[]{left, this.center, right});
        this.timelineNavigation.setDividerPositions(new double[]{((ChartViewModel)this.model).getDividerPositions()[0], ((ChartViewModel)this.model).getDividerPositions()[1]});
        this.timelineNavigation.setMinHeight(25.0);
        this.timelineLabels = new HBox();
    }

    protected void applyTimeLineNavigationLabels() {
        this.timelineLabels.getChildren().clear();
        ObservableList tickMarks = this.xAxis.getTickMarks();
        int size = tickMarks.size();
        for (int i = 0; i < size; ++i) {
            Axis.TickMark tickMark = (Axis.TickMark)tickMarks.get(i);
            Number xValue = (Number)tickMark.getValue();
            String xValueString = this.xAxis.getTickLabelFormatter() != null ? this.xAxis.getTickLabelFormatter().toString((Object)xValue) : String.valueOf(xValue);
            Label label = new Label(xValueString);
            label.setMinHeight(30.0);
            label.setId("chart-navigation-label");
            Region spacer = new Region();
            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
            if (i < size - 1) {
                this.timelineLabels.getChildren().addAll((Object[])new Node[]{label, spacer});
                continue;
            }
            this.timelineLabels.getChildren().add((Object)label);
        }
    }

    private void onMousePressedSplitPane(MouseEvent e) {
        this.x = e.getX();
        this.applyFromToDates();
        this.showDividerTooltips();
    }

    private void onMousePressedCenter(MouseEvent e) {
        this.centerPanePressed = true;
        this.applyFromToDates();
        this.showDividerTooltips();
    }

    private void onMouseReleasedCenter(MouseEvent e) {
        this.centerPanePressed = false;
        this.onTimelineChanged();
        this.hideDividerTooltips();
    }

    private void onMouseDragged(MouseEvent e) {
        if (this.centerPanePressed) {
            double newX = e.getX();
            double width = this.timelineNavigation.getWidth();
            double relativeDelta = (this.x - newX) / width;
            double leftPos = this.timelineNavigation.getDividerPositions()[0] - relativeDelta;
            double rightPos = this.timelineNavigation.getDividerPositions()[1] - relativeDelta;
            ((ChartViewModel)this.model).onTimelineMouseDrag(leftPos, rightPos);
            this.timelineNavigation.setDividerPositions(new double[]{((ChartViewModel)this.model).getDividerPositions()[0], ((ChartViewModel)this.model).getDividerPositions()[1]});
            this.x = newX;
            this.applyFromToDates();
            this.showDividerTooltips();
        }
    }

    private void addActionHandlersToDividers() {
        this.timelineNavigation.requestLayout();
        this.timelineNavigation.applyCss();
        this.dividerMouseDraggedEventHandler = event -> {
            this.applyFromToDates();
            this.showDividerTooltips();
        };
        for (Node node : this.timelineNavigation.lookupAll(".split-pane-divider")) {
            this.dividerNodes.add(node);
            node.setOnMouseReleased(e -> {
                this.hideDividerTooltips();
                this.onTimelineChanged();
            });
            node.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.dividerMouseDraggedEventHandler);
            Tooltip tooltip = new Tooltip("");
            this.dividerNodesTooltips.add(tooltip);
            tooltip.setShowDelay(Duration.millis((double)300.0));
            tooltip.setShowDuration(Duration.seconds((double)3.0));
            tooltip.textProperty().bind((ObservableValue)(this.dividerNodes.size() == 1 ? this.fromProperty : this.toProperty));
            Tooltip.install((Node)node, (Tooltip)tooltip);
        }
    }

    private void removeActionHandlersToDividers() {
        this.dividerNodes.forEach(node -> {
            node.setOnMouseReleased(null);
            node.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.dividerMouseDraggedEventHandler);
        });
        for (int i = 0; i < this.dividerNodesTooltips.size(); ++i) {
            Tooltip tooltip = this.dividerNodesTooltips.get(i);
            tooltip.textProperty().unbind();
            Tooltip.uninstall((Node)this.dividerNodes.get(i), (Tooltip)tooltip);
        }
    }

    private void resetTimeNavigation() {
        this.timelineNavigation.setDividerPositions(new double[]{0.0, 1.0});
        ((ChartViewModel)this.model).onTimelineNavigationChanged(0.0, 1.0);
    }

    private void showDividerTooltips() {
        this.showDividerTooltip(0);
        this.showDividerTooltip(1);
    }

    private void hideDividerTooltips() {
        this.dividerNodesTooltips.forEach(PopupWindow::hide);
    }

    private void showDividerTooltip(int index) {
        Node divider = this.dividerNodes.get(index);
        Bounds bounds = divider.localToScene(divider.getBoundsInLocal());
        Tooltip tooltip = this.dividerNodesTooltips.get(index);
        double xOffset = index == 0 ? -90.0 : 10.0;
        Stage stage = (Stage)((VBox)this.root).getScene().getWindow();
        tooltip.show((Window)stage, stage.getX() + bounds.getMaxX() + xOffset, stage.getY() + bounds.getMaxY() - 40.0);
    }

    protected abstract void createSeries();

    protected abstract Collection<XYChart.Series<Number, Number>> getSeriesForLegend1();

    protected Collection<XYChart.Series<Number, Number>> getSeriesForLegend2() {
        return null;
    }

    protected Collection<XYChart.Series<Number, Number>> getSeriesForLegend3() {
        return null;
    }

    protected abstract void defineAndAddActiveSeries();

    protected void activateSeries(XYChart.Series<Number, Number> series) {
        if (this.activeSeries.contains(series)) {
            return;
        }
        this.chart.getData().add(series);
        this.activeSeries.add(series);
        this.legendToggleBySeriesName.get(this.getSeriesId(series)).setSelected(true);
        this.applyDataAndUpdate();
    }

    protected abstract CompletableFuture<Boolean> applyData();

    private void applyDataAndUpdate() {
        long ts = System.currentTimeMillis();
        this.applyData().whenComplete((r, t) -> {
            log.debug("applyData took {}", (Object)(System.currentTimeMillis() - ts));
            long ts2 = System.currentTimeMillis();
            this.updateChartAfterDataChange();
            log.debug("updateChartAfterDataChange took {}", (Object)(System.currentTimeMillis() - ts2));
            this.onDataApplied();
        });
    }

    protected abstract void initBoundsForTimelineNavigation();

    protected void setBoundsForTimelineNavigation(ObservableList<XYChart.Data<Number, Number>> data) {
        ((ChartViewModel)this.model).initBounds((List<XYChart.Data<Number, Number>>)data);
        this.xAxis.setLowerBound(((ChartViewModel)this.model).getLowerBound().doubleValue());
        this.xAxis.setUpperBound(((ChartViewModel)this.model).getUpperBound().doubleValue());
    }

    private void onTimeIntervalChanged(Toggle newValue) {
        TemporalAdjusterModel.Interval interval = (TemporalAdjusterModel.Interval)((Object)newValue.getUserData());
        this.applyTemporalAdjuster(interval.getAdjuster());
        ((ChartViewModel)this.model).invalidateCache();
        this.applyDataAndUpdate();
    }

    private void onTimelineChanged() {
        this.updateTimeLinePositions();
        ((ChartViewModel)this.model).invalidateCache();
        this.applyDataAndUpdate();
    }

    private void updateTimeLinePositions() {
        double leftPos = this.timelineNavigation.getDividerPositions()[0];
        double rightPos = this.timelineNavigation.getDividerPositions()[1];
        ((ChartViewModel)this.model).onTimelineNavigationChanged(leftPos, rightPos);
        this.timelineNavigation.setDividerPositions(new double[]{((ChartViewModel)this.model).getDividerPositions()[0], ((ChartViewModel)this.model).getDividerPositions()[1]});
        this.fromProperty.set((Object)((ChartViewModel)this.model).getTimeAxisStringConverter().toString((Object)((ChartViewModel)this.model).getFromDate()).replace("\n", " "));
        this.toProperty.set((Object)((ChartViewModel)this.model).getTimeAxisStringConverter().toString((Object)((ChartViewModel)this.model).getToDate()).replace("\n", " "));
    }

    private void applyFromToDates() {
        double leftPos = this.timelineNavigation.getDividerPositions()[0];
        double rightPos = this.timelineNavigation.getDividerPositions()[1];
        ((ChartViewModel)this.model).applyFromToDates(leftPos, rightPos);
        this.fromProperty.set((Object)((ChartViewModel)this.model).getTimeAxisStringConverter().toString((Object)((ChartViewModel)this.model).getFromDate()).replace("\n", " "));
        this.toProperty.set((Object)((ChartViewModel)this.model).getTimeAxisStringConverter().toString((Object)((ChartViewModel)this.model).getToDate()).replace("\n", " "));
    }

    private void onSelectLegendToggle(XYChart.Series<Number, Number> series) {
        boolean isSelected = this.legendToggleBySeriesName.get(this.getSeriesId(series)).isSelected();
        if (this.isRadioButtonBehaviour) {
            new ArrayList(this.chart.getData()).stream().filter(this.activeSeries::contains).forEach(seriesToRemove -> {
                this.chart.getData().remove(seriesToRemove);
                String seriesId = this.getSeriesId((XYChart.Series<Number, Number>)seriesToRemove);
                this.activeSeries.remove(seriesToRemove);
                this.legendToggleBySeriesName.get(seriesId).setSelected(false);
            });
        }
        if (isSelected) {
            this.chart.getData().add(series);
            this.activeSeries.add(series);
            this.applyDataAndUpdate();
            if (this.isRadioButtonBehaviour) {
                this.onSetYAxisFormatter(series);
            }
        } else if (!this.isRadioButtonBehaviour) {
            this.chart.getData().remove(series);
            this.activeSeries.remove(series);
            this.updateChartAfterDataChange();
        }
    }

    protected void updateChartAfterDataChange() {
        this.cleanupDanglingSeries();
        this.updateSymbolsVisibility();
        this.applySeriesStyles();
        this.applyTooltip();
    }

    private void cleanupDanglingSeries() {
        ArrayList<XYChart.Series<Number, Number>> activeSeriesList = new ArrayList<XYChart.Series<Number, Number>>(this.activeSeries);
        activeSeriesList.forEach(series -> {
            ObservableList seriesOnChart = this.chart.getData();
            if (series.getData().isEmpty()) {
                seriesOnChart.remove(series);
            } else if (!seriesOnChart.contains(series)) {
                seriesOnChart.add(series);
            }
        });
    }

    private void updateSymbolsVisibility() {
        boolean newValue;
        this.maxDataPointsForShowingSymbols = 100;
        long numDataPoints = this.chart.getData().stream().map(XYChart.Series::getData).mapToLong(List::size).max().orElse(0L);
        boolean prevValue = this.chart.getCreateSymbols();
        boolean bl = newValue = numDataPoints < (long)this.maxDataPointsForShowingSymbols;
        if (prevValue != newValue) {
            this.chart.setCreateSymbols(newValue);
        }
    }

    private void applySeriesStyles() {
        for (int index = 0; index < this.chart.getData().size(); ++index) {
            XYChart.Series series = (XYChart.Series)this.chart.getData().get(index);
            int staticIndex = this.seriesIndexMap.get(this.getSeriesId((XYChart.Series<Number, Number>)series));
            Set<Node> lines = this.getNodesForStyle(series.getNode(), ".default-color%d.chart-series-line");
            Stream symbols = series.getData().stream().map(XYChart.Data::getNode).flatMap(node -> this.getNodesForStyle((Node)node, ".default-color%d.chart-line-symbol").stream());
            Stream.concat(lines.stream(), symbols).forEach(node -> {
                this.removeStyles((Node)node);
                node.getStyleClass().add((Object)("default-color" + staticIndex));
            });
        }
    }

    private void applyTooltip() {
        this.chart.getData().forEach(series -> series.getData().forEach(data -> {
            Node node = data.getNode();
            if (node == null) {
                return;
            }
            String xValue = ((ChartViewModel)this.model).getTooltipDateConverter((Number)data.getXValue());
            String yValue = ((ChartViewModel)this.model).getYAxisStringConverter().toString((Object)((Number)data.getYValue()));
            Tooltip.install((Node)node, (Tooltip)new Tooltip(Res.get((String)"dao.factsAndFigures.supply.chart.tradeFee.toolTip", (Object[])new Object[]{yValue, xValue})));
        }));
    }

    private void removeStyles(Node node) {
        for (int i = 0; i < this.getMaxSeriesSize(); ++i) {
            node.getStyleClass().remove((Object)("default-color" + i));
        }
    }

    private Set<Node> getNodesForStyle(Node node, String style) {
        HashSet<Node> result = new HashSet<Node>();
        if (node != null) {
            for (int i = 0; i < this.getMaxSeriesSize(); ++i) {
                result.addAll(node.lookupAll(String.format(style, i)));
            }
        }
        return result;
    }

    private int getMaxSeriesSize() {
        this.maxSeriesSize = Math.max(this.maxSeriesSize, this.chart.getData().size());
        return this.maxSeriesSize;
    }

    private Optional<Toggle> findTimeIntervalToggleByTemporalAdjuster(TemporalAdjuster adjuster) {
        return this.timeIntervalToggleGroup.getToggles().stream().filter(toggle -> ((TemporalAdjusterModel.Interval)((Object)((Object)toggle.getUserData()))).getAdjuster().equals(adjuster)).findAny();
    }

    protected String getSeriesId(XYChart.Series<Number, Number> series) {
        return series.getName();
    }

    protected void mapToUserThread(Runnable command) {
        UserThread.execute((Runnable)command);
    }

    protected void onDataApplied() {
        if (((ChartViewModel)this.model).upperBound.longValue() == 0L) {
            this.initBoundsForTimelineNavigation();
        }
    }

    public void setRadioButtonBehaviour(boolean isRadioButtonBehaviour) {
        this.isRadioButtonBehaviour = isRadioButtonBehaviour;
    }

    public void setMaxDataPointsForShowingSymbols(int maxDataPointsForShowingSymbols) {
        this.maxDataPointsForShowingSymbols = maxDataPointsForShowingSymbols;
    }
}

