/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.chart;

import haveno.desktop.common.model.ActivatableDataModel;
import haveno.desktop.components.chart.TemporalAdjusterModel;
import java.time.Instant;
import java.time.temporal.TemporalAdjuster;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class ChartDataModel
extends ActivatableDataModel {
    protected final TemporalAdjusterModel temporalAdjusterModel = new TemporalAdjusterModel();
    protected Predicate<Long> dateFilter = e -> true;

    @Override
    public void activate() {
        this.dateFilter = e -> true;
    }

    void setTemporalAdjuster(TemporalAdjuster temporalAdjuster) {
        this.temporalAdjusterModel.setTemporalAdjuster(temporalAdjuster);
    }

    TemporalAdjuster getTemporalAdjuster() {
        return this.temporalAdjusterModel.getTemporalAdjuster();
    }

    public long toTimeInterval(Instant instant) {
        return this.temporalAdjusterModel.toTimeInterval(instant);
    }

    public Predicate<Long> getDateFilter() {
        return this.dateFilter;
    }

    void setDateFilter(long from, long to) {
        this.dateFilter = value -> value >= from && value <= to;
    }

    protected abstract void invalidateCache();

    protected Map<Long, Long> getMergedMap(Map<Long, Long> map1, Map<Long, Long> map2, BinaryOperator<Long> mergeFunction) {
        return Stream.concat(map1.entrySet().stream(), map2.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mergeFunction));
    }
}

