/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import com.jfoenix.controls.JFXTextField;
import de.jensd.fx.fontawesome.AwesomeDude;
import de.jensd.fx.fontawesome.AwesomeIcon;
import haveno.common.UserThread;
import haveno.common.util.Utilities;
import haveno.core.locale.Res;
import haveno.core.trade.Trade;
import haveno.core.user.BlockChainExplorer;
import haveno.core.user.Preferences;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.components.indicator.TxConfidenceIndicator;
import haveno.desktop.util.GUIUtil;
import haveno.desktop.util.Layout;
import javafx.beans.value.ChangeListener;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javax.annotation.Nullable;
import monero.daemon.model.MoneroTx;
import monero.wallet.model.MoneroWalletListener;
import monero.wallet.model.MoneroWalletListenerI;

public class TxIdTextField
extends AnchorPane {
    private static Preferences preferences;
    private static XmrWalletService xmrWalletService;
    private final TextField textField;
    private final Tooltip progressIndicatorTooltip;
    private final TxConfidenceIndicator txConfidenceIndicator = new TxConfidenceIndicator();
    private final Label copyLabel;
    private final Label blockExplorerIcon;
    private final Label missingTxWarningIcon;
    private MoneroWalletListener walletListener;
    private ChangeListener<Number> tradeListener;
    private Trade trade;

    public TxIdTextField() {
        this.txConfidenceIndicator.setFocusTraversable(false);
        this.txConfidenceIndicator.setMaxSize(20.0, 20.0);
        this.txConfidenceIndicator.setId("funds-confidence");
        this.txConfidenceIndicator.setLayoutY(1.0);
        this.txConfidenceIndicator.setProgress(0.0);
        this.txConfidenceIndicator.setVisible(false);
        AnchorPane.setRightAnchor((Node)this.txConfidenceIndicator, (Double)0.0);
        AnchorPane.setTopAnchor((Node)this.txConfidenceIndicator, (Double)9.0);
        this.progressIndicatorTooltip = new Tooltip("-");
        this.txConfidenceIndicator.setTooltip(this.progressIndicatorTooltip);
        this.copyLabel = new Label();
        this.copyLabel.setLayoutY(9.0);
        this.copyLabel.getStyleClass().addAll((Object[])new String[]{"icon", "highlight"});
        this.copyLabel.setTooltip(new Tooltip(Res.get((String)"txIdTextField.copyIcon.tooltip")));
        this.copyLabel.setGraphic((Node)GUIUtil.getCopyIcon());
        this.copyLabel.setCursor(Cursor.HAND);
        AnchorPane.setRightAnchor((Node)this.copyLabel, (Double)30.0);
        Tooltip tooltip = new Tooltip(Res.get((String)"txIdTextField.blockExplorerIcon.tooltip"));
        this.blockExplorerIcon = new Label();
        this.blockExplorerIcon.getStyleClass().addAll((Object[])new String[]{"icon", "highlight"});
        this.blockExplorerIcon.setTooltip(tooltip);
        AwesomeDude.setIcon((Label)this.blockExplorerIcon, (AwesomeIcon)AwesomeIcon.EXTERNAL_LINK);
        this.blockExplorerIcon.setMinWidth(20.0);
        AnchorPane.setRightAnchor((Node)this.blockExplorerIcon, (Double)52.0);
        AnchorPane.setTopAnchor((Node)this.blockExplorerIcon, (Double)9.0);
        this.missingTxWarningIcon = new Label();
        this.missingTxWarningIcon.getStyleClass().addAll((Object[])new String[]{"icon", "error-icon"});
        AwesomeDude.setIcon((Label)this.missingTxWarningIcon, (AwesomeIcon)AwesomeIcon.WARNING_SIGN);
        this.missingTxWarningIcon.setTooltip(new Tooltip(Res.get((String)"txIdTextField.missingTx.warning.tooltip")));
        this.missingTxWarningIcon.setMinWidth(20.0);
        AnchorPane.setRightAnchor((Node)this.missingTxWarningIcon, (Double)52.0);
        AnchorPane.setTopAnchor((Node)this.missingTxWarningIcon, (Double)9.0);
        this.missingTxWarningIcon.setVisible(false);
        this.missingTxWarningIcon.setManaged(false);
        this.textField = new JFXTextField();
        this.textField.setId("address-text-field");
        this.textField.setEditable(false);
        this.textField.setTooltip(tooltip);
        AnchorPane.setRightAnchor((Node)this.textField, (Double)80.0);
        AnchorPane.setLeftAnchor((Node)this.textField, (Double)0.0);
        this.textField.focusTraversableProperty().set(this.focusTraversableProperty().get());
        this.getChildren().addAll((Object[])new Node[]{this.textField, this.missingTxWarningIcon, this.blockExplorerIcon, this.copyLabel, this.txConfidenceIndicator});
    }

    public void setup(@Nullable String txId) {
        this.setup(txId, null);
    }

    public void setup(final @Nullable String txId, final Trade trade) {
        this.trade = trade;
        if (this.walletListener != null) {
            xmrWalletService.removeWalletListener((MoneroWalletListenerI)this.walletListener);
            this.walletListener = null;
        }
        if (this.tradeListener != null) {
            trade.getDepositTxsUpdateCounter().removeListener(this.tradeListener);
            this.tradeListener = null;
        }
        if (txId == null) {
            this.textField.setText(Res.get((String)"shared.na"));
            this.textField.setId("address-text-field-error");
            this.blockExplorerIcon.setVisible(false);
            this.blockExplorerIcon.setManaged(false);
            this.copyLabel.setVisible(false);
            this.copyLabel.setManaged(false);
            this.txConfidenceIndicator.setVisible(false);
            this.missingTxWarningIcon.setVisible(true);
            this.missingTxWarningIcon.setManaged(true);
            return;
        }
        if (trade == null) {
            this.walletListener = new MoneroWalletListener(){

                public void onNewBlock(long height) {
                    TxIdTextField.this.updateConfidence(txId, trade, false, height);
                }
            };
            xmrWalletService.addWalletListener((MoneroWalletListenerI)this.walletListener);
        } else {
            this.tradeListener = (observable, oldValue, newValue) -> this.updateConfidence(txId, trade, null, null);
            trade.getDepositTxsUpdateCounter().addListener(this.tradeListener);
        }
        this.textField.setText(txId);
        this.textField.setOnMouseClicked(mouseEvent -> this.openBlockExplorer(txId));
        this.blockExplorerIcon.setOnMouseClicked(mouseEvent -> this.openBlockExplorer(txId));
        this.copyLabel.setOnMouseClicked(e -> {
            Utilities.copyToClipboard((String)txId);
            Tooltip tp = new Tooltip(Res.get((String)"shared.copiedToClipboard"));
            Node node = (Node)e.getSource();
            UserThread.runAfter(() -> tp.hide(), (long)1L);
            tp.show(node, e.getScreenX() + Layout.PADDING, e.getScreenY() + Layout.PADDING);
        });
        this.txConfidenceIndicator.setVisible(true);
        new Thread(() -> this.updateConfidence(txId, trade, true, null)).start();
    }

    public void cleanup() {
        if (xmrWalletService != null && this.walletListener != null) {
            xmrWalletService.removeWalletListener((MoneroWalletListenerI)this.walletListener);
            this.walletListener = null;
        }
        if (this.tradeListener != null) {
            this.trade.getDepositTxsUpdateCounter().removeListener(this.tradeListener);
            this.tradeListener = null;
        }
        this.trade = null;
        this.textField.setOnMouseClicked(null);
        this.blockExplorerIcon.setOnMouseClicked(null);
        this.copyLabel.setOnMouseClicked(null);
        this.textField.setText("");
    }

    private void openBlockExplorer(String txId) {
        if (preferences != null) {
            BlockChainExplorer blockChainExplorer = preferences.getBlockChainExplorer();
            GUIUtil.openWebPage(blockChainExplorer.txUrl + txId, false);
        }
    }

    private synchronized void updateConfidence(String txId, Trade trade, Boolean useCache, Long height) {
        MoneroTx tx = null;
        try {
            if (trade == null) {
                MoneroTx moneroTx = tx = useCache != false ? xmrWalletService.getDaemonTxWithCache(txId) : xmrWalletService.getDaemonTx(txId);
                tx.setNumConfirmations(Long.valueOf(tx.isConfirmed() != false ? (height == null ? xmrWalletService.getXmrConnectionService().getLastInfo().getHeight() : height) - tx.getHeight() : 0L));
            } else if (txId.equals(trade.getMaker().getDepositTxHash())) {
                tx = trade.getMakerDepositTx();
            } else if (txId.equals(trade.getTaker().getDepositTxHash())) {
                tx = trade.getTakerDepositTx();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateConfidence(tx, trade);
    }

    private void updateConfidence(MoneroTx tx, Trade trade) {
        UserThread.execute(() -> {
            GUIUtil.updateConfidence(tx, trade, this.progressIndicatorTooltip, this.txConfidenceIndicator);
            if (this.txConfidenceIndicator.getProgress() != 0.0) {
                AnchorPane.setRightAnchor((Node)this.txConfidenceIndicator, (Double)0.0);
            }
            if (this.txConfidenceIndicator.getProgress() >= 1.0 && this.walletListener != null) {
                xmrWalletService.removeWalletListener((MoneroWalletListenerI)this.walletListener);
                this.walletListener = null;
            }
        });
    }

    public static void setPreferences(Preferences preferences) {
        TxIdTextField.preferences = preferences;
    }

    public static void setXmrWalletService(XmrWalletService xmrWalletService) {
        TxIdTextField.xmrWalletService = xmrWalletService;
    }

    public TextField getTextField() {
        return this.textField;
    }
}

