/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;

public class TitledGroupBg
extends Pane {
    private final HBox box;
    private final Label label;
    private final StringProperty text = new SimpleStringProperty();
    private Text helpIcon;

    public TitledGroupBg() {
        GridPane.setMargin((Node)this, (Insets)new Insets(-10.0, -10.0, -10.0, -10.0));
        GridPane.setColumnSpan((Node)this, (Integer)2);
        this.box = new HBox();
        this.box.setSpacing(4.0);
        this.box.setLayoutX(4.0);
        this.box.setLayoutY(-8.0);
        this.box.setPadding(new Insets(0.0, 7.0, 0.0, 5.0));
        this.box.setAlignment(Pos.CENTER_LEFT);
        this.label = new AutoTooltipLabel();
        this.label.textProperty().bind((ObservableValue)this.text);
        this.setActive();
        this.box.getChildren().add((Object)this.label);
        this.getChildren().add((Object)this.box);
    }

    public void setInactive() {
        this.resetStyles();
        this.getStyleClass().add((Object)"titled-group-bg");
        this.label.getStyleClass().add((Object)"titled-group-bg-label");
    }

    private void resetStyles() {
        this.getStyleClass().removeAll((Object[])new String[]{"titled-group-bg", "titled-group-bg-active"});
        this.label.getStyleClass().removeAll((Object[])new String[]{"titled-group-bg-label", "titled-group-bg-label-active"});
    }

    private void setActive() {
        this.resetStyles();
        this.getStyleClass().add((Object)"titled-group-bg-active");
        this.label.getStyleClass().add((Object)"titled-group-bg-label-active");
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public void setText(String text) {
        this.text.set((Object)text);
    }

    public void setHelpUrl(String helpUrl) {
        if (this.helpIcon == null) {
            this.helpIcon = FormBuilder.getIcon((GlyphIcons)MaterialDesignIcon.HELP_CIRCLE_OUTLINE, "1em");
            this.helpIcon.getStyleClass().addAll((Object[])new String[]{"icon", "link-icon"});
            this.box.getChildren().add((Object)this.helpIcon);
        }
        this.helpIcon.setOnMouseClicked(e -> GUIUtil.openWebPage(helpUrl));
    }
}

