/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import com.jfoenix.controls.JFXTextField;
import haveno.common.UserThread;
import haveno.common.util.Utilities;
import haveno.core.locale.Res;
import haveno.desktop.util.GUIUtil;
import haveno.desktop.util.Layout;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;

public class TextFieldWithCopyIcon
extends AnchorPane {
    private final StringProperty text = new SimpleStringProperty();
    private final TextField textField;
    private boolean copyWithoutCurrencyPostFix;
    private boolean copyTextAfterDelimiter;

    public TextFieldWithCopyIcon() {
        this(null);
    }

    public TextFieldWithCopyIcon(String customStyleClass) {
        Label copyLabel = new Label();
        copyLabel.setLayoutY(9.0);
        copyLabel.getStyleClass().addAll((Object[])new String[]{"icon", "highlight"});
        if (customStyleClass != null) {
            copyLabel.getStyleClass().add((Object)(customStyleClass + "-icon"));
        }
        copyLabel.setTooltip(new Tooltip(Res.get((String)"shared.copyToClipboard")));
        copyLabel.setGraphic((Node)GUIUtil.getCopyIcon());
        copyLabel.setOnMouseClicked(e -> {
            String text = this.getText();
            if (text != null && text.length() > 0) {
                String[] strings;
                String copyText = this.copyWithoutCurrencyPostFix ? ((strings = text.split(" ")).length > 1 ? strings[0] : text) : (this.copyTextAfterDelimiter ? ((strings = text.split(" ")).length > 1 ? strings[2] : text) : text);
                Utilities.copyToClipboard((String)copyText);
                Tooltip tp = new Tooltip(Res.get((String)"shared.copiedToClipboard"));
                Node node = (Node)e.getSource();
                UserThread.runAfter(() -> tp.hide(), (long)1L);
                tp.show(node, e.getScreenX() + Layout.PADDING, e.getScreenY() + Layout.PADDING);
            }
        });
        this.textField = new JFXTextField();
        this.textField.setEditable(false);
        if (customStyleClass != null) {
            this.textField.getStyleClass().add((Object)customStyleClass);
        }
        this.textField.textProperty().bindBidirectional((Property)this.text);
        AnchorPane.setRightAnchor((Node)copyLabel, (Double)5.0);
        AnchorPane.setRightAnchor((Node)this.textField, (Double)30.0);
        AnchorPane.setLeftAnchor((Node)this.textField, (Double)0.0);
        AnchorPane.setTopAnchor((Node)copyLabel, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)copyLabel, (Double)0.0);
        AnchorPane.setTopAnchor((Node)this.textField, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.textField, (Double)0.0);
        this.textField.focusTraversableProperty().set(this.focusTraversableProperty().get());
        this.getChildren().addAll((Object[])new Node[]{this.textField, copyLabel});
    }

    public void setPromptText(String value) {
        this.textField.setPromptText(value);
    }

    public String getText() {
        return (String)this.text.get();
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public void setText(String text) {
        this.text.set((Object)text);
    }

    public void setTooltip(Tooltip toolTip) {
        this.textField.setTooltip(toolTip);
    }

    public void setCopyWithoutCurrencyPostFix(boolean copyWithoutCurrencyPostFix) {
        this.copyWithoutCurrencyPostFix = copyWithoutCurrencyPostFix;
    }

    public void setCopyTextAfterDelimiter(boolean copyTextAfterDelimiter) {
        this.copyTextAfterDelimiter = copyTextAfterDelimiter;
    }
}

