/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import haveno.desktop.components.AutoTooltipLabel;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableGroupHeadline
extends Pane {
    private static final Logger log = LoggerFactory.getLogger(TableGroupHeadline.class);
    private final Label label;
    private final StringProperty text = new SimpleStringProperty();

    public TableGroupHeadline() {
        this("");
    }

    public TableGroupHeadline(String title) {
        this.text.set((Object)title);
        GridPane.setMargin((Node)this, (Insets)new Insets(-10.0, -10.0, -10.0, -10.0));
        GridPane.setColumnSpan((Node)this, (Integer)2);
        StackPane bg = new StackPane();
        bg.setId("table-group-headline");
        bg.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        bg.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        this.label = new AutoTooltipLabel();
        this.label.textProperty().bind((ObservableValue)this.text);
        this.label.setLayoutX(8.0);
        this.label.setPadding(new Insets(-8.0, 7.0, 0.0, 5.0));
        this.setActive();
        this.getChildren().addAll((Object[])new Node[]{bg, this.label});
    }

    public void setInactive() {
        this.setId("titled-group-bg");
        this.label.setId("titled-group-bg-label");
    }

    private void setActive() {
        this.setId("titled-group-bg-active");
        this.label.setId("titled-group-bg-label-active");
        this.label.getStyleClass().add((Object)"highlight-static");
    }

    public String getText() {
        return (String)this.text.get();
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public void setText(String text) {
        this.text.set((Object)text);
    }
}

