/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import haveno.core.util.SimpleMarkdownParser;
import haveno.desktop.util.GUIUtil;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.control.Hyperlink;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;

public class SimpleMarkdownLabel
extends TextFlow {
    public SimpleMarkdownLabel(String markdown) {
        this.getStyleClass().add((Object)"markdown-label");
        if (markdown != null) {
            this.updateContent(markdown);
        }
    }

    public void updateContent(String markdown) {
        List items = SimpleMarkdownParser.parse((String)markdown).stream().map(node -> {
            if (node instanceof SimpleMarkdownParser.HyperlinkNode) {
                SimpleMarkdownParser.HyperlinkNode item = (SimpleMarkdownParser.HyperlinkNode)node;
                Hyperlink hyperlink = new Hyperlink(item.getText());
                hyperlink.setOnAction(e -> GUIUtil.openWebPage(item.getHref()));
                return hyperlink;
            }
            SimpleMarkdownParser.TextNode item = (SimpleMarkdownParser.TextNode)node;
            return new Text(item.getText());
        }).collect(Collectors.toList());
        this.getChildren().setAll(items);
    }
}

