/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import haveno.common.UserThread;
import haveno.desktop.components.controlsfx.control.PopOver;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class PopOverWrapper {
    private PopOver popover;
    private Supplier<PopOver> popoverSupplier;
    private boolean hidePopover;
    private PopOverState state = PopOverState.HIDDEN;

    public void showPopOver(Supplier<PopOver> popoverSupplier) {
        this.popoverSupplier = popoverSupplier;
        this.hidePopover = false;
        if (this.state == PopOverState.HIDDEN) {
            this.state = PopOverState.SHOWING;
            this.popover = popoverSupplier.get();
            UserThread.runAfter(() -> {
                this.state = PopOverState.SHOWN;
                if (this.hidePopover) {
                    this.hidePopOver();
                }
            }, (long)25L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    public void hidePopOver() {
        this.hidePopover = true;
        if (this.state == PopOverState.SHOWN) {
            this.state = PopOverState.HIDING;
            this.popover.hide();
            UserThread.runAfter(() -> {
                this.state = PopOverState.HIDDEN;
                if (!this.hidePopover) {
                    this.showPopOver(this.popoverSupplier);
                }
            }, (long)250L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    static enum PopOverState {
        HIDDEN,
        SHOWING,
        SHOWN,
        HIDING;

    }
}

