/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import com.google.common.base.Preconditions;
import haveno.common.util.Tuple5;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.alert.PrivateNotificationManager;
import haveno.core.locale.Res;
import haveno.core.offer.Offer;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.trade.Trade;
import haveno.core.user.Preferences;
import haveno.desktop.components.PeerInfoIcon;
import haveno.desktop.util.Colors;
import haveno.network.p2p.NodeAddress;
import java.util.Date;
import javafx.scene.paint.Color;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerInfoIconTrading
extends PeerInfoIcon {
    private static final Logger log = LoggerFactory.getLogger(PeerInfoIconTrading.class);
    private final AccountAgeWitnessService accountAgeWitnessService;
    private boolean isTraditionalCurrency;

    public PeerInfoIconTrading(NodeAddress nodeAddress, String role, int numTrades, PrivateNotificationManager privateNotificationManager, Offer offer, Preferences preferences, AccountAgeWitnessService accountAgeWitnessService, boolean useDevPrivilegeKeys) {
        this(nodeAddress, role, numTrades, privateNotificationManager, offer, null, preferences, accountAgeWitnessService, useDevPrivilegeKeys);
    }

    public PeerInfoIconTrading(NodeAddress nodeAddress, String role, int numTrades, PrivateNotificationManager privateNotificationManager, Trade Trade2, Preferences preferences, AccountAgeWitnessService accountAgeWitnessService, boolean useDevPrivilegeKeys) {
        this(nodeAddress, role, numTrades, privateNotificationManager, Trade2.getOffer(), Trade2, preferences, accountAgeWitnessService, useDevPrivilegeKeys);
    }

    private PeerInfoIconTrading(NodeAddress nodeAddress, String role, int numTrades, PrivateNotificationManager privateNotificationManager, @Nullable Offer offer, @Nullable Trade trade, Preferences preferences, AccountAgeWitnessService accountAgeWitnessService, boolean useDevPrivilegeKeys) {
        super(nodeAddress, preferences);
        this.numTrades = numTrades;
        this.accountAgeWitnessService = accountAgeWitnessService;
        if (offer == null) {
            Preconditions.checkNotNull((Object)trade, (Object)"Trade must not be null if offer is null.");
            offer = trade.getOffer();
        }
        Preconditions.checkNotNull((Object)offer, (Object)"Offer must not be null");
        this.isTraditionalCurrency = offer.isTraditionalOffer();
        this.initialize(role, offer, trade, privateNotificationManager, useDevPrivilegeKeys);
    }

    protected void initialize(String role, Offer offer, Trade trade, PrivateNotificationManager privateNotificationManager, boolean useDevPrivilegeKeys) {
        boolean hasTraded = this.numTrades > 0;
        Tuple5<Long, Long, String, String, String> peersAccount = this.getPeersAccountAge(trade, offer);
        Long accountAge = (Long)peersAccount.first;
        Long signAge = (Long)peersAccount.second;
        this.tooltipText = hasTraded ? Res.get((String)"peerInfoIcon.tooltip.trade.traded", (Object[])new Object[]{role, this.fullAddress, this.numTrades, this.getAccountAgeTooltip(accountAge)}) : Res.get((String)"peerInfoIcon.tooltip.trade.notTraded", (Object[])new Object[]{role, this.fullAddress, this.getAccountAgeTooltip(accountAge)});
        this.createAvatar(this.getRingColor(offer, trade, accountAge, signAge));
        this.addMouseListener(this.numTrades, privateNotificationManager, trade, offer, this.preferences, useDevPrivilegeKeys, this.isTraditionalCurrency, accountAge, signAge, (String)peersAccount.third, (String)peersAccount.fourth, (String)peersAccount.fifth);
    }

    @Override
    protected String getAccountAgeTooltip(Long accountAge) {
        return this.isTraditionalCurrency ? super.getAccountAgeTooltip(accountAge) : "";
    }

    protected Color getRingColor(Offer offer, Trade Trade2, Long accountAge, Long signAge) {
        Color ringColor = Colors.AVATAR_GREEN;
        if (this.isTraditionalCurrency) {
            switch (this.accountAgeWitnessService.getPeersAccountAgeCategory((PeerInfoIconTrading.hasChargebackRisk(Trade2, offer) ? signAge : accountAge).longValue())) {
                case TWO_MONTHS_OR_MORE: {
                    ringColor = Colors.AVATAR_GREEN;
                    break;
                }
                case ONE_TO_TWO_MONTHS: {
                    ringColor = Colors.AVATAR_BLUE;
                    break;
                }
                case LESS_ONE_MONTH: {
                    ringColor = Colors.AVATAR_ORANGE;
                    break;
                }
                default: {
                    ringColor = Colors.AVATAR_RED;
                }
            }
        }
        return ringColor;
    }

    private Tuple5<Long, Long, String, String, String> getPeersAccountAge(@Nullable Trade Trade2, @Nullable Offer offer) {
        AccountAgeWitnessService.SignState signState = null;
        long signAge = -1L;
        long accountAge = -1L;
        if (Trade2 != null) {
            offer = Trade2.getOffer();
            if (offer == null) {
                return new Tuple5((Object)signAge, (Object)accountAge, (Object)Res.get((String)"peerInfo.age.noRisk"), null, null);
            }
            if (Trade2 instanceof Trade) {
                Trade trade = Trade2;
                signState = this.accountAgeWitnessService.getSignState(trade);
                signAge = this.accountAgeWitnessService.getWitnessSignAge(trade, new Date());
                accountAge = this.accountAgeWitnessService.getAccountAge(trade);
            }
        } else {
            Preconditions.checkNotNull((Object)offer, (Object)"Offer must not be null if trade is null.");
            signState = this.accountAgeWitnessService.getSignState(offer);
            signAge = this.accountAgeWitnessService.getWitnessSignAge(offer, new Date());
            accountAge = this.accountAgeWitnessService.getAccountAge(offer);
        }
        if (signState != null && PeerInfoIconTrading.hasChargebackRisk(Trade2, offer)) {
            String signAgeInfo = Res.get((String)"peerInfo.age.chargeBackRisk");
            String accountSigningState = StringUtils.capitalize((String)signState.getDisplayString());
            if (signState.equals((Object)AccountAgeWitnessService.SignState.UNSIGNED)) {
                signAgeInfo = null;
            }
            return new Tuple5((Object)accountAge, (Object)signAge, (Object)Res.get((String)"peerInfo.age.noRisk"), (Object)signAgeInfo, (Object)accountSigningState);
        }
        return new Tuple5((Object)accountAge, (Object)signAge, (Object)Res.get((String)"peerInfo.age.noRisk"), null, null);
    }

    private static boolean hasChargebackRisk(@Nullable Trade Trade2, @Nullable Offer offer) {
        Offer offerToCheck = Trade2 != null ? Trade2.getOffer() : offer;
        return offerToCheck != null && PaymentMethod.hasChargebackRisk((PaymentMethod)offerToCheck.getPaymentMethod(), (String)offerToCheck.getCounterCurrencyCode());
    }
}

